/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.primitive;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtButtonAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtComboAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.editors.ui.SwtDatePickerAdapter;
import org.eclipse.stardust.modeling.core.editors.ui.SwtVerifierTextAdapter;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.PrimitiveDataModelAdapter;
import org.eclipse.stardust.modeling.core.ui.PrimitiveDataWidgetAdapter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PrimitivePropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final Type[] TYPES = new Type[]{Type.Calendar, Type.String, Type.Timestamp, Type.Boolean, Type.Byte, Type.Char, Type.Double, Type.Float, Type.Integer, Type.Long, Type.Short};
    private ComboViewer typeViewer;
    private Composite valueComposite;
    private Map<Type, Object> valueControlsMap = CollectionUtils.newHashMap();

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager binding = this.getWidgetBindingManager();
        binding.getModelBindingManager().bind((IModelAdapter)new PrimitiveDataModelAdapter(ModelUtils.findContainingModel((EObject)element), Arrays.asList(TYPES), (IExtensibleElement)element), (IWidgetAdapter)new PrimitiveDataWidgetAdapter(this.typeViewer, this.valueComposite, this.valueControlsMap));
        binding.getModelBindingManager().bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:type", false), (IWidgetAdapter)this.getSwtComboAdapter());
        int i = 0;
        while (i < TYPES.length) {
            Object control = this.valueControlsMap.get(TYPES[i]);
            if (TYPES[i].equals((Object)Type.Timestamp) || TYPES[i].equals((Object)Type.Calendar)) {
                Button resetBtn = null;
                DatePickerCombo datePickerCombo = ((DatePickerComposite)control).getCalendarCombo();
                resetBtn = ((DatePickerComposite)control).getResetBtn();
                binding.getModelBindingManager().bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtDatePickerAdapter(datePickerCombo, resetBtn));
            } else if (TYPES[i].equals((Object)Type.Boolean)) {
                Button button = (Button)control;
                binding.getModelBindingManager().bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtButtonAdapter(button));
            } else {
                Type type = TYPES[i];
                Text text = (Text)control;
                binding.getModelBindingManager().bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtVerifierTextAdapter(type, text));
            }
            ++i;
        }
        if (this.isPredefined(element)) {
            this.disableControls();
        }
    }

    private SwtVerifierTextAdapter getSwtVerifierTextAdapter(final Type type, Text text) {
        return new SwtVerifierTextAdapter(text){

            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (type.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtButtonAdapter getSwtButtonAdapter(Button b) {
        return new SwtButtonAdapter(b){

            public void bind(IBindingMediator manager) {
                super.bind(manager);
                final Button button = (Button)this.getWidget();
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.updateModel(button.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    }
                });
            }

            public void updateControl(Object value) {
                Type selectedType;
                if (value != null && !(value instanceof Boolean)) {
                    Object object = value = "true".equalsIgnoreCase(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Type.Boolean.equals((Object)(selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement()))) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtDatePickerAdapter getSwtDatePickerAdapter(DatePickerCombo datePickerCombo, Button resetBtn) {
        return new SwtDatePickerAdapter(datePickerCombo, resetBtn){

            @Override
            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (Type.Calendar.equals((Object)selectedType) || Type.Timestamp.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtComboAdapter getSwtComboAdapter() {
        return new SwtComboAdapter(this.typeViewer.getCombo()){

            public void updateControl(Object value) {
                super.updateControl(value);
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                selectedType = selectedType == null ? Type.String : selectedType;
                Object object = PrimitivePropertyPage.this.valueControlsMap.get(selectedType);
                ((StackLayout)((PrimitivePropertyPage)PrimitivePropertyPage.this).valueComposite.getLayout()).topControl = object instanceof DatePickerComposite ? ((DatePickerComposite)object).getCalendarComposite() : (Control)object;
                PrimitivePropertyPage.this.valueComposite.layout();
            }
        };
    }

    private void disableControls() {
        this.typeViewer.getCombo().setEnabled(false);
        for (Object obj : this.valueControlsMap.values()) {
            Control control;
            Object object = control = obj instanceof DatePickerComposite ? ((DatePickerComposite)obj).getCalendarComposite() : (Control)obj;
            if (control instanceof Text) {
                ((Text)control).setEditable(false);
                continue;
            }
            if (control instanceof Button) {
                ((Button)control).setEnabled(false);
                continue;
            }
            if (!(control instanceof DatePickerCombo)) continue;
            ((DatePickerCombo)control).setEnabled(false);
        }
    }

    private boolean isPredefined(IModelElement element) {
        return ((DataType)element).isPredefined();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_SPI_Type);
        this.typeViewer = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object type) {
                return ((Type)type).getId();
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_DefaultValue);
        this.valueComposite = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        if (this.typeViewer.getCombo().getBounds().height > 0) {
            gd.heightHint = this.typeViewer.getCombo().getBounds().height;
        }
        gd.horizontalAlignment = 4;
        this.valueComposite.setLayoutData((Object)gd);
        StackLayout layout = new StackLayout();
        this.valueComposite.setLayout((Layout)layout);
        DatePickerComposite calendarComposite = this.createDatePickerComposite();
        this.valueControlsMap.put(TYPES[0], calendarComposite);
        this.valueControlsMap.put(TYPES[1], FormBuilder.createText((Composite)this.valueComposite));
        DatePickerComposite timestampComposite = this.createDatePickerComposite();
        this.valueControlsMap.put(TYPES[2], timestampComposite);
        this.valueControlsMap.put(TYPES[3], new Button(this.valueComposite, 32));
        this.valueControlsMap.put(TYPES[4], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[4])).addVerifyListener((VerifyListener)VerifierFactory.byteVerifier);
        this.valueControlsMap.put(TYPES[5], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[5])).setTextLimit(1);
        this.valueControlsMap.put(TYPES[6], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[6])).addVerifyListener((VerifyListener)VerifierFactory.doubleVerifier);
        this.valueControlsMap.put(TYPES[7], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[7])).addVerifyListener((VerifyListener)VerifierFactory.floatVerifier);
        this.valueControlsMap.put(TYPES[8], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[8])).addVerifyListener((VerifyListener)VerifierFactory.intVerifier);
        this.valueControlsMap.put(TYPES[9], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[9])).addVerifyListener((VerifyListener)VerifierFactory.longVerifier);
        this.valueControlsMap.put(TYPES[10], FormBuilder.createText((Composite)this.valueComposite));
        ((Text)this.valueControlsMap.get(TYPES[10])).addVerifyListener((VerifyListener)VerifierFactory.shortVerifier);
        return composite;
    }

    private DatePickerComposite createDatePickerComposite() {
        Composite calendarComposite = new Composite(this.valueComposite, 0);
        GridData gdCal = new GridData();
        gdCal.grabExcessHorizontalSpace = true;
        gdCal.horizontalAlignment = 4;
        calendarComposite.setLayoutData((Object)gdCal);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        calendarComposite.setLayout((Layout)gl);
        GridData gdDP = new GridData();
        gdDP.grabExcessHorizontalSpace = true;
        gdDP.horizontalAlignment = 4;
        DatePickerCombo calendarCombo = new DatePickerCombo(calendarComposite, 2048);
        calendarCombo.setLayoutData((Object)gdDP);
        calendarCombo.setEditable(false);
        calendarCombo.setDateFormat((DateFormat)new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY));
        Button resetButton = new Button(calendarComposite, 0);
        resetButton.setText(Diagram_Messages.BUT_RESET);
        GridData gdBtn = new GridData();
        gdBtn.grabExcessVerticalSpace = true;
        resetButton.setLayoutData((Object)gdBtn);
        DatePickerComposite datePickerComposite = new DatePickerComposite(calendarComposite, calendarCombo, resetButton);
        return datePickerComposite;
    }

    public class DatePickerComposite {
        private final Composite calendarComposite;
        private final DatePickerCombo calendarCombo;
        private final Button resetBtn;

        public DatePickerComposite(Composite calendarComposite, DatePickerCombo calendarCombo, Button resetBtn) {
            this.calendarComposite = calendarComposite;
            this.calendarCombo = calendarCombo;
            this.resetBtn = resetBtn;
        }

        public Button getResetBtn() {
            return this.resetBtn;
        }

        public Composite getCalendarComposite() {
            return this.calendarComposite;
        }

        public DatePickerCombo getCalendarCombo() {
            return this.calendarCombo;
        }
    }
}

