/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementValueAdapter;

public class ExtensibleElementAdapter
extends AdapterImpl
implements IModelAdapter {
    private final EObject model;
    private final String feature;
    private boolean isBoolean;
    private List list;
    private EObject scope;
    private EStructuralFeature scopeFeature;
    private final ExtensibleElementValueAdapter modelValueAdapter;
    private IBindingMediator manager;
    private AttributeType attribute;

    public ExtensibleElementAdapter(EObject model, String feature, boolean isBoolean) {
        this(model, feature, isBoolean, ExtensibleElementValueAdapter.INSTANCE);
    }

    public ExtensibleElementAdapter(EObject model, String feature, boolean isBoolean, ExtensibleElementValueAdapter modelValueAdapter) {
        this.model = model;
        this.feature = feature;
        this.isBoolean = isBoolean;
        this.modelValueAdapter = modelValueAdapter;
    }

    public ExtensibleElementAdapter(EObject model, String feature, EObject scope, EStructuralFeature scopeFeature) {
        this(model, feature, scope, scopeFeature, ExtensibleElementValueAdapter.INSTANCE);
    }

    public ExtensibleElementAdapter(EObject model, String feature, EObject scope, EStructuralFeature scopeFeature, ExtensibleElementValueAdapter modelValueAdapter) {
        this.model = model;
        this.feature = feature;
        this.scope = scope;
        this.scopeFeature = scopeFeature;
        this.modelValueAdapter = modelValueAdapter;
    }

    public ExtensibleElementAdapter(EObject model, String feature, List scope) {
        this(model, feature, scope, ExtensibleElementValueAdapter.INSTANCE);
    }

    public ExtensibleElementAdapter(EObject model, String feature, List scope, ExtensibleElementValueAdapter modelValueAdapter) {
        this.model = model;
        this.feature = feature;
        this.list = scope;
        this.modelValueAdapter = modelValueAdapter;
    }

    public EObject getEModel() {
        return this.model;
    }

    public void bind(IBindingMediator manager) {
        this.manager = manager;
        if (!this.model.eAdapters().contains((Object)this)) {
            this.model.eAdapters().add((Object)this);
            if (this.model instanceof IExtensibleElement) {
                this.connect();
            }
        }
    }

    private void connect() {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)this.model), (String)this.feature);
        if (attribute != this.attribute) {
            this.disconnect();
            if (attribute != null) {
                attribute.eAdapters().add((Object)this);
            }
            this.attribute = attribute;
        }
    }

    private void disconnect() {
        if (this.attribute != null) {
            this.attribute.eAdapters().remove((Object)this);
        }
    }

    public void unbind() {
        this.model.eAdapters().remove((Object)this);
        if (this.model instanceof IExtensibleElement) {
            this.disconnect();
        }
        this.manager = null;
    }

    public Object getModel() {
        return this.model;
    }

    public Object getValue() {
        Object result = null;
        if (this.feature == null) {
            result = this.model;
        } else if (this.model instanceof IExtensibleElement) {
            this.connect();
            if (this.isBoolean) {
                result = this.getBoolean();
            } else if (this.attribute != null) {
                if (this.attribute.getReference() != null) {
                    result = this.attribute.getReference().getIdentifiable();
                } else {
                    result = this.attribute.getValue();
                    if (this.scope != null) {
                        result = ModelUtils.findIdentifiableElement((EObject)this.scope, (EStructuralFeature)this.scopeFeature, (String)((String)result));
                    } else if (this.list != null) {
                        result = ModelUtils.findIdentifiableElement((List)this.list, (String)((String)result));
                    }
                }
            }
        }
        if (this.modelValueAdapter != null) {
            result = this.modelValueAdapter.fromModel(this, result);
        }
        return result;
    }

    private Boolean getBoolean() {
        return AttributeUtil.getBooleanValue((AttributeType)this.attribute) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void updateModel(Object value) {
        Object oldValue;
        if (this.model != null && this.feature != null && !CompareHelper.areEqual((Object)(oldValue = this.getValue()), (Object)value)) {
            Object newValue;
            Object object = newValue = this.modelValueAdapter != null ? this.modelValueAdapter.toModel(this, value) : value;
            if (this.isBoolean) {
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)this.model), (String)this.feature, (Boolean)(newValue == null ? false : (Boolean)newValue));
            } else if (this.attribute == null) {
                if (AttributeUtil.isReference((IExtensibleElement)((IExtensibleElement)this.model), (String)this.feature)) {
                    AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)this.model), (String)this.feature, (EObject)((IIdentifiableElement)newValue));
                } else {
                    if ((this.scope != null || this.list != null) && newValue instanceof IIdentifiableElement) {
                        newValue = ((IIdentifiableElement)newValue).getId();
                    }
                    AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.model), (String)this.feature, (String)(newValue == null ? null : newValue.toString()));
                }
                this.connect();
            } else if (AttributeUtil.isReference((AttributeType)this.attribute)) {
                AttributeUtil.setReference((AttributeType)this.attribute, (EObject)((EObject)newValue));
            } else {
                if ((this.scope != null || this.list != null) && newValue instanceof IIdentifiableElement) {
                    newValue = ((IIdentifiableElement)newValue).getId();
                }
                this.attribute.setValue(newValue == null ? null : newValue.toString());
            }
        }
    }

    public void updateVisuals(Object value) {
        this.manager.updateWidget((IModelAdapter)this, value);
    }

    public void notifyChanged(Notification msg) {
        if (8 != msg.getEventType() && (this.feature == null || CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute().equals(msg.getFeature()) || msg.getNotifier() instanceof AttributeType)) {
            if (this.feature != null && CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute().equals(msg.getFeature())) {
                switch (msg.getEventType()) {
                    case 4: 
                    case 6: {
                        Object oldObject = msg.getOldValue();
                        if (oldObject != this.attribute) break;
                        this.disconnect();
                    }
                }
            }
            if (this.feature == null || this.attribute == msg.getNotifier()) {
                this.updateVisuals(this.getValue());
            }
        }
    }

    public Object getFeature() {
        return this.feature;
    }
}

