/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XpdlSwitch;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XsdIconProvider;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XsdTextProvider;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.stardust.modeling.data.structured.properties.DefaultValueModifier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;

public class StructLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String[] COMPLEX_TYPE_COLUMNS = new String[]{Structured_Messages.NameColumnLabel, Structured_Messages.TypeColumnLabel, Structured_Messages.CardinalityColumnLabel};
    public static final String[] SIMPLE_TYPE_COLUMNS = new String[]{Structured_Messages.ValuesColumnLabel};
    public static final String[] DEFAULT_CARDINALITY_LABELS = new String[]{Structured_Messages.CardinalityRequiredLabel, Structured_Messages.CardinalityOptionalLabel, Structured_Messages.CardinalityManyLabel, Structured_Messages.CardinalityAtLeastOneLabel};
    private XsdIconProvider xsdIconProvider = new XsdIconProvider();
    private XpdlIconProvider xpdlIconProvider = new XpdlIconProvider();
    private XsdTextProvider xsdTextProvider = new XsdTextProvider();
    private XpdlTextProvider xpdlTextProvider;
    private int column;
    private Tree tree;
    private boolean showGroupInfo = false;
    private ModelType model;

    public StructLabelProvider() {
        this.xsdTextProvider.CARDINALITY_LABELS = DEFAULT_CARDINALITY_LABELS;
        this.xpdlTextProvider = new XpdlTextProvider();
    }

    public StructLabelProvider(Tree tree) {
        this();
        this.tree = tree;
    }

    public void setShowGroupInfo(boolean showGroupInfo) {
        this.showGroupInfo = showGroupInfo;
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        String iconLocation;
        if (columnIndex == 0 && element instanceof EObject && (iconLocation = (String)this.xpdlIconProvider.doSwitch((EObject)element)) != null) {
            return DiagramPlugin.getImage((String)iconLocation);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        TreeColumn treeColumn;
        this.column = columnIndex;
        this.xsdTextProvider.setColumn(columnIndex);
        if (this.tree != null && element instanceof XSDElementDeclaration && (treeColumn = this.tree.getColumn(this.column)).getData() instanceof IAnnotation) {
            IAnnotation annotation = (IAnnotation)treeColumn.getData();
            Object annotationValue = DefaultAnnotationModifier.getAnnotationValue(annotation, (XSDElementDeclaration)element);
            return annotationValue == null ? "" : annotationValue.toString();
        }
        if (columnIndex == 1 && element instanceof XSDEnumerationFacet || columnIndex == 3 && element instanceof XSDComponent) {
            return DefaultValueModifier.getStringForElement((XSDComponent)element);
        }
        if (element instanceof EObject) {
            String xpdlProviderText = (String)this.xpdlTextProvider.doSwitch((EObject)element);
            String xpdli18nText = this.getTextForProviderText(xpdlProviderText);
            if (xpdli18nText == null) {
                return xpdlProviderText;
            }
            return xpdli18nText;
        }
        return this.getDefaultLabel(element);
    }

    private String getTextForProviderText(String xpdlProviderText) {
        if (xpdlProviderText.equalsIgnoreCase("<sequence>")) {
            return Structured_Messages.LBL_Sequence;
        }
        return null;
    }

    private String getDefaultLabel(Object element) {
        switch (this.column) {
            case 0: {
                return element.toString();
            }
        }
        return "";
    }

    private class XpdlIconProvider
    extends XpdlSwitch<String> {
        private XpdlIconProvider() {
        }

        public String caseTypeDeclarationType(TypeDeclarationType typeDeclaration) {
            return IconFactory.getDefault().getIconFor((EObject)typeDeclaration);
        }

        public String defaultCase(EObject object) {
            return ((XsdIconProvider.XsdIcon)StructLabelProvider.this.xsdIconProvider.doSwitch(object)).getQualifiedName();
        }
    }

    private class XpdlTextProvider
    extends XpdlSwitch<String> {
        private XpdlTextProvider() {
        }

        public String caseTypeDeclarationType(TypeDeclarationType typeDeclaration) {
            switch (StructLabelProvider.this.column) {
                case 0: {
                    ModelType model;
                    String name = typeDeclaration.getName();
                    if (name == null && (name = typeDeclaration.getId()) == null) {
                        name = "<TypeDeclaration>";
                    }
                    if (StructLabelProvider.this.showGroupInfo && (model = ModelUtils.findContainingModel((EObject)typeDeclaration)) != StructLabelProvider.this.model) {
                        String modelName;
                        if (name.equals(StructuredTypeUtils.getResourceTypeDeclaration().getName())) {
                            return name;
                        }
                        String string = modelName = model == null ? "null" : model.getName();
                        if (modelName == null && (modelName = model.getId()) == null) {
                            modelName = "<Model>";
                        }
                        return String.valueOf(modelName) + " / " + name;
                    }
                    return name;
                }
            }
            return "";
        }

        public String defaultCase(EObject object) {
            return (String)StructLabelProvider.this.xsdTextProvider.doSwitch(object);
        }
    }
}

