/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.data.structured.annotations.ConfigurationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;

public class AnnotationCellEditor
implements MouseMoveListener {
    private TreeViewer viewer;
    private TreeEditor editor;
    private int column;
    private IAnnotation annotation;

    public AnnotationCellEditor(TreeViewer viewer, int column, IAnnotation annotation) {
        this.viewer = viewer;
        this.column = column;
        this.annotation = annotation;
        this.editor = new TreeEditor(viewer.getTree());
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        viewer.getTree().addMouseMoveListener((MouseMoveListener)this);
    }

    public void dispose() {
        this.stopEditing();
        this.viewer.getTree().removeMouseMoveListener((MouseMoveListener)this);
        if (this.editor != null) {
            this.editor.dispose();
        }
    }

    public void mouseMove(MouseEvent e) {
        Tree tree = this.getTree();
        TreeItem item = tree.getItem(new Point(e.x, e.y));
        if (item != null && item.getData() instanceof ConfigurationItem) {
            ConfigurationItem config = (ConfigurationItem)item.getData();
            IStatus status = config.getValidationStatus();
            tree.setToolTipText(status.isOK() ? null : status.getMessage());
        } else {
            tree.setToolTipText(null);
        }
    }

    void update(TreeItem item) {
        IAnnotation annotation;
        this.stopEditing();
        if (item == null) {
            return;
        }
        Object data = item.getData();
        IAnnotation iAnnotation = annotation = this.annotation == null ? (IAnnotation)data : this.annotation;
        if (this.annotation != null) {
            if (data instanceof XSDElementDeclaration) {
                XSDElementDeclaration decl = (XSDElementDeclaration)data;
                if (decl.getName().equalsIgnoreCase("<new>")) {
                    return;
                }
                if (decl.getType() instanceof XSDComplexTypeDefinition) {
                    return;
                }
            } else {
                return;
            }
        }
        Control control = null;
        if (DefaultAnnotationModifier.canModifyAnnotation(annotation)) {
            IAnnotationEditor editor = null;
            if (annotation instanceof ConfigurationItem) {
                editor = ((ConfigurationItem)((Object)annotation)).getEditor();
            }
            if (editor != null) {
                control = editor.createControl(this, annotation, item.getBounds());
            } else if (DefaultAnnotationModifier.isSelectionBased(annotation)) {
                CCombo combo = new CCombo((Composite)this.getTree(), 8);
                ComboViewer viewer = new ComboViewer(combo);
                viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                viewer.setInput(DefaultAnnotationModifier.getAnnotationAllowedValues(annotation));
                Object selection = DefaultAnnotationModifier.getAnnotationValue(annotation);
                viewer.setSelection((ISelection)(selection == null ? StructuredSelection.EMPTY : new StructuredSelection(selection)), true);
                viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ISelection selection = event.getSelection();
                        DefaultAnnotationModifier.setAnnotationValue(annotation, selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty() ? ((IStructuredSelection)selection).getFirstElement() : null);
                        AnnotationCellEditor.this.updateViewer(annotation);
                    }
                });
                combo.setBounds(item.getBounds());
                control = combo;
            } else {
                final Text text = new Text((Composite)this.getTree(), 0);
                Verifier verifier = DefaultAnnotationModifier.getVerifierFor(annotation);
                if (verifier != null) {
                    text.addVerifyListener((VerifyListener)verifier);
                }
                text.setText((String)DefaultAnnotationModifier.getAnnotationValue(annotation));
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        DefaultAnnotationModifier.setAnnotationValue(annotation, text.getText());
                        AnnotationCellEditor.this.updateViewer(annotation);
                    }
                });
                text.selectAll();
                text.setBounds(item.getBounds());
                control = text;
            }
        }
        if (control != null) {
            control.setFocus();
            this.editor.setEditor(control, item, this.column);
        }
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public void updateViewer(IAnnotation annotation) {
        while (annotation != null) {
            this.viewer.update((Object)annotation, (String[])this.viewer.getColumnProperties());
            annotation = annotation.getParent();
        }
    }

    void stopEditing() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }
}

