/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.data.structured.annotations.CategoryAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;

public class AnnotationContentProvider
implements ITreeContentProvider {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String STORAGE_ELEMENT = "storage";
    private static final String CATEGORY_ELEMENT = "category";
    private static final String APPLICATION_INFO_EXTENSION_ID = "org.eclipse.stardust.modeling.data.structured.applicationInfo";
    private static final String IPP_CATEGORY_ID = "org.eclipse.stardust.modeling.data.structured.applicationInfo".substring(0, "org.eclipse.stardust.modeling.data.structured.applicationInfo".lastIndexOf(46));
    private TypeDeclarationType declaration;
    private boolean isInternalSchema;
    private XSDNamedComponent root;
    private ArrayList<CategoryAnnotation> elements;
    private boolean filter;

    public void setDeclaration(TypeDeclarationType declaration) {
        this.declaration = declaration;
        this.isInternalSchema = TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)declaration);
        this.root = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)declaration);
    }

    public Object[] getChildren(Object element) {
        IAnnotation annotation = (IAnnotation)element;
        List<IAnnotation> children = annotation.getChildren();
        return children.toArray();
    }

    public Object getParent(Object element) {
        IAnnotation annotation = (IAnnotation)element;
        return annotation.getParent();
    }

    public boolean hasChildren(Object element) {
        IAnnotation annotation = (IAnnotation)element;
        return !annotation.getChildren().isEmpty();
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<CategoryAnnotation> result = new ArrayList<CategoryAnnotation>(this.elements.size());
        int i = 0;
        while (i < this.elements.size()) {
            CategoryAnnotation category = this.elements.get(i);
            if (!this.filter || !IPP_CATEGORY_ID.equals(category.getId())) {
                result.add(category);
            }
            ++i;
        }
        return result.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setCurrentElement(XSDElementDeclaration decl) {
        boolean bl = this.filter = decl != null && decl.getType() instanceof XSDComplexTypeDefinition;
        if (this.elements == null) {
            String extensionId = APPLICATION_INFO_EXTENSION_ID;
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
            this.elements = new ArrayList();
            int i = 0;
            while (i < configs.length) {
                String name = configs[i].getName();
                if (CATEGORY_ELEMENT.equals(name)) {
                    this.elements.add(new CategoryAnnotation(this, decl, configs[i]));
                }
                ++i;
            }
        } else {
            for (CategoryAnnotation annotation : this.elements) {
                annotation.setElementDeclaration(decl);
            }
        }
    }

    public void removeIPPAnnotations(XSDElementDeclaration decl) {
        CategoryAnnotation ippCategory = this.getIPPCategory(decl);
        ElementAnnotation annotation = this.getStorageAnnotation(ippCategory);
        if (annotation != null && annotation.exists()) {
            DefaultAnnotationModifier.deleteAnnotation(annotation);
        }
    }

    private ElementAnnotation getStorageAnnotation(CategoryAnnotation category) {
        List<IAnnotation> children = category.getChildren();
        int i = 0;
        while (i < children.size()) {
            ElementAnnotation annotation = (ElementAnnotation)children.get(i);
            if (STORAGE_ELEMENT.equals(annotation.getConfigurationAttribute(NAME_ATTRIBUTE))) {
                return annotation;
            }
            ++i;
        }
        return null;
    }

    private CategoryAnnotation getIPPCategory(XSDElementDeclaration decl) {
        String extensionId = APPLICATION_INFO_EXTENSION_ID;
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
        int i = 0;
        while (i < configs.length) {
            String name = configs[i].getName();
            if (CATEGORY_ELEMENT.equals(name) && IPP_CATEGORY_ID.equals(configs[i].getAttribute(ID_ATTRIBUTE))) {
                return new CategoryAnnotation(this, decl, configs[i]);
            }
            ++i;
        }
        return null;
    }

    public TypeDeclarationType getDeclaration() {
        return this.declaration;
    }

    public boolean isInternalSchema() {
        return this.isInternalSchema;
    }

    public XSDNamedComponent getRoot() {
        return this.root;
    }
}

