/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.data.structured.annotations.AttributeAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.ConfigurationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AnnotationLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof IAnnotation) {
            String location = "{org.eclipse.xsd.edit}icons/full/obj16/XSDAnnotation.gif";
            if (element instanceof AttributeAnnotation) {
                location = "{org.eclipse.xsd.edit}icons/full/obj16/XSDAttributeDeclaration.gif";
            } else if (element instanceof ElementAnnotation) {
                location = "{org.eclipse.xsd.edit}icons/full/obj16/XSDElementDeclaration.gif";
            }
            if (element instanceof ConfigurationItem && !((ConfigurationItem)element).getValidationStatus().isOK()) {
                IStatus status = ((ConfigurationItem)element).getValidationStatus();
                return DiagramPlugin.getImage((String)location, (int)(status.getSeverity() == 4 ? 4 : 3));
            }
            return DiagramPlugin.getImage((String)location);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object result = "?";
        if (element instanceof IAnnotation) {
            IAnnotation annotation = (IAnnotation)element;
            switch (columnIndex) {
                case 0: {
                    result = annotation.getName();
                    break;
                }
                case 1: {
                    result = DefaultAnnotationModifier.getAnnotationValue(annotation);
                    break;
                }
                case 2: 
                case 3: {
                    result = null;
                }
            }
        }
        return result == null ? "" : result.toString();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IAnnotation) {
            IAnnotation annotation = (IAnnotation)element;
            if (!DefaultAnnotationModifier.annotationExists(annotation)) {
                return Display.getCurrent().getSystemColor(9);
            }
        } else {
            return Display.getCurrent().getSystemColor(3);
        }
        return null;
    }
}

