/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.modeling.data.structured.annotations.ConfigurationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.GenericElementAdapter;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Attr;

public class AttributeAnnotation
extends ConfigurationItem
implements IAnnotation {
    private ElementAnnotation parentElement;

    public AttributeAnnotation(ElementAnnotation parentElement, IConfigurationElement config) {
        super(config);
        this.parentElement = parentElement;
    }

    public boolean canModify() {
        return true;
    }

    @Override
    public boolean exists() {
        XSDElementDeclaration element = this.getElement();
        return this.getAttribute(element, false, false) != null || this.getAttribute(element, false, true) != null;
    }

    @Override
    public List<IAnnotation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public IAnnotation getParent() {
        return this.parentElement;
    }

    private Attr getAttribute(XSDElementDeclaration element, boolean create, boolean forceInternal) {
        String name;
        if (create && forceInternal) {
            return null;
        }
        Attr attribute = null;
        GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, create, forceInternal);
        if (parentAdapter != null && (attribute = parentAdapter.getAttribute(name = this.getConfigurationAttribute("name"))) == null && create) {
            attribute = parentAdapter.createAttribute(name);
        }
        return attribute;
    }

    @Override
    public String getRawValue() {
        return this.getRawValue(this.getElement());
    }

    @Override
    public String getRawValue(XSDElementDeclaration element) {
        Attr attribute = this.getAttribute(element, false, false);
        if (attribute == null) {
            attribute = this.getAttribute(element, false, true);
        }
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public void setRawValue(String value) {
        XSDElementDeclaration element = this.getElement();
        this.setRawValue(element, value);
    }

    @Override
    public void setRawValue(XSDElementDeclaration element, String value) {
        if (value == null) {
            GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, false, false);
            if (parentAdapter != null) {
                parentAdapter.removeAttribute(this.getConfigurationAttribute("name"), this.parentElement.getNamespace());
            }
        } else {
            Attr attribute = this.getAttribute(element, true, false);
            attribute.setValue(value);
        }
        if (element == this.getElement()) {
            this.validate();
        }
    }

    public boolean delete() {
        String name;
        Attr attribute;
        XSDElementDeclaration element = this.getElement();
        GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, false, false);
        if (parentAdapter != null && (attribute = parentAdapter.getAttribute(name = this.getConfigurationAttribute("name"))) != null) {
            parentAdapter.removeAttribute(name, this.parentElement.getNamespace());
            return true;
        }
        return false;
    }

    @Override
    public XSDElementDeclaration getElement() {
        IAnnotation parent = this.getParent();
        return parent == null ? null : parent.getElement();
    }
}

