/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.modeling.data.structured.annotations.AttributeAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.CategoryAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.ConfigurationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.GenericElementAdapter;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Element;

public class ElementAnnotation
extends ConfigurationItem
implements IAnnotation {
    private CategoryAnnotation parentCategory;
    private ElementAnnotation parentElement;
    private List<IAnnotation> children;

    public ElementAnnotation(CategoryAnnotation parentCategory, IConfigurationElement config) {
        super(config);
        this.parentCategory = parentCategory;
    }

    public ElementAnnotation(ElementAnnotation parentElement, IConfigurationElement config) {
        super(config);
        this.parentElement = parentElement;
    }

    @Override
    public boolean exists() {
        XSDElementDeclaration element = this.getElement();
        return this.getElementAdapter(element, false, false) != null || this.getElementAdapter(element, false, true) != null;
    }

    @Override
    public List<IAnnotation> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IAnnotation>();
            IConfigurationElement[] attributes = this.getConfigurationChildren("attribute");
            int i = 0;
            while (i < attributes.length) {
                this.children.add(new AttributeAnnotation(this, attributes[i]));
                ++i;
            }
            IConfigurationElement[] elements = this.getConfigurationChildren("element");
            int i2 = 0;
            while (i2 < elements.length) {
                this.children.add(new ElementAnnotation(this, elements[i2]));
                ++i2;
            }
        }
        return this.children;
    }

    @Override
    public IAnnotation getParent() {
        return this.parentCategory == null ? this.parentElement : this.parentCategory;
    }

    public GenericElementAdapter getElementAdapter(XSDElementDeclaration element, boolean create, boolean forceInternal) {
        if (create && forceInternal) {
            return null;
        }
        String name = this.getConfigurationAttribute("name");
        String namespace = this.getNamespace();
        if (this.parentCategory == null) {
            GenericElementAdapter parent = this.parentElement.getElementAdapter(element, create, forceInternal);
            if (parent == null) {
                return null;
            }
            GenericElementAdapter result = parent.getChild(name, namespace);
            if (result == null && create) {
                return parent.createChild(name, namespace, this.getDefaultPrefix());
            }
            return result;
        }
        XSDAnnotation annotation = this.parentCategory.getAnnotation(element, create, forceInternal);
        if (annotation == null) {
            return null;
        }
        String sourceURI = forceInternal ? "any" : this.parentCategory.getSourceURI((XSDConcreteComponent)element);
        List<Element> appInfos = this.getAppInfos(annotation, sourceURI);
        if (appInfos.isEmpty()) {
            if (create) {
                Element appInfoElement = annotation.createApplicationInformation("any" == sourceURI ? null : sourceURI);
                annotation.getApplicationInformation().add((Object)appInfoElement);
                annotation.getElement().appendChild(appInfoElement);
                if (sourceURI != null && "any" != sourceURI) {
                    appInfos.add(appInfoElement);
                }
            } else {
                return null;
            }
        }
        GenericElementAdapter parent = null;
        GenericElementAdapter result = null;
        int i = 0;
        while (i < appInfos.size()) {
            Element appInfoElement = appInfos.get(i);
            parent = new GenericElementAdapter(appInfoElement);
            result = parent.getChild(name, namespace);
            if (result != null) {
                return result;
            }
            ++i;
        }
        if (result == null && create) {
            result = parent.createChild(name, namespace, this.getDefaultPrefix());
        }
        return result;
    }

    private List<Element> getAppInfos(XSDAnnotation annotation, String sourceURI) {
        return "any" == sourceURI ? annotation.getApplicationInformation() : annotation.getApplicationInformation(sourceURI);
    }

    private String getDefaultPrefix() {
        return this.parentCategory == null ? this.parentElement.getDefaultPrefix() : this.parentCategory.getDefaultPrefix();
    }

    protected String getNamespace() {
        return this.parentCategory == null ? this.parentElement.getNamespace() : this.parentCategory.getNamespace();
    }

    @Override
    public String getRawValue() {
        return this.getRawValue(this.getElement());
    }

    @Override
    public String getRawValue(XSDElementDeclaration element) {
        GenericElementAdapter adapter = this.getElementAdapter(element, false, false);
        if (adapter == null) {
            adapter = this.getElementAdapter(element, false, true);
        }
        return adapter == null ? null : adapter.getValue();
    }

    @Override
    public void setRawValue(String value) {
        XSDElementDeclaration element = this.getElement();
        this.setRawValue(element, value);
    }

    @Override
    public void setRawValue(XSDElementDeclaration element, String value) {
        GenericElementAdapter adapter = this.getElementAdapter(element, true, false);
        adapter.setValue(value);
        if (element == this.getElement()) {
            this.validate();
        }
    }

    public boolean delete() {
        XSDElementDeclaration element = this.getElement();
        String name = this.getConfigurationAttribute("name");
        String namespace = this.getNamespace();
        if (this.parentCategory == null) {
            GenericElementAdapter parent = this.parentElement.getElementAdapter(element, false, false);
            if (parent != null && parent.removeChild(name, namespace)) {
                return true;
            }
        } else {
            String sourceURI;
            List<Element> appInfos;
            XSDAnnotation annotation = this.parentCategory.getAnnotation(element, false, false);
            if (annotation != null && !(appInfos = this.getAppInfos(annotation, sourceURI = this.parentCategory.getSourceURI((XSDConcreteComponent)element))).isEmpty()) {
                int i = 0;
                while (i < appInfos.size()) {
                    Element appInfoElement = appInfos.get(i);
                    GenericElementAdapter parent = new GenericElementAdapter(appInfoElement);
                    if (parent.removeChild(name, namespace)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public XSDElementDeclaration getElement() {
        IAnnotation parent = this.getParent();
        return parent == null ? null : parent.getElement();
    }
}

