/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.XSDMapping;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XSDElementCheckForType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XsdTextProvider;
import org.eclipse.stardust.modeling.common.ui.jface.utils.ComboBoxCellEditorViewer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.TableEditorTraverseManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.data.structured.StructContentProvider;
import org.eclipse.stardust.modeling.data.structured.StructLabelProvider;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.annotations.AnnotationViewer;
import org.eclipse.stardust.modeling.data.structured.annotations.CategoryAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationChangedListener;
import org.eclipse.stardust.modeling.data.structured.properties.DefaultValueModifier;
import org.eclipse.stardust.modeling.data.structured.properties.DelegateCellEditor;
import org.eclipse.stardust.modeling.data.structured.validation.ElementValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;

public class ComplexTypePropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage,
IAnnotationChangedListener {
    private static final String NEW_ELEMENT_PLACEHOLDER = Structured_Messages.ComplexTypePropertyPage_NewElementPlaceholder;
    private static final String ANONYMOUS_TYPE = Structured_Messages.ComplexTypePropertyPage_AnonymousPlaceholder;
    private static final String ATTRIBUTE_TYPE = Structured_Messages.ComplexTypePropertyPage_AttributePlaceholder;
    private static final String ELEMENT_TYPE = Structured_Messages.ComplexTypePropertyPage_ElementPlaceholder;
    private TreeViewer viewer;
    private ComboBoxCellEditorViewer comboViewer;
    private ComboBoxCellEditorViewer attributeComboViewer;
    private DelegateCellEditor defaultValueCellEditor;
    private StructLabelProvider labelProvider;
    private StructContentProvider contentProvider;
    private Comparator<XSDNamedComponent> typesComparator;
    private Button deleteButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private XSDComplexTypeDefinition type;
    private TypeDeclarationType declaration;
    private HashMap<String, String> namespace2prefix = new HashMap();
    private HashSet<String> prefixes = new HashSet();
    private ArrayList<XSDNamedComponent> internalTypes = null;
    private ArrayList<XSDSimpleTypeDefinition> predefinedTypes = null;
    private HashMap<XSDNamedComponent, TypeDeclarationType> internalTypes2declarations = null;
    private AnnotationViewer annotationViewer;
    private DateFormat dateFormat = new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY);
    private SashForm form;
    private Map<XSDElementDeclaration, Map<IAnnotation, Object>> defaultAnnotationMap = new HashMap<XSDElementDeclaration, Map<IAnnotation, Object>>();

    public void performDefaults() {
        this.resetAnnotationSettings();
        try {
            super.performDefaults();
        }
        catch (Exception exception) {}
        this.totalRefresh();
    }

    private void totalRefresh() {
        if (!this.viewer.getTree().isDisposed()) {
            this.viewer.refresh((Object)this.getModelElement());
            this.updateButtons();
            Object[] exp = this.viewer.getExpandedElements();
            this.viewer.collapseAll();
            this.viewer.setExpandedElements(exp);
        }
    }

    protected void performApply() {
        this.defaultAnnotationMap.clear();
        super.performApply();
    }

    public boolean performCancel() {
        this.performDefaults();
        return super.performCancel();
    }

    public static final boolean isNewType(Object candidate) {
        return candidate instanceof XSDElementDeclaration && NEW_ELEMENT_PLACEHOLDER == ((XSDElementDeclaration)candidate).getName();
    }

    public static final boolean isAnonymous(XSDElementDeclaration candidate) {
        String name = candidate.getName();
        return name == null || name.length() == 0;
    }

    public void elementChanged() {
        block4: {
            this.declaration = (TypeDeclarationType)this.getElement().getAdapter(EObject.class);
            DefaultValueModifier.setDeclaration(this.declaration);
            try {
                this.type = TypeDeclarationUtils.getComplexType((TypeDeclarationType)this.declaration);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String externalUrl;
                XpdlTypeType dataType = this.declaration.getDataType();
                if (!(dataType instanceof ExternalReferenceType) || StringUtils.isEmpty((String)(externalUrl = ((ExternalReferenceType)dataType).getLocation()))) break block4;
                this.setMessage(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_ResourceNotFound, externalUrl), 3);
            }
        }
        if (this.type != null) {
            this.type.updateElement(true);
            this.annotationViewer.setDeclaration(this.declaration);
            this.addPlaceholders((XSDComponent)this.type, new HashSet<XSDComponent>());
            this.viewer.setInput((Object)this.type);
            if (!this.viewer.getTree().isEnabled()) {
                this.viewer.expandAll();
            }
        }
        this.updateButtons();
    }

    private void addPlaceholders(XSDComponent type, HashSet<XSDComponent> visited) {
        if (!TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration) || visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (type instanceof XSDModelGroup && this.isLocal((XSDComponent)((XSDModelGroup)type))) {
            this.contentProvider.setNewElement((XSDModelGroup)type, this.createNewElement());
        }
        Object[] children = this.contentProvider.getChildren(type);
        int i = 0;
        while (i < children.length) {
            this.addPlaceholders((XSDComponent)children[i], visited);
            ++i;
        }
    }

    private XSDElementDeclaration createNewElement() {
        XSDElementDeclaration newEntry = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        newEntry.setName(NEW_ELEMENT_PLACEHOLDER);
        return newEntry;
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public Control createBody(Composite parent) {
        DefaultAnnotationModifier.INSTANCE.addAnnotationChangedListener(this);
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.form = new SashForm(composite, 512);
        this.form.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)400));
        Tree tree = FormBuilder.createTree((Composite)this.form, (int)67588);
        tree.setHeaderVisible(true);
        this.viewer = new TreeViewer(tree);
        int i = 0;
        while (i < StructLabelProvider.COMPLEX_TYPE_COLUMNS.length) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(StructLabelProvider.COMPLEX_TYPE_COLUMNS[i]);
            column.setWidth(200);
            ++i;
        }
        this.viewer.setUseHashlookup(true);
        this.labelProvider = new StructLabelProvider(tree);
        this.contentProvider = new StructContentProvider(false);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setColumnProperties(StructLabelProvider.COMPLEX_TYPE_COLUMNS);
        this.viewer.setCellModifier((ICellModifier)new Modifier());
        tree.addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, -1, 0, 0, 2));
        final TextCellEditor nameEditor = new TextCellEditor((Composite)tree);
        nameEditor.getControl().addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, -3, 1, 0, 2){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8 || !ComplexTypePropertyPage.isNewType(((IStructuredSelection)ComplexTypePropertyPage.this.viewer.getSelection()).getFirstElement()) || nameEditor.isDirty()) {
                    super.keyTraversed(e);
                }
            }

            public Object getPreviousElement(Object selection) {
                Object[] elements = ComplexTypePropertyPage.this.contentProvider.getElements(ComplexTypePropertyPage.this.viewer.getInput());
                int i = 1;
                while (i < elements.length) {
                    if (elements[i].equals(selection)) {
                        return elements[i - 1];
                    }
                    ++i;
                }
                return null;
            }
        });
        ComboBoxCellEditor typeEditor = new ComboBoxCellEditor((Composite)tree, new String[0]);
        ((CCombo)typeEditor.getControl()).setEditable(false);
        typeEditor.getControl().addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, 0, 2, 0, 2));
        ComboBoxCellEditor maxOccursEditor = new ComboBoxCellEditor((Composite)tree, new String[0]);
        maxOccursEditor.getControl().addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, 1, -2, 0, 2){

            public Object getNextElement(Object selection) {
                Object[] elements = ComplexTypePropertyPage.this.contentProvider.getElements(ComplexTypePropertyPage.this.viewer.getInput());
                int i = 0;
                while (i < elements.length - 1) {
                    if (elements[i].equals(selection)) {
                        return elements[i + 1];
                    }
                    ++i;
                }
                return null;
            }
        });
        this.defaultValueCellEditor = new DelegateCellEditor((Composite)tree);
        this.viewer.setCellEditors(new CellEditor[]{nameEditor, typeEditor, maxOccursEditor});
        this.attributeComboViewer = new ComboBoxCellEditorViewer(maxOccursEditor);
        this.attributeComboViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.attributeComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.comboViewer = new ComboBoxCellEditorViewer(typeEditor);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof XSDCompositor) {
                    XSDCompositor compositor = (XSDCompositor)element;
                    return String.valueOf('<') + compositor.getName() + '>';
                }
                if (element instanceof XSDNamedComponent) {
                    String prefix;
                    XSDNamedComponent component = (XSDNamedComponent)element;
                    String name = component.getQName((XSDConcreteComponent)ComplexTypePropertyPage.this.type);
                    if (name.indexOf(58) < 0 && (prefix = ComplexTypePropertyPage.this.computePrefix(name, component.getSchema())) != null) {
                        name = String.valueOf(prefix) + ':' + name;
                    }
                    return name;
                }
                return ComplexTypePropertyPage.this.labelProvider.getText(element);
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Item previousItem;
                Widget item = e.item;
                if (item instanceof TreeItem && (previousItem = ComplexTypePropertyPage.this.defaultValueCellEditor.setItem((Item)item)) != null && !previousItem.isDisposed()) {
                    Object previous = previousItem.getData();
                    ComplexTypePropertyPage.this.viewer.update(previous, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
                }
            }
        });
        this.typesComparator = new Comparator<XSDNamedComponent>(){

            @Override
            public int compare(XSDNamedComponent arg0, XSDNamedComponent arg1) {
                String s0 = ComplexTypePropertyPage.this.labelProvider.getText(arg0);
                String s1 = ComplexTypePropertyPage.this.labelProvider.getText(arg1);
                return s0.compareToIgnoreCase(s1);
            }
        };
        this.annotationViewer = new AnnotationViewer();
        this.annotationViewer.createControl((Composite)this.form, this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object item;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                XSDElementDeclaration decl = null;
                if (!selection.isEmpty() && (item = selection.getFirstElement()) instanceof XSDElementDeclaration && !ComplexTypePropertyPage.isNewType(item)) {
                    decl = (XSDElementDeclaration)item;
                }
                ComplexTypePropertyPage.this.annotationViewer.setInput(decl);
                ComplexTypePropertyPage.this.form.layout(true);
                ComplexTypePropertyPage.this.updateButtons();
            }
        });
        this.form.setWeights(new int[]{50, 50});
        return composite;
    }

    private String computePrefix(String id, XSDSchema schema) {
        if (schema.getTargetNamespace() == null) {
            return null;
        }
        String prefix = this.namespace2prefix.get(schema.getTargetNamespace());
        if (prefix == null) {
            for (Map.Entry entry : schema.getQNamePrefixToNamespaceMap().entrySet()) {
                if (!schema.getTargetNamespace().equals(entry.getValue())) continue;
                prefix = (String)entry.getKey();
                break;
            }
            if (prefix == null) {
                prefix = TypeDeclarationUtils.computePrefix((String)id, this.prefixes);
            }
            this.prefixes.add(prefix);
            this.namespace2prefix.put(schema.getTargetNamespace(), prefix);
        }
        return prefix;
    }

    protected void updateButtons() {
        String location;
        XpdlTypeType type;
        XSDComponent selectedObject;
        EObject item;
        boolean canBeDeleted = false;
        boolean isFirst = true;
        boolean isLast = true;
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (item = (selectedObject = (XSDComponent)((IStructuredSelection)selection).getFirstElement()).eContainer()) != null) {
            EObject component = item.eContainer();
            if (this.isLocal(selectedObject) && (component instanceof XSDModelGroup || selectedObject instanceof XSDAttributeDeclaration)) {
                int ix;
                canBeDeleted = true;
                List<?> list = this.getContainer(item);
                if (list != null && list.size() > 0 && (ix = list.indexOf(item)) >= 0) {
                    isFirst = ix == 0;
                    boolean bl = isLast = ix == list.size() - 1;
                }
            }
        }
        if ((type = this.declaration.getDataType()) instanceof ExternalReferenceType && (location = ((ExternalReferenceType)type).getLocation()) != null && !location.startsWith("urn:internal:")) {
            canBeDeleted = false;
            isFirst = true;
            isLast = true;
        }
        this.deleteButton.setEnabled(canBeDeleted);
        this.moveUpButton.setEnabled(!isFirst);
        this.moveDownButton.setEnabled(!isLast);
    }

    private List<?> getContainer(EObject item) {
        EReference reference = item.eContainmentFeature();
        EObject parent = item.eContainer();
        return (List)parent.eGet((EStructuralFeature)reference);
    }

    private boolean validateNumericAnnotation(String annotationValue, String javaTypeName) {
        if (javaTypeName.equals(Float.class.getName())) {
            try {
                Float.parseFloat(annotationValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(MessageFormat.format(Structured_Messages.DefaultValueValidation_NotFloat, annotationValue), 3);
                this.setValid(false);
                return false;
            }
        }
        if (javaTypeName.equals(Double.class.getName())) {
            try {
                Double.parseDouble(annotationValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(MessageFormat.format(Structured_Messages.DefaultValueValidation_NotDouble, annotationValue), 3);
                this.setValid(false);
                return false;
            }
        }
        if (javaTypeName.equals(Byte.class.getName())) {
            try {
                Byte.parseByte(annotationValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(MessageFormat.format(Structured_Messages.DefaultValueValidation_NotByte, annotationValue), 3);
                this.setValid(false);
                return false;
            }
        }
        if (javaTypeName.equals(Date.class.getName())) {
            try {
                this.dateFormat.parse(annotationValue);
            }
            catch (ParseException parseException) {
                this.setMessage(MessageFormat.format(Structured_Messages.DefaultValueValidation_NotDate, annotationValue), 3);
                this.setValid(false);
                return false;
            }
        }
        try {
            Integer.parseInt(annotationValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(MessageFormat.format(Structured_Messages.DefaultValueValidation_NotNumber, annotationValue), 3);
            this.setValid(false);
            return false;
        }
        this.setMessage(null);
        this.setValid(true);
        return true;
    }

    private void validateInput() {
        List<String> messages = ElementValidator.validateElements(this.declaration);
        if (messages != null && !messages.isEmpty()) {
            this.setMessage(messages.get(0), 3);
            this.setValid(false);
            return;
        }
        this.setMessage(null);
        this.setValid(true);
    }

    public void contributeVerticalButtons(Composite parent) {
        this.deleteButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.DeleteButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ComplexTypePropertyPage.this.deleteField();
            }
        });
        this.moveUpButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.MoveUpButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ComplexTypePropertyPage.this.moveFieldUp();
            }
        });
        this.moveDownButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.MoveDownButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ComplexTypePropertyPage.this.moveFieldDown();
            }
        });
    }

    protected void moveFieldDown() {
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.moveItem(((EObject)selection).eContainer(), 1);
    }

    protected void moveFieldUp() {
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.moveItem(((EObject)selection).eContainer(), -1);
    }

    protected void deleteField() {
        XSDSchema schema = this.type.getSchema();
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        XSDTypeDefinition oldDef = null;
        if (selection instanceof XSDElementDeclaration) {
            oldDef = ((XSDElementDeclaration)selection).getTypeDefinition();
        }
        this.moveItem(((EObject)selection).eContainer(), 0);
        if (oldDef != null && !XSDElementCheckForType.needsType((TypeDeclarationType)this.declaration, (XSDTypeDefinition)oldDef)) {
            TypeDeclarationUtils.removeImport((XSDSchema)schema, (XSDSchema)oldDef.getSchema());
            TypeDeclarationUtils.removeNameSpace((XSDSchema)schema, (String)oldDef.getName(), (String)((ModelType)this.declaration.eContainer().eContainer()).getId());
        }
    }

    private void moveItem(EObject item, int amount) {
        EList list = (EList)this.getContainer(item);
        if (amount == 0) {
            list.remove((Object)item);
        } else {
            int ix = list.indexOf((Object)item);
            list.move(ix + amount, ix);
        }
        this.viewer.refresh((Object)item.eContainer());
        this.updateButtons();
    }

    private boolean isLocal(XSDComponent component) {
        return this.type.getSchema().equals(component.getSchema());
    }

    public static String computeUniqueName(String baseName, List<XSDParticle> contents) {
        int counter = 0;
        while (ComplexTypePropertyPage.nameExists(counter == 0 ? baseName : String.valueOf(baseName) + counter, contents)) {
            ++counter;
        }
        return counter == 0 ? baseName : String.valueOf(baseName) + counter;
    }

    private static boolean nameExists(String name, List<XSDParticle> contents) {
        int i = 0;
        while (i < contents.size()) {
            XSDElementDeclaration decl;
            XSDParticle particle = contents.get(i);
            XSDTerm term = particle.getTerm();
            if (term instanceof XSDElementDeclaration && name.equals((decl = (XSDElementDeclaration)term).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInternal(TypeDeclarationType decl) {
        XpdlTypeType dataType = decl.getDataType();
        if (dataType instanceof SchemaTypeType) {
            return true;
        }
        if (dataType instanceof ExternalReferenceType) {
            String location = ((ExternalReferenceType)dataType).getLocation();
            return location != null && location.startsWith("urn:internal:");
        }
        return false;
    }

    @Override
    public void annotationChanged(IAnnotation annotation, Object oldValue, Object newValue) {
        DefaultAnnotationModifier.stopNotifying();
        if (this.annotationViewer.isChangeAllMode()) {
            if (newValue == null) {
                try {
                    this.deleteAllAnnotations(this.declaration, annotation);
                }
                catch (Throwable throwable) {}
                this.totalRefresh();
            } else {
                this.handleAllAnnotationChange(this.type, annotation, oldValue);
            }
        } else {
            CategoryAnnotation root = (CategoryAnnotation)DefaultAnnotationModifier.getRootAnnotation(annotation);
            this.handleDefaultValueChange(annotation, oldValue, root.getElement());
        }
        DefaultAnnotationModifier.startNotifying();
    }

    private void deleteAllAnnotations(Object element, IAnnotation annotation) {
        Object[] children = this.contentProvider.getChildren(element);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (child instanceof XSDElementDeclaration) {
                XSDElementDeclaration decl = (XSDElementDeclaration)child;
                this.annotationViewer.setInput(decl);
                if (decl.getTypeDefinition() instanceof XSDSimpleTypeDefinition && !ComplexTypePropertyPage.isNewType(child)) {
                    this.handleDefaultValueChange(annotation, DefaultAnnotationModifier.getAnnotationValue(annotation), child);
                    DefaultAnnotationModifier.deleteAnnotation(annotation);
                }
            }
            this.deleteAllAnnotations(child, annotation);
            ++i;
        }
    }

    private void addDefaultValue(IAnnotation annotation, Map<IAnnotation, Object> defaultList, Object value) {
        Object defaultValue = defaultList.get(annotation);
        if (defaultValue == null) {
            defaultList.put(annotation, value);
        }
    }

    private void handleAllAnnotationChange(Object element, IAnnotation annotation, Object oldValue) {
        Object[] children = this.contentProvider.getChildren(element);
        int i = 0;
        while (i < children.length) {
            XSDElementDeclaration decl;
            Object child = children[i];
            if (child instanceof XSDElementDeclaration && (decl = (XSDElementDeclaration)child).getTypeDefinition() instanceof XSDSimpleTypeDefinition && !ComplexTypePropertyPage.isNewType(child)) {
                this.handleDefaultValueChange(annotation, oldValue, child);
            }
            this.handleAllAnnotationChange(child, annotation, oldValue);
            ++i;
        }
    }

    private void handleDefaultValueChange(IAnnotation annotation, Object oldValue, Object child) {
        Map<IAnnotation, Object> defaultList = this.defaultAnnotationMap.get((XSDElementDeclaration)child);
        if (defaultList == null) {
            defaultList = new HashMap<IAnnotation, Object>();
            this.defaultAnnotationMap.put((XSDElementDeclaration)child, defaultList);
        }
        this.addDefaultValue(annotation, defaultList, oldValue);
    }

    private void resetAnnotationSettings() {
        DefaultAnnotationModifier.stopNotifying();
        for (XSDElementDeclaration decl : this.defaultAnnotationMap.keySet()) {
            this.annotationViewer.setInput(decl);
            Map<IAnnotation, Object> map = this.defaultAnnotationMap.get(decl);
            for (IAnnotation annotation : map.keySet()) {
                Object value = map.get(annotation);
                if (value == null) {
                    DefaultAnnotationModifier.deleteAnnotation(annotation);
                    continue;
                }
                DefaultAnnotationModifier.INSTANCE.setValue(annotation, value);
            }
        }
        DefaultAnnotationModifier.startNotifying();
    }

    private class Modifier
    implements ICellModifier {
        private Modifier() {
        }

        public boolean canModify(Object element, String property) {
            ComplexTypePropertyPage.this.defaultValueCellEditor.enableEditor(false);
            if (!TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)ComplexTypePropertyPage.this.declaration)) {
                return false;
            }
            if (element instanceof XSDAttributeDeclaration) {
                return true;
            }
            if (element instanceof XSDModelGroup) {
                return ComplexTypePropertyPage.this.isLocal((XSDComponent)((XSDModelGroup)element)) && StructLabelProvider.COMPLEX_TYPE_COLUMNS[1].equals(property);
            }
            if (!(element instanceof XSDElementDeclaration)) {
                return false;
            }
            XSDElementDeclaration entry = (XSDElementDeclaration)element;
            if (ComplexTypePropertyPage.isNewType(entry)) {
                return StructLabelProvider.COMPLEX_TYPE_COLUMNS[0].equals(property);
            }
            return ComplexTypePropertyPage.this.isLocal((XSDComponent)entry);
        }

        public Object getValue(Object element, String property) {
            if (element instanceof XSDTerm || element instanceof XSDAttributeDeclaration) {
                XSDComponent entry = (XSDComponent)element;
                if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[0].equals(property)) {
                    return ComplexTypePropertyPage.this.labelProvider.getColumnText(entry, 0);
                }
                if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[1].equals(property)) {
                    return this.getTypeIndex((EObject)entry);
                }
                if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[2].equals(property)) {
                    return this.getCardinalityIndex(entry);
                }
                if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[3].equals(property)) {
                    return DefaultValueModifier.getValueForElement(entry);
                }
            }
            return null;
        }

        private Integer getCardinalityIndex(XSDComponent term) {
            this.updateAvailableCardinality((EObject)term);
            return term instanceof XSDTerm || term instanceof XSDAttributeDeclaration ? new Integer(XsdTextProvider.getCardinalityIndex((XSDConcreteComponent)term)) : null;
        }

        private void updateAvailableCardinality(EObject term) {
            if (term instanceof XSDElementDeclaration) {
                ComplexTypePropertyPage.this.attributeComboViewer.setInput((Object)StructLabelProvider.DEFAULT_CARDINALITY_LABELS);
            } else if (term instanceof XSDAttributeDeclaration) {
                ComplexTypePropertyPage.this.attributeComboViewer.setInput((Object)XSDAttributeUseCategory.VALUES.toArray());
            } else {
                ComplexTypePropertyPage.this.attributeComboViewer.setInput((Object)Collections.EMPTY_LIST);
            }
        }

        private Integer getTypeIndex(EObject term) {
            this.updateAvailableTypes(term);
            Object type = null;
            if (term instanceof XSDAttributeDeclaration) {
                type = ((XSDAttributeDeclaration)term).getTypeDefinition();
            } else if (term instanceof XSDElementDeclaration) {
                XSDElementDeclaration element = (XSDElementDeclaration)term;
                type = element.isElementDeclarationReference() ? element.getResolvedElementDeclaration() : (element.getAnonymousTypeDefinition() != null ? ANONYMOUS_TYPE : ((XSDElementDeclaration)term).getTypeDefinition());
            } else if (term instanceof XSDModelGroup) {
                type = ((XSDModelGroup)term).getCompositor();
            }
            return ComplexTypePropertyPage.this.comboViewer.findIndex(type);
        }

        private void updateAvailableTypes(EObject term) {
            ArrayList<Object> types = new ArrayList<Object>();
            if (term instanceof XSDAttributeDeclaration) {
                types.addAll(this.getPredefinedTypes());
                types.addAll(this.getInternalTypes(true));
                types.add(ELEMENT_TYPE);
            } else if (term instanceof XSDModelGroup) {
                types.add(XSDCompositor.SEQUENCE_LITERAL);
                types.add(XSDCompositor.CHOICE_LITERAL);
                if (term.eContainer() instanceof XSDParticle && term.eContainer().eContainer() instanceof XSDModelGroup) {
                    types.add(ANONYMOUS_TYPE);
                }
            } else if (term instanceof XSDElementDeclaration) {
                types.addAll(this.getPredefinedTypes());
                types.addAll(this.getInternalTypes(false));
                types.add(XSDCompositor.SEQUENCE_LITERAL);
                types.add(XSDCompositor.CHOICE_LITERAL);
                types.add(ANONYMOUS_TYPE);
                if (((XSDElementDeclaration)term).getTypeDefinition() instanceof XSDSimpleTypeDefinition && term.eContainer().eContainer().eContainer().eContainer() instanceof XSDComplexTypeDefinition) {
                    types.add(ATTRIBUTE_TYPE);
                }
            }
            ComplexTypePropertyPage.this.comboViewer.setInput(types);
        }

        private List<XSDSimpleTypeDefinition> getPredefinedTypes() {
            if (ComplexTypePropertyPage.this.predefinedTypes == null) {
                ComplexTypePropertyPage.this.predefinedTypes = new ArrayList();
                XSDSchema schema = ComplexTypePropertyPage.this.type.getSchema();
                XSDSchema xsdSchema = schema.getSchemaForSchema();
                ComplexTypePropertyPage.this.predefinedTypes.addAll(xsdSchema.getSimpleTypeIdMap().values());
                Collections.sort(ComplexTypePropertyPage.this.predefinedTypes, ComplexTypePropertyPage.this.typesComparator);
            }
            return ComplexTypePropertyPage.this.predefinedTypes;
        }

        private List<XSDNamedComponent> getInternalTypes(boolean onlySimpleTypes) {
            if (ComplexTypePropertyPage.this.internalTypes == null) {
                EList declarations = ((TypeDeclarationsType)ComplexTypePropertyPage.this.declaration.eContainer()).getTypeDeclaration();
                ComplexTypePropertyPage.this.internalTypes = new ArrayList();
                ComplexTypePropertyPage.this.internalTypes2declarations = new HashMap();
                int i = 0;
                while (i < declarations.size()) {
                    TypeDeclarationType decl = (TypeDeclarationType)declarations.get(i);
                    if (decl != ComplexTypePropertyPage.this.declaration && ComplexTypePropertyPage.this.isInternal(decl)) {
                        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)decl);
                        if (component instanceof XSDTypeDefinition) {
                            if (!onlySimpleTypes || component instanceof XSDSimpleTypeDefinition) {
                                ComplexTypePropertyPage.this.internalTypes.add(component);
                                ComplexTypePropertyPage.this.internalTypes2declarations.put(component, decl);
                            }
                        } else if (component instanceof XSDElementDeclaration) {
                            XSDElementDeclaration element = (XSDElementDeclaration)component;
                            if (element.isElementDeclarationReference()) {
                                if (!onlySimpleTypes || element.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                                    ComplexTypePropertyPage.this.internalTypes.add(element);
                                    ComplexTypePropertyPage.this.internalTypes2declarations.put(element, decl);
                                }
                            } else if (element.getAnonymousTypeDefinition() != null) {
                                if (!onlySimpleTypes || element.getAnonymousTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                                    ComplexTypePropertyPage.this.internalTypes.add(element);
                                    ComplexTypePropertyPage.this.internalTypes2declarations.put(element, decl);
                                }
                            } else {
                                XSDTypeDefinition definition = element.getTypeDefinition();
                                if (definition != null && (!onlySimpleTypes || definition instanceof XSDSimpleTypeDefinition)) {
                                    ComplexTypePropertyPage.this.internalTypes.add(definition);
                                    ComplexTypePropertyPage.this.internalTypes2declarations.put(definition, decl);
                                }
                            }
                        }
                    }
                    ++i;
                }
                Collections.sort(ComplexTypePropertyPage.this.internalTypes, ComplexTypePropertyPage.this.typesComparator);
            }
            return ComplexTypePropertyPage.this.internalTypes;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[0].equals(property)) {
                this.setName((XSDNamedComponent)element, (String)value);
            } else if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[1].equals(property)) {
                this.setType(element, ComplexTypePropertyPage.this.comboViewer.findObject((Integer)value));
            } else if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[2].equals(property)) {
                if (element instanceof XSDElementDeclaration) {
                    this.setCardinality((XSDElementDeclaration)element, (int)((Integer)value));
                } else if (element instanceof XSDAttributeDeclaration) {
                    this.setCardinality((XSDAttributeDeclaration)element, (int)((Integer)value));
                }
            } else if (StructLabelProvider.COMPLEX_TYPE_COLUMNS[3].equals(property)) {
                String annotationValue;
                XSDTypeDefinition typeDefinition;
                String javaTypeName = null;
                if (element instanceof XSDElementDeclaration) {
                    typeDefinition = ((XSDElementDeclaration)element).getTypeDefinition();
                    if (typeDefinition.getComplexType() == null) {
                        javaTypeName = XSDMapping.getJavaTypeForXSDType((String)typeDefinition.getName());
                    }
                } else if (element instanceof XSDAttributeDeclaration && (typeDefinition = ((XSDAttributeDeclaration)element).getTypeDefinition()).getComplexType() == null) {
                    javaTypeName = XSDMapping.getJavaTypeForXSDType((String)typeDefinition.getName());
                }
                if (!StringUtils.isEmpty((String)(annotationValue = (String)value)) && !StringUtils.isEmpty((String)javaTypeName)) {
                    try {
                        Class<?> clazz = Class.forName(javaTypeName);
                        String superClass = clazz.getSuperclass().getName();
                        if ((superClass.equals(Number.class.getName()) || javaTypeName.equals(Date.class.getName())) && !ComplexTypePropertyPage.this.validateNumericAnnotation(annotationValue, javaTypeName)) {
                            return;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                DefaultValueModifier.setOrRemoveAnnotation(element, value);
                ComplexTypePropertyPage.this.viewer.update(element, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
            }
        }

        private void setType(Object element, Object value) {
            if (element instanceof XSDModelGroup) {
                this.changeModelGroup((XSDModelGroup)element, value);
            } else if (element instanceof XSDAttributeDeclaration) {
                this.changeAttribute((XSDAttributeDeclaration)element, value);
            } else if (element instanceof XSDElementDeclaration) {
                this.changeElement((XSDElementDeclaration)element, value);
            }
            ComplexTypePropertyPage.this.annotationViewer.setInput(element instanceof XSDElementDeclaration ? (XSDElementDeclaration)element : null);
            ComplexTypePropertyPage.this.form.layout(true);
            ComplexTypePropertyPage.this.validateInput();
        }

        private void changeElement(XSDElementDeclaration decl, Object newType) {
            XSDTypeDefinition oldDef = decl.getTypeDefinition();
            DefaultValueModifier.setOrRemoveAnnotation(decl, null);
            if (oldDef != null && oldDef.equals(newType)) {
                return;
            }
            if (newType == ANONYMOUS_TYPE) {
                this.changeElementToAnonymous(decl);
            } else if (newType == ATTRIBUTE_TYPE) {
                this.changeElementToAttribute(decl);
            } else if (newType instanceof XSDCompositor) {
                this.changeElementToModelGroup(decl, (XSDCompositor)newType);
            } else if (newType instanceof XSDElementDeclaration) {
                this.setElementReference(decl, (XSDElementDeclaration)newType);
            } else if (newType instanceof XSDTypeDefinition) {
                this.setElementType(decl, (XSDTypeDefinition)newType);
            }
            if (!XSDElementCheckForType.needsType((TypeDeclarationType)ComplexTypePropertyPage.this.declaration, (XSDTypeDefinition)oldDef)) {
                XSDSchema schema = ComplexTypePropertyPage.this.type.getSchema();
                TypeDeclarationUtils.removeImport((XSDSchema)schema, (XSDSchema)oldDef.getSchema());
                TypeDeclarationUtils.removeNameSpace((XSDSchema)schema, (String)oldDef.getName(), (String)((ModelType)ComplexTypePropertyPage.this.declaration.eContainer().eContainer()).getId());
                schema.updateElement(true);
            }
        }

        private void changeElementToModelGroup(XSDElementDeclaration decl, XSDCompositor compositor) {
            decl.updateElement(true);
            if (decl.eContainer() instanceof XSDParticle) {
                XSDTerm term;
                XSDComplexTypeContent complexContent;
                XSDModelGroup newModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                newModelGroup.setCompositor(compositor);
                if (decl.getAnonymousTypeDefinition() != null && decl.getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition && (complexContent = ((XSDComplexTypeDefinition)decl.getAnonymousTypeDefinition()).getContent()) instanceof XSDParticle && (term = ((XSDParticle)complexContent).getTerm()) instanceof XSDModelGroup) {
                    XSDModelGroup modelGroup = (XSDModelGroup)term;
                    ArrayList content = new ArrayList();
                    content.addAll(modelGroup.getContents());
                    newModelGroup.getContents().addAll(content);
                    ComplexTypePropertyPage.this.contentProvider.removeNewElement(modelGroup);
                }
                XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
                newParticle.setContent((XSDParticleContent)newModelGroup);
                XSDParticle oldParticle = (XSDParticle)decl.eContainer();
                XSDModelGroup parent = (XSDModelGroup)oldParticle.eContainer();
                int index = parent.getContents().indexOf((Object)oldParticle);
                parent.getContents().remove((Object)oldParticle);
                parent.getContents().add(index, (Object)newParticle);
                parent.updateElement(true);
                ComplexTypePropertyPage.this.contentProvider.setNewElement(newModelGroup, ComplexTypePropertyPage.this.createNewElement());
                ComplexTypePropertyPage.this.viewer.refresh((Object)parent);
            }
        }

        private void setElementReference(XSDElementDeclaration decl, XSDElementDeclaration ref) {
            decl.updateElement(true);
            this.updateImports(ComplexTypePropertyPage.this.type.getSchema(), (XSDNamedComponent)ref);
            if (decl.getTypeDefinition() != null) {
                decl.setTypeDefinition(null);
            }
            if (decl.getAnonymousTypeDefinition() != null) {
                decl.setAnonymousTypeDefinition(null);
            }
            decl.setResolvedElementDeclaration(ref);
            decl.updateElement(true);
            ComplexTypePropertyPage.this.viewer.refresh((Object)decl);
        }

        private void setElementType(XSDElementDeclaration decl, XSDTypeDefinition def) {
            decl.updateElement(true);
            this.updateImports(ComplexTypePropertyPage.this.type.getSchema(), (XSDNamedComponent)def);
            if (decl.getResolvedElementDeclaration() != decl) {
                decl.setResolvedElementDeclaration(decl);
            }
            if (decl.getAnonymousTypeDefinition() != null) {
                decl.setAnonymousTypeDefinition(null);
            }
            decl.setTypeDefinition(def);
            decl.updateElement(true);
            ComplexTypePropertyPage.this.viewer.refresh((Object)decl);
        }

        private void changeElementToAttribute(XSDElementDeclaration decl) {
            decl.updateElement(true);
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)decl.getTypeDefinition();
            XSDParticle particle = (XSDParticle)decl.eContainer();
            XSDModelGroup modelGroup = (XSDModelGroup)particle.eContainer();
            modelGroup.getContents().remove((Object)particle);
            XSDParticle modelGroupParticle = (XSDParticle)modelGroup.eContainer();
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)modelGroupParticle.eContainer();
            XSDAttributeDeclaration attribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attribute.setName(decl.getName());
            decl.setTypeDefinition(null);
            attribute.setTypeDefinition(simpleType);
            XSDAttributeUse use = XSDFactory.eINSTANCE.createXSDAttributeUse();
            use.setContent(attribute);
            complexType.getAttributeContents().add((Object)use);
            complexType.updateElement(true);
            if (complexType != ComplexTypePropertyPage.this.type) {
                ComplexTypePropertyPage.this.viewer.refresh((Object)complexType);
            }
            ComplexTypePropertyPage.this.viewer.refresh();
        }

        private void updateImports(XSDSchema schema, XSDNamedComponent component) {
            TypeDeclarationType typeDecl;
            if (!schema.getQNamePrefixToNamespaceMap().values().contains(component.getTargetNamespace()) && (typeDecl = (TypeDeclarationType)ComplexTypePropertyPage.this.internalTypes2declarations.get(component)) != null) {
                String prefix = ComplexTypePropertyPage.this.computePrefix(typeDecl.getId(), component.getSchema());
                schema.getQNamePrefixToNamespaceMap().put(prefix, component.getTargetNamespace());
                XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
                xsdImport.setNamespace(component.getTargetNamespace());
                xsdImport.setSchemaLocation("urn:internal:" + typeDecl.getId());
                schema.getContents().add(0, (Object)xsdImport);
                schema.updateElement(true);
            }
        }

        private void changeElementToAnonymous(XSDElementDeclaration decl) {
            decl.updateElement(true);
            if (decl.getAnonymousTypeDefinition() == null) {
                XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                particle.setContent((XSDParticleContent)modelGroup);
                XSDComplexTypeDefinition complexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                complexTypeDefinition.setContent((XSDComplexTypeContent)particle);
                decl.setAnonymousTypeDefinition((XSDTypeDefinition)complexTypeDefinition);
                decl.updateElement(true);
                ComplexTypePropertyPage.this.contentProvider.setNewElement(modelGroup, ComplexTypePropertyPage.this.createNewElement());
                ComplexTypePropertyPage.this.viewer.refresh((Object)decl);
            }
        }

        private void changeAttribute(XSDAttributeDeclaration decl, Object newType) {
            XSDSimpleTypeDefinition oldDef = decl.getTypeDefinition();
            DefaultValueModifier.setOrRemoveAnnotation(decl, null);
            if (oldDef != null && oldDef.equals(newType)) {
                return;
            }
            decl.updateElement(true);
            if (newType == ELEMENT_TYPE) {
                XSDAttributeUse use = (XSDAttributeUse)decl.eContainer();
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)use.eContainer();
                XSDComplexTypeContent content = complexType.getContent();
                if (content instanceof XSDParticle) {
                    XSDModelGroup modelGroup = (XSDModelGroup)((XSDParticle)content).getContent();
                    XSDElementDeclaration newDecl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    newDecl.setName(decl.getName());
                    newDecl.setTypeDefinition((XSDTypeDefinition)decl.getTypeDefinition());
                    XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
                    newParticle.setContent((XSDParticleContent)newDecl);
                    complexType.getAttributeContents().remove((Object)use);
                    modelGroup.getContents().add((Object)newParticle);
                    complexType.updateElement(true);
                    if (complexType != ComplexTypePropertyPage.this.type) {
                        ComplexTypePropertyPage.this.viewer.refresh((Object)complexType);
                    }
                    ComplexTypePropertyPage.this.viewer.refresh();
                }
            } else if (newType instanceof XSDSimpleTypeDefinition) {
                decl.setTypeDefinition((XSDSimpleTypeDefinition)newType);
                decl.updateElement(true);
                ComplexTypePropertyPage.this.viewer.update((Object)decl, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
            }
            if (!XSDElementCheckForType.needsType((TypeDeclarationType)ComplexTypePropertyPage.this.declaration, (XSDTypeDefinition)oldDef)) {
                XSDSchema schema = ComplexTypePropertyPage.this.type.getSchema();
                TypeDeclarationUtils.removeImport((XSDSchema)schema, (XSDSchema)oldDef.getSchema());
                TypeDeclarationUtils.removeNameSpace((XSDSchema)schema, (String)oldDef.getName(), (String)((ModelType)ComplexTypePropertyPage.this.declaration.eContainer().eContainer()).getId());
                schema.updateElement(true);
            }
        }

        private void changeModelGroup(XSDModelGroup modelGroup, Object newType) {
            if (modelGroup.getCompositor() != newType) {
                if (newType instanceof XSDCompositor) {
                    modelGroup.updateElement(true);
                    modelGroup.setCompositor((XSDCompositor)newType);
                    modelGroup.updateElement(true);
                    ComplexTypePropertyPage.this.viewer.update((Object)modelGroup, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
                } else if (newType == ANONYMOUS_TYPE) {
                    this.changeModelGroupToAnonymousType(modelGroup);
                }
            }
        }

        private void changeModelGroupToAnonymousType(XSDModelGroup modelGroup) {
            modelGroup.updateElement(true);
            XSDModelGroup newModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            newModelGroup.setCompositor(modelGroup.getCompositor());
            ArrayList contents = new ArrayList();
            contents.addAll(modelGroup.getContents());
            newModelGroup.getContents().addAll(contents);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)newModelGroup);
            XSDComplexTypeDefinition complexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            complexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            XSDElementDeclaration decl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            decl.setAnonymousTypeDefinition((XSDTypeDefinition)complexTypeDefinition);
            XSDParticle oldParticle = (XSDParticle)modelGroup.eContainer();
            XSDModelGroup parent = (XSDModelGroup)oldParticle.eContainer();
            EList list = parent.getContents();
            decl.setName(ComplexTypePropertyPage.computeUniqueName(modelGroup.getCompositor().getName(), (List<XSDParticle>)list));
            XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
            newParticle.setContent((XSDParticleContent)decl);
            int ix = list.indexOf(oldParticle);
            list.remove(oldParticle);
            list.add(ix, newParticle);
            parent.updateElement(true);
            ComplexTypePropertyPage.this.contentProvider.removeNewElement(modelGroup);
            ComplexTypePropertyPage.this.contentProvider.setNewElement(newModelGroup, ComplexTypePropertyPage.this.createNewElement());
            ComplexTypePropertyPage.this.viewer.refresh((Object)parent);
        }

        private void setCardinality(XSDAttributeDeclaration decl, int cardinality) {
            decl.updateElement(true);
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)decl.eContainer();
            XSDAttributeUseCategory category = XSDAttributeUseCategory.get((int)cardinality);
            xsdAttributeUse.setUse(category);
            decl.updateElement();
            ComplexTypePropertyPage.this.viewer.update((Object)decl, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
        }

        private void setCardinality(XSDElementDeclaration decl, int cardinality) {
            decl.updateElement(true);
            if (decl.eContainer() instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)decl.eContainer();
                switch (cardinality) {
                    case 0: {
                        particle.unsetMinOccurs();
                        particle.unsetMaxOccurs();
                        break;
                    }
                    case 1: {
                        particle.setMinOccurs(0);
                        particle.unsetMaxOccurs();
                        break;
                    }
                    case 2: {
                        particle.setMinOccurs(0);
                        particle.setMaxOccurs(-1);
                        break;
                    }
                    case 3: {
                        particle.unsetMinOccurs();
                        particle.setMaxOccurs(-1);
                    }
                }
                decl.updateElement();
                ComplexTypePropertyPage.this.viewer.update((Object)decl, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
            }
        }

        private void setName(XSDNamedComponent component, String newName) {
            component.updateElement(true);
            if (ComplexTypePropertyPage.isNewType(component)) {
                if (NEW_ELEMENT_PLACEHOLDER.equals(newName) || StringUtils.isEmpty((String)newName.trim())) {
                    return;
                }
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)component;
                XSDModelGroup parent = ComplexTypePropertyPage.this.contentProvider.getEditingParent(xsdElement);
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                particle.setContent((XSDParticleContent)xsdElement);
                parent.getContents().add((Object)particle);
                xsdElement.setName(newName);
                XSDSimpleTypeDefinition stringType = ComplexTypePropertyPage.this.type.resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "string");
                xsdElement.setTypeDefinition((XSDTypeDefinition)stringType);
                component.updateElement();
                ComplexTypePropertyPage.this.contentProvider.setNewElement(parent, ComplexTypePropertyPage.this.createNewElement());
                ComplexTypePropertyPage.this.viewer.refresh((Object)parent);
                ComplexTypePropertyPage.this.updateButtons();
            } else {
                component.setName(newName);
                component.updateElement();
                ComplexTypePropertyPage.this.viewer.update((Object)component, StructLabelProvider.COMPLEX_TYPE_COLUMNS);
            }
            ComplexTypePropertyPage.this.validateInput();
        }
    }
}

