/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ReferencedModelSorter;
import org.eclipse.stardust.modeling.data.structured.StructContentProvider;
import org.eclipse.stardust.modeling.data.structured.StructLabelProvider;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DataStructPropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final int[] widths = new int[]{100, 100, 100};
    private Composite body;
    private StackLayout stackLayout;
    private TableViewer typesViewer;
    private TreeViewer detailsViewer;
    private ReferencedModelSorter refSorter = new ReferencedModelSorter();
    private StructLabelProvider typesViewerLabelProvider = new StructLabelProvider();
    private Button groupingCheckbox;
    private Composite typesComposite;
    private Composite typesDetailsComposite;
    private SashForm sashForm;
    private LabelWithStatus typesLabel;

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.body = FormBuilder.createComposite((Composite)composite, (int)1);
        this.stackLayout = new StackLayout();
        this.body.setLayout((Layout)this.stackLayout);
        this.sashForm = new SashForm(this.body, 256);
        this.typesComposite = FormBuilder.createComposite((Composite)this.sashForm, (int)1);
        this.typesDetailsComposite = FormBuilder.createComposite((Composite)this.sashForm, (int)1);
        this.sashForm.setWeights(new int[]{1, 2});
        this.typesLabel = FormBuilder.createLabelWithLeftAlignedStatus((Composite)this.typesComposite, (String)Structured_Messages.DataStructPropertyPage_DeclaredTypesLabel);
        FormBuilder.createLabel((Composite)this.typesDetailsComposite, (String)Structured_Messages.DataStructPropertyPage_DetailsLabel);
        Table declaredTypesTable = new Table(this.typesComposite, 67588);
        declaredTypesTable.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        this.typesViewer = new TableViewer(declaredTypesTable);
        this.typesViewer.setContentProvider((IContentProvider)new StructContentProvider(true));
        this.typesViewer.setSorter((ViewerSorter)this.refSorter);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.typesViewerLabelProvider);
        final Tree tree = FormBuilder.createTree((Composite)this.typesDetailsComposite, (int)67588);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        tree.setHeaderVisible(true);
        this.detailsViewer = new TreeViewer(tree);
        int i = 0;
        while (i < StructLabelProvider.COMPLEX_TYPE_COLUMNS.length) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(StructLabelProvider.COMPLEX_TYPE_COLUMNS[i]);
            if (i == 0) {
                column.setWidth(200);
            }
            ++i;
        }
        this.detailsViewer.setUseHashlookup(true);
        this.detailsViewer.setContentProvider((IContentProvider)new StructContentProvider(false));
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new StructLabelProvider());
        this.detailsViewer.setColumnProperties(StructLabelProvider.COMPLEX_TYPE_COLUMNS);
        this.typesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    TypeDeclarationType type = (TypeDeclarationType)selection.getFirstElement();
                    DataStructPropertyPage.this.setType((DataType)DataStructPropertyPage.this.getModelElement(), type);
                    DataStructPropertyPage.this.detailsViewer.setInput((Object)type);
                    if (!DataStructPropertyPage.this.detailsViewer.getTree().isEnabled()) {
                        DataStructPropertyPage.this.detailsViewer.expandAll();
                    }
                    if (TypeDeclarationUtils.getType((TypeDeclarationType)type) == 2) {
                        this.updateTableColumns(tree, StructLabelProvider.COMPLEX_TYPE_COLUMNS[0], true);
                    } else if (TypeDeclarationUtils.getType((TypeDeclarationType)type) == 1) {
                        this.updateTableColumns(tree, StructLabelProvider.SIMPLE_TYPE_COLUMNS[0], false);
                    }
                }
            }

            private void updateTableColumns(Tree tree2, String name, boolean visible) {
                TreeColumn first = tree2.getColumn(0);
                first.setText(name);
                int i = 1;
                while (i < StructLabelProvider.COMPLEX_TYPE_COLUMNS.length) {
                    TreeColumn column = tree2.getColumn(i);
                    if (visible) {
                        column.setWidth(widths[i]);
                    } else {
                        widths[i] = column.getWidth();
                        column.setWidth(0);
                    }
                    ++i;
                }
            }
        });
        Composite buttonComposite = FormBuilder.createComposite((Composite)composite, (int)1);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 16384;
        gd.verticalIndent = 0;
        buttonComposite.setLayoutData((Object)gd);
        this.groupingCheckbox = FormBuilder.createCheckBox((Composite)buttonComposite, (String)Diagram_Messages.LB_GroupModelElements);
        this.groupingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DataStructPropertyPage.this.refSorter.setGrouped(DataStructPropertyPage.this.groupingCheckbox.getSelection());
                DataStructPropertyPage.this.typesViewerLabelProvider.setShowGroupInfo(DataStructPropertyPage.this.groupingCheckbox.getSelection());
                DataStructPropertyPage.this.typesViewer.refresh(true);
            }
        });
        return composite;
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        DataType data = (DataType)element;
        IStructuredSelection selection = (IStructuredSelection)this.typesViewer.getSelection();
        if (selection.isEmpty()) {
            data.setExternalReference(null);
            AttributeUtil.setReference((IExtensibleElement)data, (String)"carnot:engine:dataType", null);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
        } else {
            TypeDeclarationType type = (TypeDeclarationType)selection.getFirstElement();
            this.setType(data, type);
        }
    }

    private void setType(DataType data, TypeDeclarationType type) {
        ModelType typeModel = ModelUtils.findContainingModel((EObject)type);
        if (typeModel == ModelUtils.findContainingModel((EObject)data)) {
            data.setExternalReference(null);
            AttributeUtil.setReference((IExtensibleElement)data, (String)"carnot:engine:dataType", (EObject)type);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
        } else {
            ExternalReferenceType ref = data.getExternalReference();
            if (ref == null) {
                ref = XpdlFactory.eINSTANCE.createExternalReferenceType();
                data.setExternalReference(ref);
            }
            ref.setLocation(typeModel.getId());
            ref.setXref(type.getId());
            AttributeUtil.setReference((IExtensibleElement)data, (String)"carnot:engine:dataType", null);
            String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)type, (String)"carnot:connection:uri");
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)uri);
        }
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        DataType data = (DataType)element;
        this.setDeclaredType(data);
        this.getWidgetBindingManager().getValidationBindingManager().bind((EObject)data, (Object)"carnot:engine:dataType", this.typesLabel);
    }

    private void setDeclaredType(DataType data) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        this.refSorter.setModel(model);
        this.typesViewerLabelProvider.setModel(model);
        this.typesViewer.setInput(this.collectTypeDeclarations(model));
        TypeDeclarationType type = StructuredTypeUtils.getTypeDeclaration((DataType)data);
        this.typesViewer.setSelection((ISelection)(type == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)type)));
        this.stackLayout.topControl = this.sashForm;
        this.body.layout();
    }

    private List<TypeDeclarationType> collectTypeDeclarations(ModelType model) {
        ExternalPackages packages;
        List declarations = CollectionUtils.newList();
        TypeDeclarationsType typeDeclarations = model.getTypeDeclarations();
        if (typeDeclarations != null) {
            declarations.addAll(typeDeclarations.getTypeDeclaration());
        }
        if ((packages = model.getExternalPackages()) != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                TypeDeclarationsType externalDeclarations;
                IConnectionManager manager;
                String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                if (StringUtils.isEmpty((String)uri) || (manager = model.getConnectionManager()) == null) continue;
                EObject externalModel = manager.find(uri);
                if (externalModel instanceof IObjectReference) {
                    externalModel = ((IObjectReference)externalModel).getEObject();
                }
                if (!(externalModel instanceof ModelType) || (externalDeclarations = ((ModelType)externalModel).getTypeDeclarations()) == null) continue;
                for (TypeDeclarationType declaration : externalDeclarations.getTypeDeclaration()) {
                    ExtendedAttributeType visibility = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)declaration.getExtendedAttributes(), (String)"carnot:engine:visibility");
                    if (visibility != null && !visibility.getValue().equalsIgnoreCase("Public")) continue;
                    declarations.add(declaration);
                }
            }
        }
        return declarations;
    }
}

