/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.XSDMapping;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.properties.DefaultValueModifier;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class DelegateCellEditor
extends CellEditor {
    private TreeEditor treeEditor;
    private TreeItem previousTreeItem;
    private TreeItem treeItem;
    private TableEditor tableEditor;
    private TableItem previousTableItem;
    private TableItem tableItem;
    private boolean enableEditor;
    private TextCellEditor textCellEditor;
    private ComboBoxCellEditor booleanEditor;
    private ComboBoxCellEditor enumerationEditor;
    private DatePickerCombo calendarEditor;
    private Object currentEditor;
    private DateFormat dateFormat = new SimpleDateFormat(Structured_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY);

    public DelegateCellEditor(Composite parent) {
        if (parent instanceof Table) {
            this.tableEditor = new TableEditor((Table)parent);
            this.tableEditor.grabHorizontal = true;
            this.tableEditor.grabVertical = true;
        } else {
            this.treeEditor = new TreeEditor((Tree)parent);
            this.treeEditor.grabHorizontal = true;
            this.treeEditor.grabVertical = true;
        }
        this.textCellEditor = new TextCellEditor(parent);
        this.booleanEditor = new ComboBoxCellEditor(parent, new String[0]){

            public void setItems(String[] items) {
                String[] booleanValues = new String[]{"", "true", "false"};
                super.setItems(booleanValues);
            }
        };
        this.enumerationEditor = new ComboBoxCellEditor(parent, new String[0]);
        this.calendarEditor = new DatePickerCombo(parent, 2048);
        this.calendarEditor.setDateFormat(this.dateFormat);
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected Object doGetValue() {
        if (this.currentEditor != null) {
            if (this.currentEditor instanceof CellEditor) {
                Object object = ((CellEditor)this.currentEditor).getValue();
                if (this.currentEditor.equals(this.booleanEditor)) {
                    if ((Integer)object < 0) {
                        return null;
                    }
                    String[] items = this.booleanEditor.getItems();
                    List<String> list = Arrays.asList(items);
                    this.booleanEditor.setValue((Object)((Integer)object));
                    return list.get((Integer)object);
                }
                if (this.currentEditor.equals(this.enumerationEditor)) {
                    if ((Integer)object < 0) {
                        return null;
                    }
                    String[] items = this.enumerationEditor.getItems();
                    List<String> list = Arrays.asList(items);
                    this.enumerationEditor.setValue((Object)((Integer)object));
                    return list.get((Integer)object);
                }
                ((CellEditor)this.currentEditor).setValue(object);
                return object;
            }
            if (this.currentEditor instanceof DatePickerCombo) {
                String object = ((DatePickerCombo)this.currentEditor).getText();
                return object;
            }
        }
        return null;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
    }

    public void enableEditor(boolean enable) {
        this.enableEditor = enable;
        if (!this.enableEditor) {
            this.calendarEditor.setVisible(false);
            this.currentEditor = null;
            if (this.treeEditor != null) {
                this.treeEditor.setEditor(null);
                this.treeEditor.layout();
            } else if (this.tableEditor != null) {
                this.tableEditor.setEditor(null);
                this.tableEditor.layout();
            }
        }
    }

    public Item setItem(Item item) {
        this.currentEditor = null;
        this.calendarEditor.setVisible(false);
        this.enumerationEditor.setItems(new String[0]);
        Object element = item.getData();
        String setValue = null;
        String javaTypeName = null;
        XSDSimpleTypeDefinition simpleType = null;
        if (this.enableEditor) {
            XSDSimpleTypeDefinition typeDefinition;
            if (element instanceof XSDAttributeDeclaration) {
                typeDefinition = ((XSDAttributeDeclaration)element).getTypeDefinition();
                if (typeDefinition.getComplexType() == null) {
                    simpleType = typeDefinition.getSimpleType();
                    javaTypeName = XSDMapping.getJavaTypeForXSDType((String)typeDefinition.getName());
                    setValue = DefaultValueModifier.getStringForElement((XSDComponent)element);
                }
            } else if (element instanceof XSDElementDeclaration && (typeDefinition = ((XSDElementDeclaration)element).getTypeDefinition()) != null && typeDefinition.getComplexType() == null) {
                simpleType = typeDefinition.getSimpleType();
                javaTypeName = XSDMapping.getJavaTypeForXSDType((String)typeDefinition.getName());
                setValue = DefaultValueModifier.getStringForElement((XSDComponent)element);
            }
        }
        if (item instanceof TreeItem) {
            this.previousTreeItem = this.treeItem != null ? this.treeItem : (TreeItem)item;
            this.treeItem = (TreeItem)item;
        } else if (item instanceof TableItem) {
            this.previousTableItem = this.tableItem != null ? this.tableItem : (TableItem)item;
            this.tableItem = (TableItem)item;
        }
        if (!StringUtils.isEmpty(javaTypeName)) {
            if (javaTypeName.equals(Date.class.getName())) {
                this.calendarEditor.setVisible(true);
                this.currentEditor = this.calendarEditor;
                if (this.treeEditor != null) {
                    this.treeEditor.setEditor((Control)this.calendarEditor, this.treeItem, 3);
                } else if (this.tableEditor != null) {
                    this.tableEditor.setEditor((Control)this.calendarEditor, this.tableItem, 1);
                }
                this.calendarEditor.setFocus();
            } else if (javaTypeName.equals(Boolean.class.getName())) {
                this.currentEditor = this.booleanEditor;
                if (this.treeEditor != null) {
                    this.treeEditor.setEditor(this.booleanEditor.getControl(), this.treeItem, 3);
                } else if (this.tableEditor != null) {
                    this.tableEditor.setEditor(this.booleanEditor.getControl(), this.tableItem, 1);
                }
                this.booleanEditor.setFocus();
            } else {
                this.currentEditor = this.textCellEditor;
                if (this.treeEditor != null) {
                    this.treeEditor.setEditor(this.textCellEditor.getControl(), this.treeItem, 3);
                } else if (this.tableEditor != null) {
                    this.tableEditor.setEditor(this.textCellEditor.getControl(), this.tableItem, 1);
                }
                this.textCellEditor.setFocus();
            }
        } else if (simpleType != null) {
            EList elements = simpleType.getEnumerationFacets();
            if (elements.isEmpty()) {
                elements = simpleType.getPatternFacets();
            }
            if (!elements.isEmpty()) {
                String[] namesArray = new String[elements.size() + 1];
                namesArray[0] = "";
                int i = 0;
                while (i < elements.size()) {
                    XSDConstrainingFacet entry = (XSDConstrainingFacet)elements.get(i);
                    namesArray[i + 1] = entry.getLexicalValue();
                    ++i;
                }
                this.enumerationEditor.setItems(namesArray);
                this.currentEditor = this.enumerationEditor;
                if (this.treeEditor != null) {
                    this.treeEditor.setEditor(this.enumerationEditor.getControl(), this.treeItem, 3);
                } else if (this.tableEditor != null) {
                    this.tableEditor.setEditor(this.enumerationEditor.getControl(), this.tableItem, 1);
                }
                this.enumerationEditor.setFocus();
            }
        }
        if (this.currentEditor != null) {
            List<String> list;
            String[] items;
            if (this.currentEditor.equals(this.calendarEditor)) {
                if (!StringUtils.isEmpty((String)setValue)) {
                    Date date;
                    try {
                        date = this.dateFormat.parse(setValue);
                    }
                    catch (ParseException parseException) {
                        date = null;
                    }
                    if (date != null) {
                        ((DatePickerCombo)this.currentEditor).setDate(date);
                    }
                }
            } else if (this.currentEditor.equals(this.booleanEditor)) {
                ((ComboBoxCellEditor)this.currentEditor).setFocus();
                items = ((ComboBoxCellEditor)this.currentEditor).getItems();
                list = Arrays.asList(items);
                ((ComboBoxCellEditor)this.currentEditor).setValue((Object)new Integer(list.lastIndexOf(setValue)));
            } else if (this.currentEditor.equals(this.enumerationEditor)) {
                this.enumerationEditor.setFocus();
                items = this.enumerationEditor.getItems();
                list = Arrays.asList(items);
                this.enumerationEditor.setValue((Object)new Integer(list.lastIndexOf(setValue)));
            } else if (this.currentEditor.equals(this.textCellEditor)) {
                if (setValue == null) {
                    ((TextCellEditor)this.currentEditor).setValue((Object)"");
                } else {
                    ((TextCellEditor)this.currentEditor).setValue((Object)setValue);
                }
            }
        }
        if (this.treeEditor != null) {
            this.treeEditor.layout();
        } else if (this.tableEditor != null) {
            this.tableEditor.layout();
        }
        TreeItem returnValue = null;
        if (item instanceof TreeItem) {
            returnValue = this.previousTreeItem;
        } else if (item instanceof TableItem) {
            returnValue = this.previousTableItem;
        }
        return returnValue;
    }
}

