/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import com.infinity.bpm.thirdparty.emf.common.util.URI;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;

public class DataValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        DataType data = (DataType)element;
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:connection:uri");
        if (data.getExternalReference() != null) {
            return null;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String typeId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType");
        if (StringUtils.isEmpty((String)typeId)) {
            issues.add(new Issue(2, (EObject)element, Structured_Messages.DataValidator_NoType, (Object)"carnot:engine:dataType"));
        } else {
            TypeDeclarationsType declarations = null;
            if (attribute != null) {
                String uri = attribute.getValue();
                URI aRealUri = URI.createURI((String)uri);
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                if (connection.getAttribute("importByReference") != null && !"false".equals(connection.getAttribute("importByReference"))) {
                    EObject o = model.getConnectionManager().find(String.valueOf(aRealUri.scheme().toString()) + "://" + aRealUri.authority() + "/");
                    ModelType referencedModel = (ModelType)Reflect.getFieldValue((Object)o, (String)"eObject");
                    declarations = referencedModel.getTypeDeclarations();
                } else {
                    declarations = model.getTypeDeclarations();
                }
            } else {
                declarations = model.getTypeDeclarations();
            }
            TypeDeclarationType type = null;
            if (declarations != null) {
                type = declarations.getTypeDeclaration(typeId);
            }
            if (type == null) {
                String message = String.valueOf(Structured_Messages.DataValidator_InvalidType) + typeId;
                issues.add(new Issue(1, (EObject)element, message, (Object)"carnot:engine:dataType"));
            }
        }
        return issues.toArray(new Issue[issues.size()]);
    }
}

