/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.spi.StructuredDataTransformation;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.validation.StructBridgeObject;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.Path;
import org.eclipse.stardust.modeling.validation.util.PathEntry;
import org.w3c.dom.Element;

public class StructBridgeObjectProvider
implements IBridgeObjectProvider {
    private static Map<String, String> mapping = new HashMap<String, String>();
    private StructuredDataTransformation xomDomTrans;
    private ITypedElement element;

    static {
        mapping.put("string", String.class.getName());
        mapping.put("boolean", Boolean.class.getName());
        mapping.put("int", Integer.class.getName());
        mapping.put("long", Long.class.getName());
        mapping.put("short", Short.class.getName());
        mapping.put("byte", Byte.class.getName());
        mapping.put("double", Double.class.getName());
        mapping.put("float", Float.class.getName());
        mapping.put("decimal", BigDecimal.class.getName());
        mapping.put("dateTime", Date.class.getName());
        mapping.put("date", Date.class.getName());
        mapping.put("time", Date.class.getName());
        mapping.put("duration", Long.class.getName());
    }

    public BridgeObject getBridgeObject(ITypedElement ap, String accessPath, DirectionType direction) throws ValidationException {
        PathEntry entry = new PathEntry(ap, direction);
        if (accessPath != null) {
            this.xomDomTrans = StructuredDataTransformation.valueOf((String)accessPath);
            this.element = ap;
            if (ap instanceof AccessPointType && ap.getMetaType().getId().startsWith("struct")) {
                entry = this.getPathByAccessPointType(ap, accessPath, direction);
            }
        }
        String javaType = null;
        if (accessPath != null) {
            Path path;
            block7: {
                path = new Path(entry);
                if (accessPath.matches(StructuredTypeUtils.TRANSFORMATION_PATTERN.pattern())) {
                    String xomDomPath = accessPath;
                    String copy = accessPath;
                    copy = copy.substring(4);
                    copy = copy.substring(0, copy.length() - 1);
                    path.setMethod(copy);
                    if (!StructuredTypeUtils.isValidDomAccessPath((DataType)((DataType)this.element), (String)accessPath)) {
                        throw new ValidationException(Structured_Messages.EXC_XOM_DOM_TRANSFORMATION_IS_NOT_VALID_FOR_THIS_DATAPATH, (Object)xomDomPath);
                    }
                }
                try {
                    path.setMethod(accessPath);
                }
                catch (ValidationException ve) {
                    if (accessPath != null && accessPath.matches(StructuredTypeUtils.TRANSFORMATION_PATTERN.pattern())) break block7;
                    throw ve;
                }
            }
            entry = path.getSelection();
        }
        javaType = entry.isSingle() ? ("struct".equals(entry.getElement().getMetaType().getId()) ? (this.isDOM(this.xomDomTrans) ? Element.class.getName() : (this.isEnumeration(entry) ? String.class.getName() : Map.class.getName())) : entry.getSimpleTypeName()) : List.class.getName();
        IType accessPointType = JavaDataTypeUtils.getTypeFromCurrentProject((String)javaType);
        return new StructBridgeObject(accessPointType, direction, entry);
    }

    private boolean isEnumeration(PathEntry entry) {
        TypeDeclarationType type;
        ITypedElement data = entry.getElement();
        return (data instanceof DataType || data instanceof AccessPointType) && (type = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:dataType")) != null && TypeDeclarationUtils.getType((TypeDeclarationType)type) == 1;
    }

    private boolean isDOM(StructuredDataTransformation trans) {
        return trans != null && trans.getType().toString().equalsIgnoreCase("DOM");
    }

    private PathEntry getPathByAccessPointType(ITypedElement ap, String accessPath, DirectionType direction) {
        ModelType modelType = ModelUtils.findContainingModel((EObject)ap);
        AccessPointType apt = (AccessPointType)ap;
        String type = AttributeUtil.getAttributeValue((List)apt.getAttribute(), (String)"carnot:engine:dataType");
        TypeDeclarationType decl = modelType.getTypeDeclarations().getTypeDeclaration(type);
        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)decl);
        ap = new StructAccessPointType(xPathMap.getRootXPath(), xPathMap);
        ((AccessPointType)ap).setType((DataTypeType)apt.getMetaType());
        AccessPointType d = apt;
        ((AccessPointType)ap).setId(d.getId());
        ((AccessPointType)ap).setName(d.getName());
        PathEntry root = new PathEntry(ap, direction);
        return root;
    }
}

