/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.model.beans.QNameUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.SchemaLocatorAdapter;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.parts.dialog.ApplyUpdatesCommand;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.wizards.ImportIdDialog;
import org.eclipse.stardust.modeling.data.structured.wizards.SchemaLocationPage;
import org.eclipse.stardust.modeling.data.structured.wizards.XSDSelectSingleFilePage;
import org.eclipse.stardust.modeling.data.structured.wizards.XSDTypesSelectionPage;
import org.eclipse.stardust.modeling.data.structured.wizards.XSDURLPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ImportFromSchemaWizard
extends Wizard
implements INewWizard {
    private List<XSDSchema> externalSchemaList = new ArrayList<XSDSchema>();
    private SchemaLocationPage choicePage;
    private XSDSelectSingleFilePage filePage;
    private XSDURLPage urlPage;
    private XSDTypesSelectionPage typesPage;
    private IFile resultFile;
    private String resultURL;
    private TypeDeclarationsType typeDeclarations;
    private ApplyUpdatesCommand command;
    private InputSource resource;
    private XSDResourceImpl emfResource;
    private List<TypeDeclarationType> declarations;
    static final String HTTP = "http://";

    public ImportFromSchemaWizard(TypeDeclarationsType typeDeclarations) {
        this(typeDeclarations, null, null, false);
    }

    public ImportFromSchemaWizard(TypeDeclarationsType typeDeclarations, String location, InputSource resource, boolean hasCreateParserButton) {
        this.typeDeclarations = typeDeclarations;
        this.resource = resource;
        String title = Structured_Messages.ImportFromSchemaWizardTitle;
        this.setWindowTitle(title);
        this.setDefaultPageImageDescriptor(DiagramPlugin.imageDescriptorFromPlugin((String)"org.eclipse.xsd.editor", (String)"icons/full/wizban/NewXSD.gif"));
        this.setNeedsProgressMonitor(true);
        this.choicePage = new SchemaLocationPage(location);
        this.filePage = new XSDSelectSingleFilePage(this, PlatformUI.getWorkbench(), null, true);
        this.filePage.setTitle(title);
        this.filePage.setDescription(Structured_Messages.SelectFilePageDescription);
        this.filePage.addFilterExtensions(new String[]{".xsd", ".wsdl"});
        this.urlPage = new XSDURLPage(this, location);
        this.urlPage.setTitle(title);
        this.urlPage.setDescription(Structured_Messages.URLPageDescription);
        this.typesPage = new XSDTypesSelectionPage(this, true, hasCreateParserButton);
        this.typesPage.setTitle(title);
        this.typesPage.setDescription(Structured_Messages.XSDTypesPageDescription);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.choicePage);
        this.addPage((IWizardPage)this.filePage);
        this.addPage((IWizardPage)this.urlPage);
        this.addPage((IWizardPage)this.typesPage);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        WizardPage nextPage = null;
        if (currentPage == this.choicePage) {
            nextPage = this.choicePage.isURL() ? this.urlPage : this.filePage;
        } else if (currentPage == this.urlPage || currentPage == this.filePage) {
            nextPage = this.typesPage;
        }
        return nextPage;
    }

    public boolean canFinish() {
        return this.typesPage.isPageComplete();
    }

    public boolean performFinish() {
        XSDNamedComponent component;
        List idCache = CollectionUtils.newList();
        int i = 0;
        while (i < this.typeDeclarations.getTypeDeclaration().size()) {
            TypeDeclarationType declaration = (TypeDeclarationType)this.typeDeclarations.getTypeDeclaration().get(i);
            idCache.add(declaration.getId());
            ++i;
        }
        IFile xsdFileInWorkspace = null;
        if (this.isURL()) {
            this.resultURL = this.urlPage.getURL();
        } else {
            xsdFileInWorkspace = this.resultFile = this.filePage.getFile();
        }
        IFile file = null;
        if (this.isURL() && this.urlPage.saveToWorkspace && !this.externalSchemaList.isEmpty()) {
            xsdFileInWorkspace = file = this.doSaveExternalModel();
        }
        this.declarations = CollectionUtils.newList();
        Map schema2location = CollectionUtils.newMap();
        IStructuredSelection selection = this.typesPage.getSelection();
        HashMap<String, String> name2id = new HashMap<String, String>();
        for (Object item : selection) {
            String id;
            if (!(item instanceof XSDTypeDefinition) && !(item instanceof XSDElementDeclaration) || (component = (XSDNamedComponent)item).getContainer() != component.getSchema() || !idCache.contains(id = component.getName())) continue;
            ImportIdDialog importIdDialog = new ImportIdDialog(null, id, idCache);
            if (importIdDialog.open() == 0) {
                String name = importIdDialog.getId();
                name2id.put(name, id);
                component.setName(name);
                continue;
            }
            return false;
        }
        for (Object item : selection) {
            if (!(item instanceof XSDTypeDefinition) && !(item instanceof XSDElementDeclaration) || (component = (XSDNamedComponent)item).getContainer() != component.getSchema()) continue;
            XSDSchema schema = component.getSchema();
            TypeDeclarationType declaration = XpdlFactory.eINSTANCE.createTypeDeclarationType();
            this.declarations.add(declaration);
            String id = component.getName();
            declaration.setId(id);
            declaration.setName(id);
            if (this.typesPage.mustSaveSchema() && !schema2location.containsKey(schema)) {
                ((InternalEObject)schema).eSetResource((Resource.Internal)this.typeDeclarations.eResource(), null);
                String location = "urn:internal:" + id;
                EList referencingDirectives = schema.getReferencingDirectives();
                int j = 0;
                while (j < referencingDirectives.size()) {
                    XSDSchemaDirective directive = (XSDSchemaDirective)referencingDirectives.get(j);
                    directive.setSchemaLocation(location);
                    ++j;
                }
                schema2location.put(schema, location);
                SchemaTypeType schemaType = XpdlFactory.eINSTANCE.createSchemaTypeType();
                declaration.setSchemaType(schemaType);
                schemaType.setSchema(schema);
            } else {
                ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
                String useId = (String)name2id.get(id);
                if (StringUtils.isEmpty((String)useId)) {
                    useId = id;
                }
                reference.setXref(QNameUtil.toString((String)schema.getTargetNamespace(), (String)useId));
                reference.setLocation(this.typesPage.mustSaveSchema() ? (String)schema2location.get(schema) : (this.isURL() ? this.resultURL : this.urlPage.getClasspathResourceName(this.resultFile)));
                declaration.setExternalReference(reference);
            }
            if (this.isURL() && this.urlPage.saveToWorkspace) {
                ExtendedAttributeUtil.setAttribute((Extensible)declaration, (String)"carnot:engine:resource:mapping:localFile", (String)this.urlPage.getClasspathResourceName(file));
            }
            if (xsdFileInWorkspace == null) continue;
            ExtendedAttributeUtil.setAttribute((Extensible)declaration, (String)"carnot:engine:resource:mapping:eclipseWorkspaceFile", (String)xsdFileInWorkspace.getFullPath().toString());
        }
        ChangeRecorder recorder = new ChangeRecorder();
        recorder.beginRecording(Collections.singleton(this.typeDeclarations));
        int i2 = 0;
        while (i2 < this.declarations.size()) {
            TypeDeclarationType declaration = this.declarations.get(i2);
            TypeDeclarationType oldDeclaration = this.typeDeclarations.getTypeDeclaration(declaration.getId());
            if (oldDeclaration != null) {
                this.typeDeclarations.getTypeDeclaration().remove((Object)oldDeclaration);
            }
            this.typeDeclarations.getTypeDeclaration().add((Object)declaration);
            ++i2;
        }
        ChangeDescription recording = recorder.endRecording();
        this.command = new ApplyUpdatesCommand(recording);
        for (Map.Entry entry : schema2location.entrySet()) {
            XSDSchema schema = (XSDSchema)entry.getKey();
            schema.setSchemaLocation((String)entry.getValue());
            schema.reset();
        }
        for (XSDSchema schema : schema2location.keySet()) {
            Map prefixes = schema.getQNamePrefixToNamespaceMap();
            Map copy = CollectionUtils.newMap();
            copy.putAll(prefixes);
            prefixes.putAll(copy);
        }
        return true;
    }

    private IFile doSaveExternalModel() {
        IFile file = null;
        if (this.isURL() && this.urlPage.saveToWorkspace) {
            IFolder folder = this.urlPage.getSaveFolder();
            int end = this.resultURL.indexOf(63);
            if (end < 0) {
                end = this.resultURL.length();
            }
            while (end > 0 && this.resultURL.charAt(end - 1) == '/') {
                --end;
            }
            int start = this.resultURL.lastIndexOf(47, end - 1);
            start = start < 0 ? 0 : ++start;
            String localName = this.resultURL.substring(start, end);
            if (localName.length() == 0) {
                localName = "schema";
            }
            if (localName.indexOf(46) < 0) {
                localName = String.valueOf(localName) + ".xsd";
            }
            if ((file = folder.getFile(localName)).exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.SKIP_LABEL};
                String question = NLS.bind((String)IDEWorkbenchMessages.SaveAsDialog_overwriteQuestion, (Object)file.getFullPath().toOSString());
                MessageDialog dialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.Question, null, question, 3, buttons, 0);
                if (dialog.open() != 0) {
                    return file;
                }
            }
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                XSDSchema schema = this.externalSchemaList.get(0);
                XSDResourceImpl.serialize((OutputStream)outputStream, (Document)schema.getDocument(), (String)"UTF-8");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                if (file.exists()) {
                    file.setContents((InputStream)inputStream, 2, null);
                } else {
                    file.create((InputStream)inputStream, 2, null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public List<XSDSchema> getExternalSchemaList() {
        return this.externalSchemaList;
    }

    public IFile getResultFile() {
        return this.resultFile;
    }

    public String getURL() {
        return this.getResultURL();
    }

    protected String doLoadExternalModel(IProgressMonitor monitor, String xsdModelFile, String xsdFileName) {
        String errorMessage = null;
        monitor.beginTask(Structured_Messages.LoadingSchemaTaskName, 100);
        monitor.worked(50);
        this.emfResource = new XSDResourceImpl(URI.createURI((String)xsdModelFile));
        this.emfResource.eAdapters().add((Object)new SchemaLocatorAdapter());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResources().add((Object)this.emfResource);
        InputSource is = this.resource;
        if (is == null) {
            is = new InputSource(xsdModelFile);
        }
        try {
            this.emfResource.load(is, CollectionUtils.newMap());
            this.externalSchemaList.clear();
            EList resourceContents = this.emfResource.getContents();
            int i = 0;
            while (i < resourceContents.size()) {
                EObject eObject = (EObject)resourceContents.get(i);
                if (eObject instanceof XSDSchema) {
                    XSDSchema externalSchema = (XSDSchema)eObject;
                    if (externalSchema.getElement() != null && (externalSchema.getDiagnostics() == null || externalSchema.getDiagnostics().isEmpty())) {
                        this.externalSchemaList.add(externalSchema);
                    } else if (errorMessage == null) {
                        errorMessage = Structured_Messages.IncorrectSchemaMessage;
                    }
                }
                ++i;
            }
            if (errorMessage == null && this.externalSchemaList.isEmpty()) {
                errorMessage = Structured_Messages.IncorrectSchemaMessage;
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        int i = 0;
        while (i < this.externalSchemaList.size()) {
            XSDSchema schema = this.externalSchemaList.get(i);
            TypeDeclarationUtils.resolveImports((XSDSchema)schema);
            XSDTypesSelectionPage.checkNamespaceDeclaration(schema, schema.getSchemaForSchemaNamespace(), "xsd");
            ++i;
        }
        monitor.subTask(Structured_Messages.FinishLoadingTaskName);
        monitor.worked(80);
        this.typesPage.updateContent();
        return errorMessage;
    }

    public boolean isURL() {
        return this.choicePage.isURL();
    }

    String getResultURL() {
        return this.resultURL;
    }

    public Command getCommand() {
        return this.command;
    }

    public TypeDeclarationsType getTypeDeclarations() {
        return this.typeDeclarations;
    }

    public boolean getCreateParserApplication() {
        return this.typesPage.createParser;
    }

    public List<TypeDeclarationType> getDeclarations() {
        return this.declarations;
    }

    private static final class IDEWorkbenchMessages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.ui.internal.ide.messages";
        public static String SaveAsDialog_overwriteQuestion;
        public static String Question;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, Structured_Messages.class);
        }

        private IDEWorkbenchMessages() {
        }
    }
}

