/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ImportIdDialog
extends Dialog {
    private List<String> idCache;
    private LabeledText idEntry;
    private String id;
    private final String idPrefix = "CopyOf";
    private ModifyListener idListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ImportIdDialog.this.idEntry != null) {
                boolean enabled = false;
                enabled = ImportIdDialog.this.validateUserInput();
                Button okButton = ImportIdDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(enabled);
                }
            }
        }
    };

    public ImportIdDialog(Shell parent, String id, List<String> idCache) {
        super(parent);
        this.idCache = idCache;
        this.id = id;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Structured_Messages.ImportIdDialog_Label);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIdCache() {
        return this.idCache;
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        ((GridLayout)panel.getLayout()).numColumns = 2;
        this.idEntry = FormBuilder.createLabeledText((Composite)panel, (String)Structured_Messages.ImportIdDialog_Id);
        this.idEntry.getText().addModifyListener(this.idListener);
        String prefixId = this.generatePrefixString(false);
        this.idEntry.getText().setText(prefixId);
        return panel;
    }

    private String generatePrefixString(boolean isName) {
        StringBuffer generatedString = null;
        generatedString = new StringBuffer("CopyOf");
        generatedString.append(this.id);
        while (this.idCache.contains(generatedString.toString())) {
            generatedString.insert(0, "CopyOf");
        }
        return generatedString.toString();
    }

    private boolean validateUserInput() {
        this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        if (StringUtils.isEmpty((String)this.idEntry.getText().getText())) {
            this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.idEntry.getLabel().setToolTipText(Structured_Messages.ImportIdDialog_EmptyId);
            return false;
        }
        if (this.idCache.contains(this.idEntry.getText().getText())) {
            this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.idEntry.getLabel().setToolTipText(Structured_Messages.ImportIdDialog_DuplicateId);
            return false;
        }
        return true;
    }

    public void create() {
        super.create();
        boolean enabled = false;
        enabled = this.validateUserInput();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    protected void okPressed() {
        this.id = this.idEntry.getText().getText();
        this.idCache.add(this.id);
        super.okPressed();
    }
}

