/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.wizards.ResourceFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemImportWizard;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class SelectSingleFileView {
    protected Composite composite;
    protected IStructuredSelection selection;
    protected boolean isFileMandatory;
    protected TreeViewer sourceFileViewer;
    protected Button importButton;
    protected Vector<ViewerFilter> fFilters;
    protected IFile selectedFile;
    protected ISelection defaultSelection;
    protected Listener listener;
    private IJavaProject javaProject;

    public SelectSingleFileView(IStructuredSelection selection, boolean isFileMandatory, IProject project) {
        this.selection = selection;
        this.isFileMandatory = isFileMandatory;
        this.selectedFile = null;
        this.defaultSelection = null;
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.javaProject = JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite smallComposite = new Composite(composite, 0);
        smallComposite.setLayoutData((Object)new GridData(4, 256, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        smallComposite.setLayout((Layout)gridLayout);
        Label label = new Label(smallComposite, 0);
        label.setText(Structured_Messages.WorkbenchFilesLabel);
        label.setLayoutData((Object)new GridData(32, 3, false, false));
        ToolBar toolBar = new ToolBar(smallComposite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(3, 3, true, false));
        ToolItem toolItem = new ToolItem(toolBar, 0);
        ImageDescriptor imageDescriptor = DiagramPlugin.getImageDescriptor((String)"{org.eclipse.wst.common.ui}icons/expandAll.gif");
        Image image = imageDescriptor.createImage();
        toolItem.setImage(image);
        toolItem.setToolTipText(Structured_Messages.ExpandAllLabel);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectSingleFileView.this.sourceFileViewer.expandAll();
            }
        });
        toolItem = new ToolItem(toolBar, 0);
        imageDescriptor = DiagramPlugin.getImageDescriptor((String)"{org.eclipse.wst.common.ui}icons/collapseAll.gif");
        image = imageDescriptor.createImage();
        toolItem.setImage(image);
        toolItem.setToolTipText(Structured_Messages.CollapseAllLabel);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectSingleFileView.this.sourceFileViewer.collapseAll();
            }
        });
        this.createSourceViewer(composite);
        this.createFilterControl(composite);
        this.createImportButton(composite);
        this.sourceFileViewer.getTree().setFocus();
        return composite;
    }

    protected void createFilterControl(Composite composite) {
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void createSourceViewer(Composite parent) {
        this.sourceFileViewer = new TreeViewer(new Tree(parent, 2052));
        this.sourceFileViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IJavaProject) {
                    List result = CollectionUtils.newList();
                    try {
                        IPackageFragmentRoot[] roots = element == SelectSingleFileView.this.javaProject ? SelectSingleFileView.this.javaProject.getAllPackageFragmentRoots() : ((IJavaProject)element).getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            IResource resource = roots[i].getCorrespondingResource();
                            if (resource instanceof IFolder) {
                                result.add(resource);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    return result.toArray();
                }
                return super.getChildren(element);
            }
        });
        this.sourceFileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sourceFileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isComplete = true;
                ISelection selection = event.getSelection();
                SelectSingleFileView.this.importButton.setEnabled(selection != null && !selection.isEmpty());
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    for (IResource resource : list) {
                        if (resource instanceof IFile) {
                            SelectSingleFileView.this.selectedFile = (IFile)resource;
                            if (!SelectSingleFileView.this.isFileMandatory) continue;
                            isComplete = true;
                            break;
                        }
                        SelectSingleFileView.this.selectedFile = null;
                        if (!SelectSingleFileView.this.isFileMandatory) continue;
                        isComplete = false;
                    }
                    if (SelectSingleFileView.this.listener != null) {
                        SelectSingleFileView.this.listener.setControlComplete(isComplete);
                    }
                }
            }
        });
        Tree treeWidget = this.sourceFileViewer.getTree();
        GridData gd = new GridData(1808);
        treeWidget.setLayoutData((Object)gd);
    }

    protected void createImportButton(Composite parent) {
        this.importButton = new Button(parent, 0);
        this.importButton.setEnabled(false);
        this.importButton.setText(Structured_Messages.ImportFilesButtonLabel);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.importButton.setLayoutData((Object)gridData);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportAddResourceListener importAddResourceListener = new ImportAddResourceListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)importAddResourceListener);
                FileSystemImportWizard importWizard = new FileSystemImportWizard(){
                    private IWorkbench workbench;
                    private IStructuredSelection selection;
                    private ModifiedWizardFileSystemResourceImportPage1 mainPage;

                    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
                        super.init(workbench, currentSelection);
                        this.workbench = workbench;
                        this.selection = currentSelection;
                    }

                    public void addPages() {
                        this.mainPage = new ModifiedWizardFileSystemResourceImportPage1(this.workbench, this.selection);
                        this.addPage((IWizardPage)this.mainPage);
                    }

                    public boolean performFinish() {
                        return this.mainPage.finish();
                    }
                };
                IWorkbench workbench = PlatformUI.getWorkbench();
                SelectSingleFileView.this.selection = (IStructuredSelection)SelectSingleFileView.this.sourceFileViewer.getSelection();
                importWizard.init(workbench, (IStructuredSelection)(SelectSingleFileView.this.selection != null ? SelectSingleFileView.this.selection : new StructuredSelection()));
                Shell shell = Display.getCurrent().getActiveShell();
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)importWizard);
                wizardDialog.create();
                wizardDialog.open();
                SelectSingleFileView.this.sourceFileViewer.refresh();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)importAddResourceListener);
                IFile importedFile = importAddResourceListener.getImportedFile();
                if (importedFile != null) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)importedFile);
                    SelectSingleFileView.this.sourceFileViewer.setSelection((ISelection)structuredSelection);
                }
            }
        });
        this.importButton.setToolTipText(Structured_Messages.ImportFilesButtonToolTip);
    }

    public IFile getFile() {
        return this.selectedFile;
    }

    public void setDefaultSelection(ISelection selection) {
        this.defaultSelection = selection;
    }

    public void resetFilters() {
        this.fFilters = null;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new Vector();
        }
        this.fFilters.add(filter);
    }

    public void addFilterExtensions(String[] filterExtensions) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        this.addFilter(new ResourceFilter(correctedFilterExtensions));
    }

    public void setFilterExtensions(String[] filterExtensions) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        ResourceFilter filter = new ResourceFilter(correctedFilterExtensions);
        this.fFilters = new Vector();
        this.fFilters.add(filter);
        if (this.sourceFileViewer != null) {
            this.sourceFileViewer.getTree().setRedraw(false);
            this.sourceFileViewer.resetFilters();
            Iterator<ViewerFilter> i2 = this.fFilters.iterator();
            while (i2.hasNext()) {
                this.sourceFileViewer.addFilter(i2.next());
            }
            this.sourceFileViewer.getTree().setRedraw(true);
            this.sourceFileViewer.getTree().redraw();
        }
    }

    public void setVisibleHelper(boolean visible) {
        if (visible) {
            if (this.fFilters != null) {
                this.sourceFileViewer.resetFilters();
                Iterator<ViewerFilter> i = this.fFilters.iterator();
                while (i.hasNext()) {
                    this.sourceFileViewer.addFilter(i.next());
                }
            }
            this.sourceFileViewer.setInput(this.javaProject == null ? ResourcesPlugin.getWorkspace().getRoot() : this.javaProject);
            this.sourceFileViewer.expandToLevel(1);
            if (this.defaultSelection != null) {
                this.sourceFileViewer.setSelection(this.defaultSelection, true);
            } else if (!this.sourceFileViewer.getSelection().isEmpty()) {
                this.sourceFileViewer.setSelection(this.sourceFileViewer.getSelection());
            } else if (this.isFileMandatory && this.listener != null) {
                this.listener.setControlComplete(false);
            }
        }
    }

    public void addSelectionChangedTreeListener(ISelectionChangedListener treeListener) {
        this.sourceFileViewer.addSelectionChangedListener(treeListener);
    }

    class ImportAddResourceListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        Vector<IResource> importedFiles = new Vector();

        ImportAddResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta resourceDelta = event.getDelta();
            try {
                if (resourceDelta != null) {
                    resourceDelta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (Exception exception) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 1 && delta.getResource() instanceof IFile) {
                this.importedFiles.add(delta.getResource());
            }
            return true;
        }

        public Collection<IResource> getImportedFiles() {
            return this.importedFiles;
        }

        public IFile getImportedFile() {
            if (!this.importedFiles.isEmpty()) {
                return (IFile)this.importedFiles.firstElement();
            }
            return null;
        }
    }

    public static interface Listener {
        public void setControlComplete(boolean var1);
    }

    private class ModifiedWizardFileSystemResourceImportPage1
    extends WizardFileSystemResourceImportPage1 {
        public ModifiedWizardFileSystemResourceImportPage1(IWorkbench workbench, IStructuredSelection selection) {
            super(workbench, selection);
        }

        protected void enableButtonGroup(boolean enable) {
            super.enableButtonGroup(enable);
            this.selectTypesButton.setEnabled(false);
        }

        protected ITreeContentProvider getFileProvider() {
            return new WorkbenchContentProvider(){

                public Object[] getChildren(Object o) {
                    if (o instanceof FileSystemElement) {
                        FileSystemElement element = (FileSystemElement)o;
                        Object[] result = ((MinimizedFileSystemElement)element).getFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                        List filtered = CollectionUtils.newList();
                        int i = 0;
                        while (i < result.length) {
                            FileSystemElement child = (FileSystemElement)result[i];
                            if (ModifiedWizardFileSystemResourceImportPage1.this.select(element, child)) {
                                filtered.add(child);
                            }
                            ++i;
                        }
                        return filtered.toArray();
                    }
                    return new Object[0];
                }
            };
        }

        protected boolean select(FileSystemElement parent, FileSystemElement child) {
            if (SelectSingleFileView.this.fFilters == null) {
                return true;
            }
            int i = 0;
            while (i < SelectSingleFileView.this.fFilters.size()) {
                ViewerFilter filter = SelectSingleFileView.this.fFilters.get(i);
                if (filter.select((Viewer)SelectSingleFileView.this.sourceFileViewer, (Object)parent, (Object)child)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

