/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.data.structured.StructContentProvider;
import org.eclipse.stardust.modeling.data.structured.StructLabelProvider;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.wizards.ImportFromSchemaWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDTypesSelectionPage
extends WizardPage
implements ISelectionChangedListener {
    private static String[] COLUMNS = new String[]{Structured_Messages.NameColumnLabel, Structured_Messages.TypeColumnLabel};
    private final ImportFromSchemaWizard importFromSchemaWizard;
    private TreeViewer viewer;
    private boolean saveSchema;
    private boolean multiSelection = true;
    private IStructuredSelection selection;
    private Button saveButton;
    private HashSet<XSDSchema> selectedSchemas = new HashSet();
    private boolean hasCreateParserButton;
    protected boolean createParser;

    protected XSDTypesSelectionPage(ImportFromSchemaWizard importFromSchemaWizard, boolean multiSelection, boolean hasCreateParserButton) {
        super("TypesPage");
        this.importFromSchemaWizard = importFromSchemaWizard;
        this.multiSelection = multiSelection;
        this.hasCreateParserButton = hasCreateParserButton;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        if (this.multiSelection) {
            Composite buttonsPanel = FormBuilder.createComposite((Composite)composite, (int)3);
            buttonsPanel.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)2));
            FormBuilder.createButton((Composite)buttonsPanel, (String)Structured_Messages.SelectAllButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XSDTypesSelectionPage.this.selectAll();
                }
            });
            FormBuilder.createButton((Composite)buttonsPanel, (String)Structured_Messages.SelectNoneButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XSDTypesSelectionPage.this.selectNone();
                }
            });
            Label filler = FormBuilder.createLabel((Composite)buttonsPanel, (String)"");
            filler.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        }
        Tree tree = FormBuilder.createTree((Composite)composite, (int)this.getTreeStyle(), (String[])COLUMNS, (int[])new int[]{50, 50}, (int)2);
        ((GridData)tree.getLayoutData()).heightHint = 400;
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new StructContentProvider(true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new StructLabelProvider());
        this.saveButton = FormBuilder.createCheckBox((Composite)composite, (String)Structured_Messages.SaveOriginalSchemaLabel, (int)2);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSDTypesSelectionPage.this.saveSchema = ((Button)e.widget).getSelection();
                XSDTypesSelectionPage.this.checkSelection();
            }
        });
        if (this.hasCreateParserButton) {
            Button createParserButton = FormBuilder.createCheckBox((Composite)composite, (String)Structured_Messages.BUT_CREATE_PR_AND_SER_APP, (int)2);
            createParserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XSDTypesSelectionPage.this.createParser = ((Button)e.widget).getSelection();
                }
            });
        }
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)composite);
    }

    protected void selectNone() {
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void selectAll() {
        List selection = CollectionUtils.newList();
        for (XSDSchema schema : this.importFromSchemaWizard.getExternalSchemaList()) {
            this.viewer.expandToLevel((Object)schema, 1);
            selection.addAll(schema.getElementDeclarations());
            selection.addAll(schema.getTypeDefinitions());
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(selection));
    }

    private int getTreeStyle() {
        return (this.multiSelection ? 2 : 4) | 0x10000 | 0x800;
    }

    public void updateContent() {
        HashSet<XSDSchema> schemas = new HashSet<XSDSchema>();
        for (XSDSchema schema : this.importFromSchemaWizard.getExternalSchemaList()) {
            this.addSchema(schemas, schema);
        }
        this.viewer.setInput(schemas);
    }

    private void addSchema(Set<XSDSchema> schemas, XSDSchema schema) {
        if (!schemas.contains(schema)) {
            schemas.add(schema);
            EList contents = schema.getContents();
            for (XSDSchemaContent item : contents) {
                XSDSchema ref;
                if (!(item instanceof XSDImport) || (ref = ((XSDImport)item).getResolvedSchema()) == null) continue;
                this.addSchema(schemas, ref);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = (IStructuredSelection)event.getSelection();
        this.checkSelection();
    }

    private void checkSelection() {
        boolean pageComplete = false;
        boolean canSave = true;
        String errorMessage = null;
        Set unresolvedRefs = CollectionUtils.newSet();
        this.selectedSchemas.clear();
        if (this.selection != null && !this.selection.isEmpty()) {
            for (Object item : this.selection) {
                if (!(item instanceof XSDTypeDefinition) && !(item instanceof XSDElementDeclaration)) continue;
                XSDNamedComponent namedComponent = (XSDNamedComponent)item;
                XSDSchema schema = namedComponent.getSchema();
                if (namedComponent.getContainer() != schema) continue;
                this.selectedSchemas.add(schema);
            }
            Set visited = CollectionUtils.newSet();
            for (Object item : this.selection) {
                if (!(item instanceof XSDTypeDefinition) && !(item instanceof XSDElementDeclaration)) continue;
                XSDNamedComponent component = (XSDNamedComponent)item;
                XSDSchema target = component.getSchema();
                if (component.getContainer() != target) continue;
                pageComplete = true;
                try {
                    canSave = this.checkReferences(target, unresolvedRefs, visited, (EObject)component) && canSave;
                }
                catch (UnresolvedReferenceException e) {
                    pageComplete = false;
                    errorMessage = String.valueOf(Structured_Messages.ERROR_MSG_UNRESOLVED_RE) + e.getReference() + "\nIs \"" + e.getLocation() + Structured_Messages.ERROR_MSG_IMPORTED;
                }
            }
        }
        if (errorMessage == null) {
            if (this.saveSchema && !canSave) {
                errorMessage = MessageFormat.format(Structured_Messages.ERROR_MSG_SELE_CONTAINS_ELEM_WITH_REF_IN_SCHEMAS_NOT_INCLUDED_IN_SELE, unresolvedRefs);
            } else if (!pageComplete && this.selection != null && !this.selection.isEmpty()) {
                errorMessage = Structured_Messages.ERROR_MSG_SELE_DOINST_CONTAIN_ANY_ROOT_COMPONENTS;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(pageComplete);
    }

    private boolean checkReferences(XSDSchema target, Set<String> unresolvedRefs, Set<EObject> visited, EObject component) throws UnresolvedReferenceException {
        if (component == null || visited.contains(component)) {
            return true;
        }
        visited.add(component);
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration decl = (XSDElementDeclaration)component;
            XSDElementDeclaration resolved = decl.getResolvedElementDeclaration();
            if (resolved != decl) {
                XSDSchema schema = resolved.getSchema();
                if (schema == null) {
                    throw new UnresolvedReferenceException(resolved.getName(), resolved.getTargetNamespace(), 0, 0);
                }
                if (!this.selectedSchemas.contains(schema)) {
                    XSDTypesSelectionPage.checkNamespaceDeclaration(target, schema.getTargetNamespace(), null);
                    unresolvedRefs.add(resolved.getName());
                    return false;
                }
                return this.checkReferences(target, unresolvedRefs, visited, (EObject)resolved);
            }
            return this.checkReferences(target, unresolvedRefs, visited, (EObject)resolved.getTypeDefinition());
        }
        if (component instanceof XSDTypeDefinition) {
            XSDTypeDefinition type = (XSDTypeDefinition)component;
            XSDSchema schema = type.getSchema();
            if (schema == null) {
                throw new UnresolvedReferenceException(type.getName(), type.getTargetNamespace(), 0, 0);
            }
            String targetNamespace = schema.getTargetNamespace();
            String schemaForSchemaNamespace = schema.getSchemaForSchemaNamespace();
            if (!schemaForSchemaNamespace.equals(targetNamespace)) {
                if (!this.selectedSchemas.contains(schema)) {
                    XSDTypesSelectionPage.checkNamespaceDeclaration(target, schema.getTargetNamespace(), null);
                    unresolvedRefs.add(type.getName());
                    return false;
                }
                boolean canSave = true;
                TreeIterator contents = type.eAllContents();
                while (contents.hasNext()) {
                    boolean bl = canSave = this.checkReferences(target, unresolvedRefs, visited, (EObject)contents.next()) && canSave;
                }
                return canSave;
            }
        }
        return true;
    }

    public static void checkNamespaceDeclaration(XSDSchema target, String namespace, String defaultPrefix) {
        Map map;
        if (namespace != null && namespace.length() > 0 && !(map = target.getQNamePrefixToNamespaceMap()).containsValue(namespace)) {
            if (defaultPrefix == null) {
                int ix;
                defaultPrefix = namespace;
                if (defaultPrefix.charAt(defaultPrefix.length() - 1) == '/') {
                    defaultPrefix = defaultPrefix.substring(0, defaultPrefix.length() - 1);
                }
                if ((ix = defaultPrefix.lastIndexOf(47)) >= 0) {
                    defaultPrefix = defaultPrefix.substring(ix + 1);
                }
                defaultPrefix = XSDTypesSelectionPage.shorten(defaultPrefix, '.');
                defaultPrefix = XSDTypesSelectionPage.shorten(defaultPrefix, '?');
                defaultPrefix = XSDTypesSelectionPage.shorten(defaultPrefix, '#');
            }
            String prefix = TypeDeclarationUtils.computePrefix((String)defaultPrefix, map.keySet());
            map.put(prefix, namespace);
        }
    }

    private static String shorten(String namespace, char endCharacter) {
        int ix1 = namespace.indexOf(endCharacter);
        if (ix1 >= 0) {
            return namespace.substring(0, ix1);
        }
        return namespace;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public boolean mustSaveSchema() {
        return this.saveSchema;
    }
}

