/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.wizards.ImportFromSchemaWizard;
import org.eclipse.stardust.modeling.data.structured.wizards.SelectSingleFolderView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class XSDURLPage
extends WizardPage
implements SelectionListener {
    private final ImportFromSchemaWizard importFromSchemaWizard;
    private Text urlField;
    private String saveString;
    protected boolean saveToWorkspace;
    private SelectSingleFolderView folderView;
    boolean schemaLoaded = false;
    protected boolean folderSelected;
    private String location;

    public XSDURLPage(ImportFromSchemaWizard importFromSchemaWizard, String location) {
        super("URLPage");
        this.importFromSchemaWizard = importFromSchemaWizard;
        this.setPageComplete(false);
        this.location = location;
    }

    public void setVisible(boolean visible) {
        this.folderView.setVisibleHelper(visible && this.saveToWorkspace);
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite client = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)client, (String)Structured_Messages.URLLabel, (int)2);
        this.saveString = "http://";
        this.urlField = FormBuilder.createText((Composite)client);
        if (this.location == null) {
            this.urlField.setText(this.saveString);
        } else {
            this.urlField.setText(this.location);
            this.urlField.setEditable(false);
        }
        FormBuilder.createButton((Composite)client, (String)Structured_Messages.LoadButtonLabel, (SelectionListener)this);
        final Button cb = FormBuilder.createCheckBox((Composite)client, (String)Structured_Messages.SaveResourceLabel, (int)2);
        this.folderView = new SelectSingleFolderView(null, true, ModelUtils.getProjectFromEObject((EObject)this.importFromSchemaWizard.getTypeDeclarations()));
        SelectSingleFolderView.Listener listener = new SelectSingleFolderView.Listener(){

            @Override
            public void setControlComplete(boolean isComplete) {
                XSDURLPage.this.folderSelected = isComplete;
                XSDURLPage.this.checkPageComplete();
            }
        };
        this.folderView.setListener(listener);
        Composite control = this.folderView.createControl(client);
        control.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData((int)2));
        control.setVisible(false);
        if (this.location != null) {
            cb.setSelection(true);
            cb.setEnabled(false);
            this.setMustSave(true);
        }
        cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSDURLPage.this.setMustSave(cb.getSelection());
            }
        });
        this.setControl((Control)client);
    }

    public String getURL() {
        return this.urlField.getText();
    }

    private boolean openExternalSchema(IProgressMonitor monitor) {
        String text = this.urlField.getText();
        if (text.equals("")) {
            this.setErrorMessage(Structured_Messages.SpecifyURLMessage);
            return false;
        }
        if (this.location == null && !text.startsWith("http://")) {
            this.setErrorMessage(String.valueOf(Structured_Messages.BadURLPrefixMessage) + "http://");
            return false;
        }
        if (this.location == null) {
            try {
                String host = new URL(text).getHost();
                if (host == null || host.trim().length() == 0) {
                    this.setErrorMessage(Structured_Messages.NoHost);
                    return false;
                }
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        }
        this.setErrorMessage(null);
        String errorMessage = this.importFromSchemaWizard.doLoadExternalModel(monitor, text, text);
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", 6);
                XSDURLPage.this.schemaLoaded = XSDURLPage.this.openExternalSchema(monitor);
                monitor.done();
            }
        };
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            this.importFromSchemaWizard.getContainer().run(false, true, this.getRunnable());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.checkPageComplete();
    }

    private void checkPageComplete() {
        this.setPageComplete(this.schemaLoaded && (!this.saveToWorkspace || this.folderSelected));
    }

    public IFolder getSaveFolder() {
        return this.folderView.getFolder();
    }

    public String getClasspathResourceName(IFile file) {
        return this.folderView.getClasspathResourceName(file);
    }

    private void setMustSave(boolean mustSave) {
        this.saveToWorkspace = mustSave;
        this.folderView.setVisibleHelper(this.saveToWorkspace);
        this.checkPageComplete();
    }
}

