/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.debug.DebugPlugin;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.launching.LaunchConfigUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        ProcessDefinitionType type;
        IAdaptable adaptable;
        IModelElement element;
        Object object;
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1 && (object = sel.getFirstElement()) instanceof IAdaptable && (element = (IModelElement)(adaptable = (IAdaptable)object).getAdapter(IModelElement.class)) != null && (type = ModelUtils.findContainingProcess((EObject)element)) != null) {
            this.launch(type, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor instanceof WorkflowModelEditor) {
            WorkflowModelEditor wfmEditor = (WorkflowModelEditor)editor;
            DiagramType diagram = wfmEditor.getActiveDiagram();
            if (diagram != null) {
                this.launch(diagram, mode);
            }
        } else if (editor instanceof DiagramEditorPage) {
            DiagramEditorPage page = (DiagramEditorPage)editor;
            this.launch(page.getDiagram(), mode);
        }
    }

    protected void launch(DiagramType diagram, String mode) {
        EObject container = diagram.eContainer();
        if (container instanceof ProcessDefinitionType) {
            this.launch((ProcessDefinitionType)container, mode);
        }
    }

    protected void launch(ProcessDefinitionType type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, this.getConfigurationType());
        if (config != null) {
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                LaunchConfigUtils.setDependencies(wc, this.getDependencies(type));
                DebugUITools.launch((ILaunchConfiguration)wc, (String)mode);
            }
            catch (CoreException e) {
                org.eclipse.debug.core.DebugPlugin.log((Throwable)e);
            }
        }
    }

    private List<String> getDependencies(ProcessDefinitionType process) {
        List deps = CollectionUtils.newList();
        ModelType model = ModelUtils.findContainingModel((EObject)process);
        if (model != null) {
            Set visited = CollectionUtils.newSet();
            this.collectDependencies(visited, model, deps);
        }
        return deps.isEmpty() ? null : deps;
    }

    private void collectDependencies(Set<ModelType> visited, ModelType model, List<String> deps) {
        visited.add(model);
        ExternalPackages externals = model.getExternalPackages();
        if (externals != null) {
            for (ExternalPackage pack : externals.getExternalPackage()) {
                ModelType externalModel = ModelUtils.getExternalModel((ExternalPackage)pack);
                if (externalModel == null || visited.contains(externalModel)) continue;
                String location = ModelUtils.getLocation((ModelType)externalModel);
                if (location != null) {
                    deps.add(location);
                }
                this.collectDependencies(visited, externalModel, deps);
            }
        }
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = org.eclipse.debug.core.DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.stardust.modeling.debug.launchConfigurationType");
    }

    protected ILaunchConfiguration findLaunchConfiguration(ProcessDefinitionType type, ILaunchConfigurationType configType) {
        String projectName = null;
        String modelFilePath = null;
        Resource eResource = type.eResource();
        if (eResource != null) {
            URI eUri = eResource.getURI();
            URI projectUri = eUri.trimSegments(eUri.segmentCount() - 2);
            URI modelUri = eUri.deresolve(projectUri);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eUri.segment(1));
            IProject project = null;
            if (resource instanceof IProject) {
                project = (IProject)resource;
            } else if (resource != null) {
                project = resource.getProject();
            }
            if (project != null) {
                projectName = project.getName();
                modelFilePath = modelUri.toString();
                if (modelFilePath.startsWith(String.valueOf(projectName) + "/")) {
                    modelFilePath = modelFilePath.substring(projectName.length() + 1);
                }
            }
        }
        if (modelFilePath == null || projectName == null) {
            return null;
        }
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = org.eclipse.debug.core.DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (projectName.equals(LaunchConfigUtils.getProjectName(config)) && modelFilePath.equals(LaunchConfigUtils.getModelFileName(config)) && type.getId().equals(LaunchConfigUtils.getProcessDefinitionId(config))) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            org.eclipse.debug.core.DebugPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type, modelFilePath, projectName);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(ProcessDefinitionType type, String modelFilePath, String projectName) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            String prefix = type.getId();
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(prefix));
            LaunchConfigUtils.setProjectName(wc, projectName);
            LaunchConfigUtils.setModelFileName(wc, modelFilePath);
            LaunchConfigUtils.setProcessDefinitionId(wc, type.getId());
            LaunchConfigUtils.setProgramArguments(wc, projectName, modelFilePath, type.getId());
            LaunchConfigUtils.setDefaultAttributes(wc);
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportError(exception);
        }
        return config;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Internal_Debugger_Messages.getString("Launching_DialogTitle"));
        dialog.setMessage(Internal_Debugger_Messages.getString("Launching_DialogMessage"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected void reportError(CoreException exception) {
        MessageDialog.openError((Shell)this.getShell(), (String)Internal_Debugger_Messages.getString("Launching_Error"), (String)exception.getStatus().getMessage());
    }

    protected Shell getShell() {
        return DebugPlugin.getActiveWorkbenchShell();
    }

    protected ILaunchManager getLaunchManager() {
        return org.eclipse.debug.core.DebugPlugin.getDefault().getLaunchManager();
    }
}

