/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30.entity;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class EntityBean30Validator
implements IModelElementValidator,
IBridgeObjectProvider {
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        IType type = null;
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_NoClass, (Object)"carnot:engine:className"));
        } else {
            type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)"carnot:engine:className"));
            }
        }
        String jndiPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:jndiPath");
        if (jndiPath == null || StringUtils.isEmpty((String)jndiPath.trim())) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_NoJNDI, (Object)"carnot:engine:jndiPath"));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    public BridgeObject getBridgeObject(ITypedElement accessPoint, String accessPath, DirectionType direction) throws ValidationException {
        BridgeObject javaBridge = JavaDataTypeUtils.getBridgeObject((ITypedElement)accessPoint, (String)accessPath, (DirectionType)direction);
        return new EntityBeanBridgeObject(javaBridge.getEndClass(), direction);
    }

    private class EntityBeanBridgeObject
    extends BridgeObject {
        public EntityBeanBridgeObject(IType type, DirectionType direction) {
            super(type, direction);
        }

        public boolean acceptAssignmentFrom(BridgeObject rhs) {
            if (this.getDirection() == DirectionType.OUT_LITERAL) {
                return false;
            }
            if (rhs.getDirection() == DirectionType.IN_LITERAL) {
                return false;
            }
            return TypeFinder.isAssignable((IType)this.getEndClass(), (IType)rhs.getEndClass()) || TypeFinder.isAssignable((IType)rhs.getEndClass(), (IType)JavaDataTypeUtils.getTypeFromCurrentProject((String)EJBObject.class.getName())) || TypeFinder.isAssignable((IType)rhs.getEndClass(), (IType)JavaDataTypeUtils.getTypeFromCurrentProject((String)EJBLocalObject.class.getName())) || TypeFinder.isAssignable((IType)rhs.getEndClass(), (IType)JavaDataTypeUtils.getTypeFromCurrentProject((String)Handle.class.getName()));
        }
    }
}

