/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript.editor.controller;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.CodeCompletionHelper;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;

public class JavaScriptEditorController {
    protected String masterDocument;
    protected String fieldsDocument = "//Fields\n";
    protected String expressionDocument = "//Expressions\n";
    protected String statementsDocument = "//Statements\n";
    protected Region fieldsRegion;
    protected Region statementsRegion;
    protected JSCompilationUnitEditor.RegionWithLineOffset expressionRegion;
    private String jScript;

    public JavaScriptEditorController() {
        CodeCompletionHelper.getInstance().getTypeMap().clear();
    }

    public void intializeModel(ModelType model) {
        this.jScript = "function ippInitialize(e) {return null}\n";
        this.jScript = String.valueOf(this.jScript) + "function ippImport(e) {return null}\n";
        EList modelDatas = model.getData();
        int i = 0;
        while (i < modelDatas.size()) {
            DataType data = (DataType)modelDatas.get(i);
            this.jScript = String.valueOf(this.jScript) + "var " + data.getId() + " = ippInitialize(\"" + data.getId() + "\");\n";
            ++i;
        }
        this.jScript = String.valueOf(this.jScript) + "var " + "activityInstance" + " = ippInitialize(\"" + "activityInstance" + "\");\n";
        this.fieldsDocument = "//Fields\n" + this.jScript;
    }

    public String getJScript() {
        return this.jScript;
    }

    public void recalculateRegions(IDocument document) {
        int lines = document.getNumberOfLines();
        int el = 0;
        int eo = 0;
        int sl = 0;
        int so = 0;
        int fl = 0;
        int fo = 0;
        int i = 0;
        while (i < lines - 1) {
            try {
                IRegion region = document.getLineInformation(i);
                String content = document.get(region.getOffset(), document.getLineLength(i));
                if (content.startsWith("//Fields")) {
                    fo = document.getLineOffset(i + 1);
                }
                if (content.startsWith("//Statements")) {
                    fl = document.getLineOffset(i - 1) + document.getLineLength(i - 1) - fo;
                    so = document.getLineOffset(i + 1);
                    this.fieldsRegion = new Region(fo, fl);
                    document.get(eo, el);
                }
                if (content.startsWith("//Expression")) {
                    sl = document.getLineOffset(i - 1) + document.getLineLength(i - 1) - so;
                    eo = document.getLineOffset(i + 1);
                    el = document.getLineOffset(lines - 1) + document.getLineLength(lines - 1) - eo;
                    this.statementsRegion = new Region(so, sl);
                    this.expressionRegion = new JSCompilationUnitEditor.RegionWithLineOffset(eo, el);
                    this.expressionRegion.setLineOffset(i + 1);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
    }

    public String getMasterDocument() {
        this.masterDocument = String.valueOf(this.fieldsDocument) + this.statementsDocument + this.expressionDocument;
        return this.masterDocument;
    }

    public void setMasterDocument(String masterDocument) {
        this.masterDocument = masterDocument;
    }

    public Region getFieldsRegion() {
        return this.fieldsRegion;
    }

    public void setFieldsRegion(Region fieldsRegion) {
        this.fieldsRegion = fieldsRegion;
    }

    public Region getStatementsRegion() {
        return this.statementsRegion;
    }

    public void setStatementsRegion(Region statementsRegion) {
        this.statementsRegion = statementsRegion;
    }

    public JSCompilationUnitEditor.RegionWithLineOffset getExpressionRegion() {
        return this.expressionRegion;
    }

    public void setExpressionRegion(JSCompilationUnitEditor.RegionWithLineOffset expressionRegion) {
        this.expressionRegion = expressionRegion;
    }
}

