/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript;

import java.util.Map;
import org.eclipse.stardust.modeling.javascript.JSFieldReference;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class JSCompletionOnMemberAccess
extends CompletionOnMemberAccess {
    private Expression arrayReceiverReceive;
    private boolean isArray;
    private Map arrayMap;

    public JSCompletionOnMemberAccess(char[] source, long pos, boolean isInsideAnnotation) {
        super(source, pos, isInsideAnnotation);
    }

    public TypeBinding resolveType(BlockScope scope, boolean define, TypeBinding useType) {
        return this.resolveType(scope);
    }

    public TypeBinding resolveType(BlockScope scope) {
        String key = this.receiver.toString();
        key = key.replaceAll("\\[[^\\]]*\\]|\\..*/", "");
        key = key.substring(key.indexOf(46) + 1, key.length());
        key = key.replace(".", "/");
        key = key.replace("(", "");
        key = key.replace(")", "");
        Object value = this.arrayMap.get(key);
        if (this.receiver instanceof ArrayReference) {
            ArrayReference arref = (ArrayReference)this.receiver;
            this.receiver = arref.receiver;
        } else if (value != null && value.toString().equalsIgnoreCase("true")) {
            CompilationUnitScope superScope = (CompilationUnitScope)this.getRootScope((Scope)scope);
            this.receiverType = superScope.getJavaLangArray();
        }
        if (this.receiverType == null) {
            if (this.receiver instanceof FieldReference && !(this.receiver instanceof JSFieldReference)) {
                this.receiver = this.buildFieldReference(this.receiver);
            }
            this.receiverType = this.receiver.resolveType(scope);
        }
        if (this.receiverType == null && this.receiver instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)this.receiver;
            if (messageSend.receiver instanceof ThisReference) {
                Expression[] arguments = messageSend.arguments;
                int length = arguments == null ? 0 : arguments.length;
                TypeBinding[] argBindings = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    argBindings[i] = arguments[i].resolvedType;
                    if (argBindings[i] == null || !argBindings[i].isValidBinding()) {
                        throw new CompletionNodeFound();
                    }
                    ++i;
                }
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(messageSend.selector, argBindings, 1);
                throw new CompletionNodeFound((ASTNode)this, (Binding)problemMethodBinding, (Scope)scope);
            }
        }
        if (this.receiverType == null || this.receiverType.isBaseType()) {
            throw new CompletionNodeFound();
        }
        throw new CompletionNodeFound((ASTNode)this, (Binding)this.receiverType, (Scope)scope);
    }

    public void resolve(BlockScope scope) {
        super.resolve(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        if (this.receiver instanceof ArrayReference) {
            return this.arrayReceiverReceive.resolveType(scope);
        }
        return super.resolveType(scope);
    }

    public void setArrayReceiverReceiver(Expression areceiver) {
        this.arrayReceiverReceive = areceiver;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public Map getArrayMap() {
        return this.arrayMap;
    }

    public void setArrayMap(Map arrayMap) {
        this.arrayMap = arrayMap;
    }

    private Scope getRootScope(Scope scope) {
        if (scope.parent != null) {
            return this.getRootScope(scope.parent);
        }
        return scope;
    }

    private Expression buildFieldReference(Expression expression) {
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            JSFieldReference fr = new JSFieldReference(fieldReference.token, fieldReference.nameSourcePosition);
            fr.binding = fieldReference.binding;
            fr.bits = fieldReference.bits;
            fr.constant = fieldReference.constant;
            fr.nameSourcePosition = fieldReference.nameSourcePosition;
            fr.receiver = fieldReference.receiver;
            fr.receiverType = fieldReference.receiverType;
            fr.resolvedType = fieldReference.resolvedType;
            fr.sourceEnd = fieldReference.sourceEnd;
            fr.sourceStart = fieldReference.sourceStart;
            fr.statementEnd = fieldReference.statementEnd;
            fr.token = fieldReference.token;
            fr.setArrayMap(this.arrayMap);
            return fr;
        }
        return null;
    }
}

