/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.model.i18n.I18N_Messages;
import org.eclipse.stardust.modeling.model.i18n.properties.ScopedPropertyModel;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;

public class I18NBundlesValidator
implements IModelElementValidator,
IModelValidator {
    private static final String SEPARATOR = ":";

    public Issue[] validate(IModelElement element) throws ValidationException {
        List issues = null;
        ScopedPropertyModel model = null;
        try {
            model = new ScopedPropertyModel((EObject)element);
            if (model.getPropertyModel().hasLocales()) {
                Set<Object> locales = model.getPropertyModel().getLocales();
                Set<String> properties = model.getProperties();
                if (!properties.isEmpty()) {
                    for (String propertyName : properties) {
                        List missing = null;
                        boolean hasAtLeastOne = false;
                        for (Object locale : locales) {
                            if (StringUtils.isEmpty((String)model.getProperty(locale, propertyName))) {
                                if (missing == null) {
                                    missing = CollectionUtils.newList();
                                }
                                missing.add(Issue.warning((EObject)element, (String)MessageFormat.format(I18N_Messages.I18NBundlesValidator_MISSING_VALUE, propertyName, this.getLocale(locale)), (Object)(String.valueOf(propertyName) + SEPARATOR + locale)));
                                continue;
                            }
                            hasAtLeastOne = true;
                        }
                        if (!hasAtLeastOne || missing == null || missing.isEmpty()) continue;
                        if (issues == null) {
                            issues = CollectionUtils.newList();
                        }
                        issues.addAll(missing);
                        missing.clear();
                    }
                }
            }
            Issue[] issueArray = issues == null ? null : issues.toArray(new Issue[issues.size()]);
            return issueArray;
        }
        finally {
            if (model != null) {
                model.dispose();
            }
        }
    }

    private String getLocale(Object locale) {
        return locale instanceof Locale ? ((Locale)locale).getDisplayName() : String.valueOf(locale);
    }

    public Issue[] validate(ModelType model) throws ValidationException {
        return this.validate((IModelElement)ModelUtils.getIdentifiableModelProxy((EObject)model, ModelType.class));
    }
}

