/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.QualityControlType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.model.i18n.properties.IPropertyModelListener;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertyBundleCommand;
import org.eclipse.stardust.modeling.model.i18n.properties.SortedProperties;

public class PropertyModel {
    public static final String DESCRIPTION = "Description";
    public static final String NAME = "Name";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String CARNOT_MODEL_RESOURCE_BUNDLE = "carnot:model:resourceBundle";
    private Map<Object, IResource> files = CollectionUtils.newMap();
    private Map<Object, SortedProperties> bundles = CollectionUtils.newMap();
    private List<IContainer> sourceFolders;
    private String baseName;
    private String baseNamePrefix;
    private ModelType model = null;
    private List<IPropertyModelListener> listeners = CollectionUtils.newList();
    private List<String> prefixes = CollectionUtils.newList();
    private PropertyBundleCommand command = null;
    private int useCounter = 0;
    private static Map<URI, PropertyModel> models = CollectionUtils.newMap();

    private PropertyModel(ModelType model) {
        this.model = model;
        this.command = new PropertyBundleCommand(model);
        this.collectBundles();
    }

    public static synchronized PropertyModel get(ModelType type) {
        PropertyModel model = models.get(PropertyModel.getIdentifier(type));
        if (model == null) {
            model = new PropertyModel(type);
            models.put(PropertyModel.getIdentifier(type), model);
        }
        ++model.useCounter;
        return model;
    }

    private static URI getIdentifier(ModelType type) {
        return type.eResource().getURI();
    }

    public static synchronized void dispose(PropertyModel model) {
        --model.useCounter;
        if (model.useCounter <= 0) {
            model.files.clear();
            model.bundles.clear();
            model.sourceFolders.clear();
            models.remove(PropertyModel.getIdentifier(model.model));
        }
    }

    public void dispose() {
        PropertyModel.dispose(this);
    }

    private void collectPrefixes() {
        this.prefixes.clear();
        this.prefixes.add(this.computePrefix(null, (EObject)this.model, null, false));
        TreeIterator i = this.model.eAllContents();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            if (!this.isRegistered(object)) continue;
            this.prefixes.add(this.computePrefix(null, object, null, false));
        }
    }

    public boolean hasLocales() {
        return !this.bundles.isEmpty();
    }

    public Set<Object> getLocales() {
        return this.bundles.keySet();
    }

    public void addLocale(Object locale, Properties properties) {
        IContainer sourceFolder = this.sourceFolders.get(0);
        String localeId = locale.toString();
        SortedProperties props = new SortedProperties(this.prefixes);
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        try {
            IContainer folder = this.getCreateFolder(sourceFolder);
            IFile file = folder.getFile(Path.fromOSString((String)(String.valueOf(this.baseNamePrefix) + localeId + PROPERTIES_SUFFIX)));
            if (!file.exists()) {
                if (properties == null) {
                    this.addDefaultKeys(props);
                }
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)CARNOT_MODEL_RESOURCE_BUNDLE, (String)this.baseName);
                this.bundles.put(locale, props);
                this.files.put(locale, (IResource)file);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.command.addLocale(locale);
        this.fireLocalesChanged();
    }

    private void addDefaultKeys(Properties props) {
        this.addDefaultKeys(props, (EObject)this.model);
        TreeIterator i = this.model.eAllContents();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            if (!this.isRegistered(object)) continue;
            this.addDefaultKeys(props, object);
        }
    }

    public boolean isRegistered(EObject object) {
        return object instanceof DataType || object instanceof RoleType || object instanceof OrganizationType || object instanceof ConditionalPerformerType || object instanceof ApplicationType || object instanceof ProcessDefinitionType || object instanceof DiagramType || object instanceof ActivityType || object instanceof TriggerType || object instanceof DataPathType || object instanceof DataMappingType || object instanceof Code || object instanceof EventHandlerType;
    }

    private void addDefaultKeys(Properties props, EObject model) {
        String prefix = this.computePrefix(null, model, null, true);
        if (model instanceof Code) {
            String descriptionKey;
            String nameKey = String.valueOf(prefix) + NAME;
            if (this.shouldAddKey(nameKey)) {
                props.put(nameKey, this.getNameFrom(model));
            }
            if (this.shouldAddKey(descriptionKey = String.valueOf(prefix) + DESCRIPTION)) {
                props.put(descriptionKey, this.getDescriptionFrom(model));
            }
        } else {
            String descriptionKey;
            String nameKey = String.valueOf(prefix) + NAME;
            if (this.shouldAddKey(nameKey)) {
                props.put(nameKey, this.getNameFrom(model));
            }
            if (this.shouldAddKey(descriptionKey = String.valueOf(prefix) + DESCRIPTION)) {
                props.put(descriptionKey, this.getDescriptionFrom(model));
            }
        }
    }

    private boolean shouldAddKey(String key) {
        if (this.hasLocales()) {
            for (SortedProperties props : this.bundles.values()) {
                if (!props.containsKey(key)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Object getDescriptionFrom(EObject model) {
        String description = null;
        if (model instanceof ModelType) {
            description = ModelUtils.getDescriptionText((DescriptionType)((ModelType)model).getDescription());
        } else if (model instanceof IIdentifiableModelElement) {
            description = ModelUtils.getDescriptionText((DescriptionType)((IIdentifiableModelElement)model).getDescription());
        } else if (model instanceof Code) {
            description = ((Code)model).getValue();
        }
        return description == null ? "" : description;
    }

    private Object getNameFrom(EObject model) {
        String name = null;
        if (model instanceof IIdentifiableElement && (name = ((IIdentifiableElement)model).getName()) == null) {
            name = ((IIdentifiableElement)model).getId();
        }
        if (model instanceof DiagramType) {
            name = ((DiagramType)model).getName();
        }
        if (name == null && model instanceof IModelElement) {
            name = String.valueOf(((IModelElement)model).getElementOid());
        } else if (model instanceof Code) {
            name = ((Code)model).getName();
        }
        return name == null ? "" : name;
    }

    public void save() {
        this.collectPrefixes();
        for (Object locale : this.bundles.keySet()) {
            SortedProperties properties = this.bundles.get(locale);
            IFile file = (IFile)this.files.get(locale);
            this.save(locale, properties, file);
        }
    }

    public String getBasename() {
        return this.baseName;
    }

    public void setBasename(String value) {
        AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)CARNOT_MODEL_RESOURCE_BUNDLE, (String)value);
        this.collectBundles();
    }

    public String getProperty(Object locale, String propertyName) {
        if (locale == null || propertyName == null) {
            return null;
        }
        Properties properties = this.bundles.get(locale);
        return (String)properties.get(propertyName);
    }

    public void setProperty(Object locale, String propertyName, String value) {
        Properties properties = this.bundles.get(locale);
        this.command.setProperty(locale, propertyName, value, (String)properties.setProperty(propertyName, value));
    }

    public void deleteProperty(Object locale, String propertyName) {
        Properties properties = this.bundles.get(locale);
        this.command.setProperty(locale, propertyName, null, (String)properties.remove(propertyName));
    }

    public boolean hasSourceFolders() {
        return !this.sourceFolders.isEmpty();
    }

    private IContainer getCreateFolder(IContainer folder) throws CoreException {
        int dot = this.baseName.lastIndexOf(46);
        if (dot > 0) {
            StringTokenizer st = new StringTokenizer(this.baseName.substring(0, dot), ".");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((folder = folder.getFolder(Path.fromOSString((String)token))).exists()) continue;
                ((IFolder)folder).create(true, true, null);
            }
        }
        return folder;
    }

    public String computePrefix(EObject changedElement, EObject element, String useThisId, boolean appendDot) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getQualifierPrefix(element));
        this.appendToPrefix(buffer, changedElement, element, useThisId);
        if (appendDot) {
            buffer.append('.');
        }
        return buffer.toString();
    }

    private String getQualifierPrefix(EObject object) {
        return object instanceof ModelType ? "Model" : (object instanceof DataType ? "Data" : (object instanceof Code ? "QualityAssuranceCode" : (object instanceof RoleType ? "Role" : (object instanceof OrganizationType ? "Organization" : (object instanceof ConditionalPerformerType ? "CondPerformer" : (object instanceof ApplicationType ? "Application" : (object instanceof ProcessDefinitionType ? "Process" : (object instanceof DiagramType ? "Diagram" : (object instanceof ActivityType ? "Activity" : (object instanceof TriggerType ? "Trigger" : (object instanceof DataPathType ? String.valueOf(((DataPathType)object).getDirection().getName()) + "DataPath" : (object instanceof DataMappingType ? String.valueOf(((DataMappingType)object).getDirection().getName()) + "DataMapping" : (object instanceof EventHandlerType ? (object.eContainer() instanceof ProcessDefinitionType ? "ProcessEH" : (object.eContainer() instanceof ActivityType ? "ActivityEH" : null)) : null)))))))))))));
    }

    private void appendToPrefix(StringBuffer buffer, EObject changedElement, EObject element, String useThisId) {
        if (element instanceof ModelType) {
            return;
        }
        if (element instanceof QualityControlType) {
            return;
        }
        this.appendToPrefix(buffer, changedElement, element.eContainer(), useThisId);
        buffer.append('.');
        if (element == changedElement && useThisId != null) {
            buffer.append(useThisId);
        } else if (element instanceof DataMappingType) {
            buffer.append(((DataMappingType)element).getContext());
            buffer.append('.');
            buffer.append(((DataMappingType)element).getId());
        } else if (element instanceof IIdentifiableElement && !StringUtils.isEmpty((String)((IIdentifiableElement)element).getId())) {
            buffer.append(((IIdentifiableElement)element).getId());
        } else if (element instanceof Code) {
            buffer.append(((Code)element).getCode());
        } else if (element instanceof IModelElement) {
            buffer.append(((IModelElement)element).getElementOid());
        } else {
            buffer.append(element.toString());
        }
    }

    private void collectBundles() {
        this.baseName = AttributeUtil.getAttributeValue((IExtensibleElement)this.model, (String)CARNOT_MODEL_RESOURCE_BUNDLE);
        if (this.baseName == null) {
            this.baseName = "ag.carnot." + this.model.getId();
        }
        IProject project = ModelUtils.getProjectFromEObject((EObject)this.model);
        this.sourceFolders = this.collectSourceFolders(JavaCore.create((IProject)project));
        List<IContainer> folders = CollectionUtils.newList((int)this.sourceFolders.size());
        folders.addAll(this.sourceFolders);
        StringTokenizer st = new StringTokenizer(this.baseName, ".");
        String token = st.nextToken();
        while (!folders.isEmpty() && st.hasMoreTokens()) {
            folders = this.filterFolders(folders, token);
            token = st.nextToken();
        }
        while (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        this.baseNamePrefix = String.valueOf(token) + "_";
        this.files.clear();
        this.bundles.clear();
        if (!folders.isEmpty()) {
            this.collectBundles(folders, this.baseNamePrefix);
        }
        this.fireLocalesChanged();
    }

    private void fireLocalesChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            IPropertyModelListener listener = this.listeners.get(i);
            listener.localesChanged();
            ++i;
        }
    }

    private void collectBundles(List<IContainer> folders, String token) {
        try {
            int i = 0;
            while (i < folders.size()) {
                IContainer resource = folders.get(i);
                IResource[] members = resource.members();
                int j = 0;
                while (j < members.length) {
                    String name = members[j].getName();
                    if (members[j] != null && members[j] instanceof IFile && name.startsWith(token) && name.endsWith(PROPERTIES_SUFFIX)) {
                        String locale = name.substring(token.length(), name.length() - PROPERTIES_SUFFIX.length());
                        SortedProperties props = new SortedProperties(this.prefixes);
                        try {
                            props.load(((IFile)members[j]).getContents());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Object loc = this.getLocale(locale);
                        this.bundles.put(loc, props);
                        this.files.put(loc, members[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private Object getLocale(String locale) {
        Locale[] all = Locale.getAvailableLocales();
        int i = 0;
        while (i < all.length) {
            if (all[i].toString().equals(locale)) {
                return all[i];
            }
            ++i;
        }
        return locale;
    }

    private List<IContainer> filterFolders(List<IContainer> folders, String token) {
        List result = CollectionUtils.newList();
        int i = 0;
        while (i < folders.size()) {
            IContainer resource = folders.get(i);
            IResource member = resource.findMember(token);
            if (member != null && member instanceof IContainer) {
                result.add((IContainer)member);
            }
            ++i;
        }
        return result;
    }

    private List<IContainer> collectSourceFolders(IJavaProject javaProject) {
        List sourceFolders = null;
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                sourceFolders = CollectionUtils.newList((int)roots.length);
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        sourceFolders.add((IContainer)roots[i].getResource());
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return sourceFolders == null ? Collections.emptyList() : sourceFolders;
    }

    public void save(Object locale, Properties properties, IFile file) {
        String header = locale instanceof Locale ? ((Locale)locale).getDisplayName() : locale.toString();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            properties.store(baos, header);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            file.setContents((InputStream)bais, true, true, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void addPropertyModelListener(IPropertyModelListener listener) {
        this.listeners.add(listener);
    }

    public void deleteNls(Object nls) {
        IFile file;
        this.bundles.remove(nls);
        if (this.bundles.isEmpty()) {
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)CARNOT_MODEL_RESOURCE_BUNDLE, null);
        }
        if ((file = (IFile)this.files.remove(nls)) != null) {
            try {
                file.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.fireLocalesChanged();
    }

    public Command getCommand() {
        return this.command;
    }

    public void updatePropertiesFor(IIdentifiableElement element, String oldId, String newId) {
        this.updatePropertiesFor((EObject)element, (EObject)element, oldId, newId);
        TreeIterator i = element.eAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            if (!this.isRegistered(eObject)) continue;
            this.updatePropertiesFor((EObject)element, eObject, oldId, newId);
        }
        this.command.addUpdatePropertiesFor(element, oldId, newId);
    }

    private void updatePropertiesFor(EObject changedElement, EObject eObject, String oldId, String newId) {
        String oldPrefix = this.computePrefix(changedElement, eObject, oldId, false);
        String newPrefix = this.computePrefix(changedElement, eObject, newId, false);
        Collection<SortedProperties> values = this.bundles.values();
        for (SortedProperties props : values) {
            List keys2change = CollectionUtils.newList();
            for (Object object : props.keySet()) {
                String key = (String)object;
                int dot = key.lastIndexOf(46);
                if (dot < 0 || !oldPrefix.equals(key.substring(0, dot))) continue;
                keys2change.add(key);
            }
            for (String oldKey : keys2change) {
                String newKey = String.valueOf(newPrefix) + oldKey.substring(oldPrefix.length());
                String value = (String)props.remove(oldKey);
                props.setProperty(newKey, value);
            }
        }
    }

    public Properties getPropertiesFor(Object locale) {
        return this.bundles.get(locale);
    }
}

