/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertyModel;

public class ScopedPropertyModel
extends AdapterImpl {
    private PropertyModel model = null;
    private EObject element = null;
    private Set<String> propertiesSet = CollectionUtils.newSet();
    private String prefix = null;

    public ScopedPropertyModel(EObject element) {
        this.element = element;
        ModelType root = ModelUtils.findContainingModel((EObject)element);
        this.model = PropertyModel.get(root);
        this.prefix = this.model.computePrefix(null, element, null, true);
        this.propertiesSet.clear();
        this.propertiesSet.add("Name");
        if (element instanceof ModelType || element instanceof IIdentifiableModelElement || element instanceof Code) {
            this.propertiesSet.add("Description");
        }
    }

    public void dispose() {
        this.unregister();
        this.model.dispose();
    }

    public Set<String> getProperties() {
        return this.propertiesSet;
    }

    public String getProperty(Object locale, String propertyName) {
        return this.model.getProperty(locale, String.valueOf(this.prefix) + propertyName);
    }

    public void setProperty(Object locale, String propertyName, String value) {
        if (StringUtils.isEmpty((String)value.toString())) {
            this.model.deleteProperty(locale, String.valueOf(this.prefix) + propertyName);
        } else {
            this.model.setProperty(locale, String.valueOf(this.prefix) + propertyName, value.toString());
        }
    }

    public void register() {
        if (this.element != null && !this.element.eAdapters().contains((Object)this)) {
            this.element.eAdapters().add((Object)this);
        }
    }

    void unregister() {
        if (this.element != null) {
            this.element.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification msg) {
        if (msg.getNotifier().equals(this.element) && CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id().equals(msg.getFeature())) {
            this.prefix = this.model.computePrefix(null, this.element, null, true);
            String oldId = msg.getOldStringValue();
            String newId = msg.getNewStringValue();
            this.model.updatePropertiesFor((IIdentifiableElement)this.element, oldId, newId);
        }
    }

    public PropertyModel getPropertyModel() {
        return this.model;
    }
}

