/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.propertypages;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.project.ProjectPlanningAspectPlugin;
import org.eclipse.stardust.modeling.project.Project_Messages;
import org.eclipse.stardust.modeling.project.effort.EffortByKeyParameter;
import org.eclipse.stardust.modeling.project.effort.EffortByQuantityParameter;
import org.eclipse.stardust.modeling.project.effort.EffortCalculator;
import org.eclipse.stardust.modeling.project.effort.EffortEntry;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortKey;
import org.eclipse.stardust.modeling.project.effort.EffortListener;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.EffortParameters;
import org.eclipse.stardust.modeling.project.effort.EffortPerUnit;
import org.eclipse.stardust.modeling.project.propertypages.AbstractProjectPlanningAspectPropertyPage;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ModelProjectPlanningAspectPropertyPage
extends AbstractProjectPlanningAspectPropertyPage {
    private static final char SLASH = '/';
    private static final char GT = '>';
    private static final char LT = '<';
    private static final char EQUALS = '=';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char BLANK = ' ';
    private static final String VALIGN = "valign";
    private static final String TOP = "top";
    private static final String COLSPAN = "colspan";
    private static final String BORDER = "border";
    private static final String RIGHT = "right";
    private static final String ALIGN = "align";
    private static final String B = "b";
    private static final String TABLE = "table";
    private static final String TD = "td";
    private static final String TR = "tr";
    private static final String H1 = "h1";
    private static final String PARAMETER_LABEL = Project_Messages.getString("PropertyPage.ParameterColumnLabel");
    private static final String[] EFFORT_LABELS = new String[]{Project_Messages.getString("PropertyPage.ScopeColumnLabel"), Project_Messages.getString("PropertyPage.ObjectColumnLabel"), Project_Messages.getString("PropertyPage.DriverColumnLabel"), Project_Messages.getString("PropertyPage.ValueColumnLabel")};
    private static final Verifier verifier = VerifierFactory.doubleVerifier;
    private String dragData;
    private TableViewer effortTableViewer;
    private TreeViewer costDriversTreeViewer;
    private String[] columnProperties;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        if (!this.hasError()) {
            this.getEffortParameters().saveToModel();
        }
    }

    public Control createBody(Composite parent) {
        this.setScope(this.getEffortParameters().MODEL_SCOPE);
        if (this.hasError()) {
            Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
            Label label = FormBuilder.createLabel((Composite)composite, (String)this.errorMessage);
            label.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
            return composite;
        }
        TabFolder tabFolder = new TabFolder(parent, 0);
        this.createParametersTab(tabFolder);
        this.createCostDriversTab(tabFolder);
        this.createEffortCalculationTab(tabFolder);
        return tabFolder;
    }

    private void createParametersTab(TabFolder tabFolder) {
        TabItem parametersTabItem = new TabItem(tabFolder, 0);
        parametersTabItem.setText(Project_Messages.getString("PropertyPage.ParametersTabLabel"));
        parametersTabItem.setControl((Control)this.createParameterComposite((Composite)tabFolder));
    }

    private void createEffortCalculationTab(TabFolder tabFolder) {
        Composite composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Project_Messages.getString("PropertyPage.EffortTabLabel"));
        tabItem.setControl((Control)composite);
        FormBuilder.createButton((Composite)composite, (String)Project_Messages.getString("PropertyPage.CalculateEffortButtonLabel"), (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModelProjectPlanningAspectPropertyPage.this.calculateEffort();
            }
        });
        Table effortTable = FormBuilder.createTable((Composite)composite, (int)5, null, null, (int)5);
        effortTable.setHeaderVisible(true);
        String[] columnLabels = new String[EFFORT_LABELS.length + EffortPerUnit.DEFAULT_LABELS.length];
        System.arraycopy(EFFORT_LABELS, 0, columnLabels, 0, EFFORT_LABELS.length);
        System.arraycopy(EffortPerUnit.DEFAULT_LABELS, 0, columnLabels, EFFORT_LABELS.length, EffortPerUnit.DEFAULT_LABELS.length);
        int i = 0;
        while (i < columnLabels.length) {
            this.addTableColumn(effortTable, columnLabels[i], 75);
            ++i;
        }
        this.effortTableViewer = new TableViewer(effortTable);
        this.effortTableViewer.setLabelProvider((IBaseLabelProvider)new EffortLabelProvider());
        this.effortTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.effortTableViewer.addDragSupport(1, new Transfer[]{HTMLTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ModelProjectPlanningAspectPropertyPage.this.dragData;
            }
        });
    }

    private void addTableColumn(Table table, String label, int width) {
        TableColumn column = new TableColumn(table, 16384);
        column.setText(label);
        column.setWidth(width);
    }

    private void createCostDriversTab(TabFolder tabFolder) {
        Composite composite = FormBuilder.createComposite((Composite)tabFolder, (int)1);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Project_Messages.getString("PropertyPage.CostDriversTabLabel"));
        tabItem.setControl((Control)composite);
        Tree tree = FormBuilder.createTree((Composite)composite, (int)67588);
        tree.setHeaderVisible(true);
        this.columnProperties = new String[EffortPerUnit.DEFAULT_LABELS.length + 1];
        this.columnProperties[0] = PARAMETER_LABEL;
        System.arraycopy(EffortPerUnit.DEFAULT_LABELS, 0, this.columnProperties, 1, EffortPerUnit.DEFAULT_LABELS.length);
        this.addTreeColumn(tree, this.columnProperties[0], 300);
        int i = 1;
        while (i < this.columnProperties.length) {
            this.addTreeColumn(tree, this.columnProperties[i], 70);
            ++i;
        }
        this.costDriversTreeViewer = new TreeViewer(tree);
        this.costDriversTreeViewer.setContentProvider((IContentProvider)new EffortParametersContentProvider());
        this.costDriversTreeViewer.setLabelProvider((IBaseLabelProvider)new EffortParametersLabelProvider());
        this.costDriversTreeViewer.setSorter((ViewerSorter)new EffortSorter());
        this.costDriversTreeViewer.setColumnProperties(this.columnProperties);
        this.costDriversTreeViewer.setCellModifier((ICellModifier)new Modifier());
        CellEditor[] editors = new CellEditor[this.columnProperties.length];
        int i2 = 0;
        while (i2 < editors.length) {
            editors[i2] = new TextCellEditor((Composite)this.costDriversTreeViewer.getTree(), 2048);
            ++i2;
        }
        this.costDriversTreeViewer.setCellEditors(editors);
        i2 = 1;
        while (i2 < editors.length) {
            ((Text)editors[i2].getControl()).addVerifyListener((VerifyListener)verifier);
            ++i2;
        }
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener((IMenuListener)new ContextMenuListener(this.costDriversTreeViewer));
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        final EffortParameters parameters = this.getEffortParameters();
        this.costDriversTreeViewer.setInput((Object)parameters);
        final EffortListener listener = new EffortListener(){

            @Override
            public void handleEvent(EffortEvent event) {
                ModelProjectPlanningAspectPropertyPage.this.costDriversTreeViewer.setInput((Object)ModelProjectPlanningAspectPropertyPage.this.getEffortParameters());
            }
        };
        parameters.addListener(listener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parameters.removeListener(listener);
            }
        });
    }

    private void addTreeColumn(Tree tree, String label, int width) {
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(label);
        column.setWidth(width);
    }

    private static String getImagePathFromModelElement(EffortParameterScope scope) {
        if (scope.getScopeClass() == ModelType.class) {
            return "icons/model.gif";
        }
        if (scope.getScopeClass() == ApplicationType.class) {
            return "icons/application.gif";
        }
        if (scope.getScopeClass() == DataType.class) {
            return "icons/data.gif";
        }
        if (scope.getScopeClass() == ProcessDefinitionType.class) {
            return "icons/process.gif";
        }
        if (scope.getScopeClass() == ActivityType.class) {
            return "icons/activity.gif";
        }
        if (scope.getScopeClass() == TransitionType.class) {
            return "icons/transition.gif";
        }
        if (scope.getScopeClass() == ConditionalPerformerType.class) {
            return "icons/conditional.gif";
        }
        if (scope.getScopeClass() == RoleType.class) {
            return "icons/role.gif";
        }
        if (scope.getScopeClass() == OrganizationType.class) {
            return "icons/organization.gif";
        }
        return "icons/missing.gif";
    }

    private void calculateEffort() {
        List items = CollectionUtils.newList();
        EffortCalculator effortCalculator = new EffortCalculator();
        List<EffortEntry> entryList = effortCalculator.calculateEfforts(this.getEffortParameters());
        List rows = CollectionUtils.newList();
        String[] columns = new String[2 + EffortPerUnit.DEFAULT_LABELS.length];
        columns[0] = this.column(this.bold(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.CostDriverExcelColumnLabel")));
        columns[1] = this.column(this.bold(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.ValueExcelColumnLabel")));
        int i = 0;
        while (i < EffortPerUnit.DEFAULT_LABELS.length) {
            columns[2 + i] = this.column(this.bold(EffortPerUnit.DEFAULT_LABELS[i]));
            ++i;
        }
        rows.add(this.row(columns));
        double[] effort = new double[EffortPerUnit.DEFAULT_LABELS.length];
        String previousElement = null;
        int n = 0;
        while (n < entryList.size()) {
            EffortEntry effortEntry = entryList.get(n);
            int i2 = 0;
            while (i2 < effort.length) {
                int n2 = i2;
                effort[n2] = effort[n2] + effortEntry.getEffort()[i2];
                ++i2;
            }
            items.add(effortEntry);
            if (previousElement == null || !previousElement.equals(effortEntry.getName())) {
                int colspan = 2 + EffortPerUnit.DEFAULT_LABELS.length;
                String label2 = effortEntry.getName();
                String label = String.valueOf(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.ExcelEffortLabel")) + ' ' + effortEntry.getSimpleName() + ' ' + this.quote('\"', label2);
                rows.add(this.row(new String[]{this.column(colspan, this.bold(label))}));
                previousElement = effortEntry.getName();
            }
            columns[0] = this.column(effortEntry.getCostDriver());
            columns[1] = this.column(effortEntry.getValueString());
            i2 = 0;
            int len = effortEntry.getEffort().length;
            while (i2 < len) {
                columns[2 + i2] = this.column(effortEntry.getEffort()[i2], false);
                ++i2;
            }
            rows.add(this.row(columns));
            ++n;
        }
        columns = new String[1 + EffortPerUnit.DEFAULT_LABELS.length];
        columns[0] = this.column(2, this.bold(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.TotalEffortExcelLabel")));
        int i3 = 0;
        int len = effort.length;
        while (i3 < len) {
            columns[1 + i3] = this.column(effort[i3], true);
            ++i3;
        }
        rows.add(this.row(columns));
        this.dragData = String.valueOf(this.title(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.ExcelTitle"))) + this.table(1, rows);
        this.effortTableViewer.setInput((Object)items);
    }

    private String quote(char c, String value) {
        return String.valueOf(c) + value + c;
    }

    private String title(String title) {
        return this.element(H1, title);
    }

    private String row(String[] columns) {
        StringBuffer body = new StringBuffer();
        int i = 0;
        while (i < columns.length) {
            body.append(columns[i]);
            ++i;
        }
        return this.element(TR, new String[]{this.attribute(VALIGN, this.quote('\'', TOP))}, body.toString());
    }

    private String column(int span, String body) {
        return this.element(TD, new String[]{this.attribute(COLSPAN, this.quote('\'', Integer.toString(span)))}, body);
    }

    private String table(int border, List<String> rows) {
        StringBuffer buffer = new StringBuffer();
        if (rows != null) {
            int i = 0;
            while (i < rows.size()) {
                buffer.append(rows.get(i));
                ++i;
            }
        }
        return this.element(TABLE, new String[]{this.attribute(BORDER, this.quote('\'', Integer.toString(border)))}, buffer.toString());
    }

    private String column(double value, boolean bold) {
        String string = Double.toString(value);
        return this.element(TD, new String[]{this.attribute(ALIGN, this.quote('\'', RIGHT))}, bold ? this.bold(string) : string);
    }

    private String attribute(String name, String value) {
        return String.valueOf(name) + '=' + value;
    }

    private String column(String body) {
        return this.element(TD, body);
    }

    private String bold(String body) {
        return this.element(B, body);
    }

    private String element(String name, String body) {
        return this.element(name, null, body);
    }

    private String element(String name, String[] attributes, String body) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append(name);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                buffer.append(' ');
                buffer.append(attributes[i]);
                ++i;
            }
        }
        buffer.append('>');
        buffer.append(body);
        buffer.append('<');
        buffer.append('/');
        buffer.append(name);
        buffer.append('>');
        return buffer.toString();
    }

    private static class ContextMenuListener
    implements IMenuListener {
        private List<Action> actions = CollectionUtils.newList();

        public ContextMenuListener(TreeViewer viewer) {
            this.actions.add(new CreateEffortParameterAction(viewer, 0));
            this.actions.add(new CreateEffortParameterAction(viewer, 1));
            this.actions.add(new CreateEffortKeyAction(viewer));
            this.actions.add(new DeleteAction(viewer, 0));
            this.actions.add(new DeleteAction(viewer, 1));
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.removeAll();
            int i = 0;
            int size = this.actions.size();
            while (i < size) {
                IAction action = (IAction)this.actions.get(i);
                if (action.isEnabled()) {
                    manager.add(action);
                }
                ++i;
            }
        }
    }

    private static class CreateEffortKeyAction
    extends Action {
        private TreeViewer treeViewer;

        public CreateEffortKeyAction(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
            this.setText(Project_Messages.getString("PropertyPage.NewKeyActionLabel"));
        }

        public boolean isEnabled() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            return selection.size() == 1 && this.matchesType(selection.getFirstElement());
        }

        private boolean matchesType(Object element) {
            return element instanceof EffortByKeyParameter;
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            Object object = selection.getFirstElement();
            this.createEffortKey((EffortByKeyParameter)object);
        }

        private void createEffortKey(EffortByKeyParameter parameter) {
            String baseName = Project_Messages.getString("PropertyPage.EffortKeyBaseName");
            int start = parameter.keyCount();
            while (parameter.getKey(String.valueOf(baseName) + start) != null) {
                ++start;
            }
            EffortKey key = new EffortKey(parameter, String.valueOf(baseName) + start, 1.0);
            parameter.addKey(key);
            this.treeViewer.refresh((Object)parameter);
        }
    }

    private static class CreateEffortParameterAction
    extends Action {
        private static final int BY_KEY_PARAMETER_TYPE = 0;
        private static final int BY_VALUE_PARAMETER_TYPE = 1;
        private static final String[] LABELS = new String[]{Project_Messages.getString("PropertyPage.NewByKeyParameterActionLabel"), Project_Messages.getString("PropertyPage.NewByQuantityParameterActionLabel")};
        private TreeViewer treeViewer;
        private int type;

        public CreateEffortParameterAction(TreeViewer treeViewer, int type) {
            this.treeViewer = treeViewer;
            this.type = type;
            this.setText(LABELS[type]);
        }

        public boolean isEnabled() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            return selection.size() == 1 && this.matchesType(selection.getFirstElement());
        }

        private boolean matchesType(Object element) {
            return element instanceof EffortParameterScope;
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            Object object = selection.getFirstElement();
            switch (this.type) {
                case 0: {
                    this.createByKeyParameter((EffortParameterScope)object);
                    break;
                }
                case 1: {
                    this.createByValueParameter((EffortParameterScope)object);
                }
            }
        }

        private void createByKeyParameter(EffortParameterScope scope) {
            EffortByKeyParameter parameter = new EffortByKeyParameter(scope, this.createParameterName(Project_Messages.getString("PropertyPage.ByKeyParameterBaseName"), scope), new String[0], new double[0]);
            scope.addParameter(parameter);
            this.treeViewer.refresh((Object)scope);
        }

        private void createByValueParameter(EffortParameterScope scope) {
            EffortByQuantityParameter parameter = new EffortByQuantityParameter(scope, this.createParameterName(Project_Messages.getString("PropertyPage.ByValueParameterBaseName"), scope), 1.0);
            scope.addParameter(parameter);
            this.treeViewer.refresh((Object)scope);
        }

        private String createParameterName(String baseName, EffortParameterScope scope) {
            int start = scope.parameterCount();
            while (scope.hasParameter(String.valueOf(baseName) + start)) {
                ++start;
            }
            return String.valueOf(baseName) + start;
        }
    }

    private static class DeleteAction
    extends Action {
        private static final int EFFORT_PARAMETER_TYPE = 0;
        private static final int EFFORT_KEY_TYPE = 1;
        private static final String[] LABELS = new String[]{Project_Messages.getString("PropertyPage.DeleteParameterActionLabel"), Project_Messages.getString("PropertyPage.DeleteKeyActionLabel")};
        private TreeViewer treeViewer;
        private int type;

        public DeleteAction(TreeViewer treeViewer, int type) {
            this.treeViewer = treeViewer;
            this.type = type;
            this.setText(LABELS[type]);
        }

        public boolean isEnabled() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            return selection.size() == 1 && this.matchesType(selection.getFirstElement());
        }

        private boolean matchesType(Object element) {
            switch (this.type) {
                case 0: {
                    return element instanceof EffortParameter;
                }
                case 1: {
                    return element instanceof EffortKey;
                }
            }
            return false;
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            Object object = selection.getFirstElement();
            switch (this.type) {
                case 0: {
                    this.deleteEffortParameter((EffortParameter)object);
                    break;
                }
                case 1: {
                    this.deleteEffortKey((EffortKey)object);
                }
            }
        }

        private void deleteEffortParameter(EffortParameter parameter) {
            EffortParameterScope scope = parameter.getScope();
            scope.removeParameter(parameter);
            this.treeViewer.refresh((Object)scope);
        }

        private void deleteEffortKey(EffortKey key) {
            EffortByKeyParameter parameter = key.getParameter();
            parameter.removeKey(key);
            this.treeViewer.refresh((Object)parameter);
        }
    }

    private static class EffortLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EffortLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            EffortEntry entry = (EffortEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getSimpleName();
                }
                case 1: {
                    return entry.getName();
                }
                case 2: {
                    return entry.getCostDriver();
                }
                case 3: {
                    return entry.getValueString();
                }
            }
            return verifier.getExternalValue(Double.toString(entry.getEffort()[columnIndex - 4]));
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private static class EffortParametersContentProvider
    implements ITreeContentProvider {
        private EffortParametersContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EffortParameterScope) {
                return this.collectParameters((EffortParameterScope)parentElement);
            }
            if (parentElement instanceof EffortByKeyParameter) {
                return this.collectKeys((EffortByKeyParameter)parentElement);
            }
            return new Object[0];
        }

        private Object[] collectKeys(EffortByKeyParameter parameter) {
            Object[] result = new Object[parameter.keyCount()];
            int i = 0;
            Iterator<String> itr = parameter.getKeyNames();
            while (itr.hasNext()) {
                result[i] = parameter.getKey(itr.next());
                ++i;
            }
            return result;
        }

        private Object[] collectParameters(EffortParameterScope scope) {
            Object[] result = new Object[scope.parameterCount()];
            int i = 0;
            Iterator<String> itr = scope.getParameterNames();
            while (itr.hasNext()) {
                result[i] = scope.getParameter(itr.next());
                ++i;
            }
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof EffortParameterScope) {
                return ((EffortParameterScope)element).getEffortParameters();
            }
            if (element instanceof EffortParameter) {
                return ((EffortParameter)element).getScope();
            }
            if (element instanceof EffortKey) {
                return ((EffortKey)element).getParameter();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof EffortParameterScope || element instanceof EffortByKeyParameter;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EffortParameters) {
                return ((EffortParameters)inputElement).SCOPE_LIST.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class EffortParametersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EffortParametersLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex > 0) {
                return null;
            }
            if (element instanceof EffortParameterScope) {
                return ProjectPlanningAspectPlugin.getDefault().getImage(ModelProjectPlanningAspectPropertyPage.getImagePathFromModelElement((EffortParameterScope)element));
            }
            if (element instanceof EffortParameter) {
                return ProjectPlanningAspectPlugin.getDefault().getImage("icons/parameter.gif");
            }
            if (element instanceof EffortKey) {
                return ProjectPlanningAspectPlugin.getDefault().getImage("icons/key.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof EffortParameterScope) {
                return columnIndex == 0 ? ((EffortParameterScope)element).getDisplayName() : "";
            }
            if (element instanceof EffortParameter) {
                switch (columnIndex) {
                    case 0: {
                        return ((EffortParameter)element).getName();
                    }
                }
                return element instanceof EffortByQuantityParameter ? this.getEffort(((EffortByQuantityParameter)element).getEffortPerUnit(), columnIndex - 1) : "";
            }
            if (element instanceof EffortKey) {
                switch (columnIndex) {
                    case 0: {
                        return ((EffortKey)element).getName();
                    }
                }
                return this.getEffort(((EffortKey)element).getEffortPerUnit(), columnIndex - 1);
            }
            return "";
        }

        private String getEffort(EffortPerUnit effortPerUnit, int index) {
            if (effortPerUnit != null && index < effortPerUnit.elementCount()) {
                return verifier.getExternalValue(Double.toString(effortPerUnit.getEffort(index)));
            }
            return "";
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    public class EffortSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (ModelProjectPlanningAspectPropertyPage.this.getEffortParameters().MODEL_SCOPE.equals(e1)) {
                return -1;
            }
            if (ModelProjectPlanningAspectPropertyPage.this.getEffortParameters().MODEL_SCOPE.equals(e2)) {
                return 1;
            }
            if (!(e1 instanceof EffortParameterScope) || !(e2 instanceof EffortParameterScope)) {
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class Modifier
    implements ICellModifier {
        private Modifier() {
        }

        public boolean canModify(Object element, String property) {
            if (PARAMETER_LABEL.equals(property)) {
                return element instanceof EffortParameter || element instanceof EffortKey;
            }
            if (element instanceof EffortByQuantityParameter || element instanceof EffortKey) {
                int i = 1;
                while (i < ModelProjectPlanningAspectPropertyPage.this.columnProperties.length) {
                    if (property.equals(ModelProjectPlanningAspectPropertyPage.this.columnProperties[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)ModelProjectPlanningAspectPropertyPage.this.costDriversTreeViewer.getLabelProvider();
            int i = 0;
            while (i < ModelProjectPlanningAspectPropertyPage.this.columnProperties.length) {
                if (property.equals(ModelProjectPlanningAspectPropertyPage.this.columnProperties[i])) {
                    return labelProvider.getColumnText(element, i);
                }
                ++i;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TreeItem) {
                element = ((TreeItem)element).getData();
            }
            if (PARAMETER_LABEL.equals(property)) {
                String newName = (String)value;
                if (StringUtils.isEmpty((String)newName)) {
                    return;
                }
                if (element instanceof EffortParameter) {
                    EffortParameter parameter = (EffortParameter)element;
                    parameter.setName(newName);
                } else if (element instanceof EffortKey) {
                    EffortKey key = (EffortKey)element;
                    key.setName(newName);
                }
            } else {
                EffortPerUnit effort = null;
                if (element instanceof EffortByQuantityParameter) {
                    effort = ((EffortByQuantityParameter)element).getEffortPerUnit();
                } else if (element instanceof EffortKey) {
                    effort = ((EffortKey)element).getEffortPerUnit();
                }
                if (effort != null) {
                    try {
                        double newValue = Double.parseDouble(verifier.getInternalValue((String)value));
                        if (newValue < 0.0) {
                            throw new NumberFormatException(Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.NegativeValuesErrorMessage"));
                        }
                        effort.setEffort(property, newValue);
                    }
                    catch (NumberFormatException nfe) {
                        Status status = new Status(4, ProjectPlanningAspectPlugin.getDefault().getBundle().getSymbolicName(), 4, nfe.getMessage(), (Throwable)nfe);
                        ErrorDialog.openError((Shell)ModelProjectPlanningAspectPropertyPage.this.getShell(), (String)Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.ErrorDialogTitle"), (String)Project_Messages.getString("ModelProjectPlanningAspectPropertyPage.ErrorDialogText"), (IStatus)status);
                    }
                }
            }
            ModelProjectPlanningAspectPropertyPage.this.costDriversTreeViewer.update(element, new String[]{property});
        }
    }
}

