/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class DataActionOperator
implements IJdtOperator {
    private String typeId;
    private String[] attributeNames;

    public DataActionOperator(String typeId, String[] attributeNames) {
        this.typeId = typeId;
        this.attributeNames = attributeNames;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList actionTypes = model.getEventActionType();
        int i = 0;
        while (i < actionTypes.size()) {
            EventActionTypeType type = (EventActionTypeType)actionTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList actions = type.getActionInstances();
                int j = 0;
                while (j < actions.size()) {
                    AbstractEventAction action = (AbstractEventAction)actions.get(j);
                    this.processAction(result, model, action, originalMethodName, newMethodName);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String methodName = null;
        if (!(element instanceof IMethod)) {
            return Collections.EMPTY_LIST;
        }
        methodName = ((IMethod)element).getElementName();
        ArrayList result = new ArrayList();
        EList actionTypes = model.getEventActionType();
        int i = 0;
        while (i < actionTypes.size()) {
            EventActionTypeType type = (EventActionTypeType)actionTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList actions = type.getActionInstances();
                int j = 0;
                while (j < actions.size()) {
                    AbstractEventAction action = (AbstractEventAction)actions.get(j);
                    this.queryAction(result, file, model, action, methodName);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    private void queryAction(List result, IFile file, ModelType model, AbstractEventAction action, String methodName) {
        AttributeType attribute;
        String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)this.attributeNames[0]);
        DataType data = (DataType)ModelUtils.findIdentifiableElement((List)model.getData(), (String)dataId);
        if (this.isJavaType(data) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)this.attributeNames[1])) != null) {
            EObjectMatch.addMethodMatch(result, file, attribute, methodName);
        }
    }

    private void processAction(List result, ModelType model, AbstractEventAction action, String originalMethodName, String newMethodName) {
        AttributeType attribute;
        String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)this.attributeNames[0]);
        DataType data = (DataType)ModelUtils.findIdentifiableElement((List)model.getData(), (String)dataId);
        if (this.isJavaType(data) && (attribute = AttributeUtil.getAttribute((IExtensibleElement)action, (String)this.attributeNames[1])) != null) {
            EObjectStringValueSubstituteChange.addMethodSubstitution(result, this.attributeNames[1], (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalMethodName, newMethodName);
        }
    }

    private boolean isJavaType(DataType data) {
        if (data != null) {
            DataTypeType type = data.getType();
            String id = type.getId();
            return "serializable".equals(id) || "entity".equals(id) || "primitive".equals(id) || "hibernate".equals(id);
        }
        return false;
    }
}

