/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.refactoring.changes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.refactoring.CollectSearchCandidatesVisitor;
import org.eclipse.stardust.modeling.refactoring.RefactoringUtils;
import org.eclipse.stardust.modeling.refactoring.WorkflowModelEditorsCollector;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.refactoring.Refactoring_Messages;
import org.eclipse.ui.part.FileEditorInput;

public class ModelChange
extends CompositeChange {
    private WorkflowModelEditor editor;
    private WorkflowModelManager manager;
    private IOException exception;
    private List operators;
    private HashMap containers = new HashMap();
    private EObjectLabelProvider labelProvider;

    public ModelChange(IFile file, Object element, RefactoringArguments arguments) throws CoreException {
        super(file.getFullPath().toString());
        this.manager = new WorkflowModelManager();
        this.labelProvider = new EObjectLabelProvider(null);
        try {
            this.manager.load(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            this.operators = OperatorsRegistry.instance().populate(this.manager.getModel(), element, arguments);
            this.addChanges();
        }
        catch (IOException x) {
            this.exception = x;
        }
    }

    public ModelChange(WorkflowModelEditor editor, Object element, RefactoringArguments arguments) {
        super(((FileEditorInput)editor.getEditorInput()).getFile().getFullPath().toString());
        this.editor = editor;
        this.labelProvider = new EObjectLabelProvider(editor);
        this.operators = OperatorsRegistry.instance().populate(editor.getWorkflowModel(), element, arguments);
        this.addChanges();
    }

    private ModelChange(String name, WorkflowModelManager manager, List operators) {
        super(name);
        this.manager = manager;
        this.labelProvider = new EObjectLabelProvider(null);
        this.operators = operators;
        this.addChanges();
    }

    private ModelChange(WorkflowModelEditor editor, List operators) {
        super(((FileEditorInput)editor.getEditorInput()).getFile().getFullPath().toString());
        this.editor = editor;
        this.labelProvider = new EObjectLabelProvider(editor);
        this.operators = operators;
        this.addChanges();
    }

    private void addChanges() {
        int i = 0;
        while (i < this.operators.size()) {
            Change change = (Change)this.operators.get(i);
            EObject object = (EObject)change.getModifiedElement();
            CompositeChange composite = this.getCompositeFor(object);
            composite.add(change);
            ++i;
        }
    }

    private CompositeChange getCompositeFor(EObject object) {
        EObject parent = object.eContainer();
        if (parent.equals(this.manager == null ? this.editor.getWorkflowModel() : this.manager.getModel())) {
            return this;
        }
        CompositeChange composite = (CompositeChange)this.containers.get(parent);
        if (composite == null) {
            CompositeChange parentComposite = this.getCompositeFor(parent);
            try {
                composite = new CompositeChange(this.labelProvider.getText((Object)parent));
            }
            catch (NullPointerException npe) {
                System.out.println(npe);
            }
            parentComposite.add((Change)composite);
            this.containers.put(parent, composite);
        }
        return composite;
    }

    public String getName() {
        ModelType model;
        StringBuffer sb = new StringBuffer();
        sb.append("Workflow Model:");
        ModelType modelType = model = this.manager == null ? this.editor.getWorkflowModel() : this.manager.getModel();
        if (model != null) {
            sb.append(' ').append(model.getName());
            String version = AttributeUtil.getAttributeValue((IExtensibleElement)model, (String)"carnot:engine:version");
            if (version != null && version.length() > 0) {
                sb.append(" ").append(version);
                if (version.indexOf(46) < 0) {
                    try {
                        Long.parseLong(version);
                        sb.append(".0");
                    }
                    catch (Exception exception) {}
                }
            }
        }
        sb.append(" (").append(super.getName()).append(')');
        return sb.toString();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.exception == null ? new RefactoringStatus() : RefactoringStatus.createErrorStatus((String)this.exception.getMessage());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ArrayList<Change> undoChanges = new ArrayList<Change>(this.operators.size());
        int i = 0;
        while (i < this.operators.size()) {
            undoChanges.add(((Change)this.operators.get(i)).perform(pm));
            ++i;
        }
        if (!undoChanges.isEmpty()) {
            try {
                if (this.manager == null) {
                    this.editor.doSave(pm);
                } else {
                    this.manager.save(URI.createPlatformResourceURI((String)super.getName()));
                }
            }
            catch (IOException x) {
                throw new CoreException((IStatus)new Status(4, "ag.carnot.workflow.editor.jdt.refactoring", 0, String.valueOf(Refactoring_Messages.MSG_UnableToSave) + super.getName(), (Throwable)x));
            }
        }
        return this.manager == null ? new ModelChange(this.editor, undoChanges) : new ModelChange(this.getName(), this.manager, undoChanges);
    }

    public Object getModifiedElement() {
        return URI.createPlatformResourceURI((String)super.getName());
    }

    public boolean isEmpty() {
        return this.operators == null || this.operators.isEmpty();
    }

    public static Change createChange(IProgressMonitor pm, String name, Object element, RefactoringArguments arguments) throws CoreException {
        IProject project = RefactoringUtils.getProject((IJavaElement)element);
        CompositeChange composite = new CompositeChange(name);
        WorkflowModelEditorsCollector omc = new WorkflowModelEditorsCollector();
        CollectSearchCandidatesVisitor candidateCollector = new CollectSearchCandidatesVisitor(project);
        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)candidateCollector);
        List list = candidateCollector.getFiles();
        pm.beginTask(Refactoring_Messages.MSG_ParsingModels, list.size());
        try {
            for (IFile file : list) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                List openedModels = omc.getEditors(file);
                if (openedModels.isEmpty()) {
                    try {
                        ModelChange change = new ModelChange(file, element, arguments);
                        if (!change.isEmpty()) {
                            composite.add((Change)change);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    int j = 0;
                    while (j < openedModels.size()) {
                        WorkflowModelEditor editor = (WorkflowModelEditor)openedModels.get(j);
                        ModelChange change = new ModelChange(editor, element, arguments);
                        if (!change.isEmpty()) {
                            composite.add((Change)change);
                        }
                        ++j;
                    }
                }
                pm.worked(1);
            }
        }
        finally {
            omc.dispose();
            pm.done();
        }
        return composite;
    }
}

