/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.util.IconFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ClosureDisplayDialog
extends Dialog {
    private static final int WIDGET_HEIGHT = 250;
    private static final int WIDGET_WIDTH = 300;
    private List closure;
    private EObject eObject;
    private IconFactory iconFactory;

    private ClosureDisplayDialog(Shell shell, IconFactory iconFactory, EObject eObject, List closure) {
        super(shell);
        this.iconFactory = iconFactory;
        this.eObject = eObject;
        this.closure = closure;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Repository_Messages.TXT_REQUIRED_ELEMENTS);
    }

    private static ArrayList filter(EObject eObject, List elements) {
        ArrayList<EObject> closure = new ArrayList<EObject>();
        int i = 0;
        while (i < elements.size()) {
            EObject element = (EObject)elements.get(i);
            if (element != eObject && !(element instanceof IMetaType)) {
                closure.add(element);
            }
            ++i;
        }
        Collections.sort(closure, new Comparator(){

            public int compare(Object o1, Object o2) {
                EObject e1 = (EObject)o1;
                EObject e2 = (EObject)o2;
                String s1 = String.valueOf(e1.eClass().getName()) + ":" + ImportUtils.getLabel(e1);
                String s2 = String.valueOf(e2.eClass().getName()) + ":" + ImportUtils.getLabel(e2);
                if (e1 instanceof IModelParticipant) {
                    s1 = "participant:" + s1;
                }
                if (e2 instanceof IModelParticipant) {
                    s2 = "participant:" + s2;
                }
                return s1.compareTo(s2);
            }
        });
        return closure;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label label = FormBuilder.createLabel((Composite)composite, (String)"");
        label.setImage(ImportUtils.getImage(this.iconFactory, this.eObject));
        FormBuilder.createLabel((Composite)composite, (String)ImportUtils.getLabel(this.eObject));
        FormBuilder.createLabel((Composite)composite, (String)Repository_Messages.LBL_REQUIRES_THE_ELEMENTS_LISTED_BELOW, (int)2);
        Table table = FormBuilder.createTable((Composite)composite, (int)2048, null, null, (int)2);
        GridData data = (GridData)table.getLayoutData();
        data.heightHint = 250;
        data.widthHint = 300;
        table.setLayoutData((Object)data);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                return ImportUtils.getImage(ClosureDisplayDialog.this.iconFactory, (EObject)element);
            }

            public String getText(Object element) {
                return ImportUtils.getLabel((EObject)element);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        viewer.setInput((Object)this.closure);
        return composite;
    }

    public static boolean acceptClosure(Shell shell, IconFactory iconFactory, EObject eObject, List closure) {
        ArrayList filtered = ClosureDisplayDialog.filter(eObject, closure);
        if (!filtered.isEmpty()) {
            ClosureDisplayDialog dialog = new ClosureDisplayDialog(shell, iconFactory, eObject, filtered);
            return dialog.open() == 0;
        }
        return true;
    }
}

