/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui.dialogs;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeAction;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.IconFactory;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class UsageDisplayDialog
extends Dialog {
    private boolean isReferenced = false;
    private EObject eObject;
    private MergeAction action = MergeAction.REPLACE;
    private IconFactory iconFactory;
    public static MergeAction usage = null;

    public static MergeAction getUsage() {
        return usage;
    }

    public static void setUsage(MergeAction usage) {
        UsageDisplayDialog.usage = usage;
    }

    private UsageDisplayDialog(Shell shell, IconFactory iconFactory, EObject eObject) {
        super(shell);
        this.eObject = eObject;
        this.iconFactory = iconFactory;
        if (AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)eObject), (String)"carnot:connection:uri") != null) {
            this.isReferenced = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Repository_Messages.TXT_CONFLICT);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label label = FormBuilder.createLabel((Composite)composite, (String)"");
        label.setImage(ImportUtils.getImage(this.iconFactory, this.eObject));
        FormBuilder.createLabel((Composite)composite, (String)ImportUtils.getLabel(this.eObject));
        String message = Repository_Messages.LBL_ANOTHER_TYPE_WITH_ID_ALREADY_EXISTS_IN_MODEL;
        message = MessageFormat.format(message, this.getType(this.eObject), MergeUtils.getId((EObject)this.eObject));
        FormBuilder.createLabel((Composite)composite, (String)message, (int)2);
        final Button usageCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Repository_Messages.BUT_USE_OPTION_FOR_ALL_DUPLICATE_ELEMENTS, (int)2);
        usageCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (usageCheckBox.getSelection()) {
                    UsageDisplayDialog.setUsage(UsageDisplayDialog.this.action);
                } else {
                    UsageDisplayDialog.setUsage(null);
                }
            }
        });
        usageCheckBox.setSelection(false);
        Group group = FormBuilder.createGroup((Composite)composite, (String)" Action: ", (int)1, (int)2);
        Button replaceButton = FormBuilder.createRadioButton((Composite)group, (String)Repository_Messages.BUT_REPLACE_EXISTING_ELEMENT_WITH_NEW_ONE);
        replaceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                UsageDisplayDialog.this.action = MergeAction.REPLACE;
                if (usageCheckBox.getSelection()) {
                    UsageDisplayDialog.setUsage(UsageDisplayDialog.this.action);
                }
            }
        });
        Button reuseButton = FormBuilder.createRadioButton((Composite)group, (String)Repository_Messages.BUT_REUSE_ELEMENT_IN_THE_MD);
        reuseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                UsageDisplayDialog.this.action = MergeAction.REUSE;
                if (usageCheckBox.getSelection()) {
                    UsageDisplayDialog.setUsage(UsageDisplayDialog.this.action);
                }
            }
        });
        replaceButton.setSelection(true);
        if (this.isReferenced) {
            reuseButton.setEnabled(false);
        }
        return composite;
    }

    private String getType(EObject eObject) {
        return eObject.eContainingFeature().getName();
    }

    public static MergeAction acceptClosure(Shell shell, IconFactory iconFactory, EObject element, EObject original) {
        IWorkflowModelEditor editor;
        DataType data;
        if (original instanceof IMetaType) {
            return MergeAction.REUSE;
        }
        if (original instanceof DataType && (data = (DataType)original).isPredefined()) {
            return MergeAction.REUSE;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)original);
        if (model != null && (editor = BpmUiActivator.findWorkflowModelEditor((ModelType)model)) != null && editor.requireLock(original)) {
            return MergeAction.REUSE;
        }
        MergeAction usage = UsageDisplayDialog.getUsage();
        if (usage != null) {
            return usage;
        }
        UsageDisplayDialog dialog = new UsageDisplayDialog(shell, iconFactory, element);
        int result = dialog.open();
        if (result == 0) {
            return dialog.action;
        }
        return null;
    }
}

