/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ExtendedImageView
extends ImageView {
    private Image theImage;
    private URL url;

    public ExtendedImageView(ITemplate template, Element elem) {
        super(elem);
        String fullPath = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        String imageLocation = fullPath.substring(fullPath.indexOf("/"), fullPath.length());
        this.url = template.getParentFactory().getClass().getResource(imageLocation);
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)this.url);
        ImageData imageData = image.getImageData();
        this.theImage = this.convertToAWT(imageData);
    }

    @Override
    public Image getImage() {
        return this.theImage;
    }

    @Override
    public URL getImageURL() {
        return this.url;
    }

    private BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

