/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.debugger;

import com.infinity.bpm.thirdparty.org.mozilla.javascript.Context;
import com.infinity.bpm.thirdparty.org.mozilla.javascript.Scriptable;
import com.infinity.bpm.thirdparty.org.mozilla.javascript.debug.DebugFrame;
import com.infinity.bpm.thirdparty.org.mozilla.javascript.debug.DebuggableScript;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stardust.modeling.transformation.debug.common.BreakpointSelector;
import org.eclipse.stardust.modeling.transformation.debug.common.CommonConstants;
import org.eclipse.stardust.modeling.transformation.debug.common.SteppingManager;
import org.eclipse.stardust.modeling.transformation.debug.common.SteppingMode;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.JsThread;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageBreakpointManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageTransformationLineBreakpoint;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageTransformationMappingBreakpoint;

public class RhinoDebugFrame
implements DebugFrame {
    private static Object syncObject = new Object();
    private Context context;
    private DebuggableScript debuggableScript;
    private Scriptable scope;
    private Scriptable thisObj;
    private int currentLine = 0;
    private JsDebugTarget debugTarget;

    RhinoDebugFrame(Context context, DebuggableScript debuggableScript, JsDebugTarget debugTarget) {
        this.context = context;
        this.debuggableScript = debuggableScript;
        this.debugTarget = debugTarget;
    }

    public Context getContext() {
        return this.context;
    }

    public DebuggableScript getDebuggableScript() {
        return this.debuggableScript;
    }

    public JsDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public void onDebuggerStatement(Context ctx) {
    }

    public void onEnter(Context context, Scriptable scope, Scriptable thisObj, Object[] aobj) {
        if (this.debugTarget.getSteppingManager().requestedTermination()) {
            return;
        }
        this.scope = scope;
        this.thisObj = thisObj;
        try {
            SteppingManager steppingManager = this.debugTarget.getSteppingManager();
            this.debugTarget.addDebugFrame(this);
            IThread[] threads = this.debugTarget.getThreads();
            if (threads.length > 0 && ((JsThread)threads[0]).getDebugFrames().size() == 1 && this.existsEnabledBreakpoint(BreakpointSelector.MAPPING)) {
                steppingManager.setMode(SteppingMode.STEP_INTO);
            }
            steppingManager.recordEnter();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public void onExit(Context context, boolean flag, Object obj) {
        if (this.debugTarget.getSteppingManager().requestedTermination()) {
            return;
        }
        try {
            this.debugTarget.removeDebugFrame(this);
            this.debugTarget.getSteppingManager().recordExit();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public void onLineChange(Context context, int lineNumber) {
        if (this.debugTarget.getSteppingManager().requestedTermination()) {
            return;
        }
        try {
            this.currentLine = lineNumber;
            if (this.existsEnabledBreakpoint(BreakpointSelector.LINE)) {
                this.debugTarget.notifyChangeInDebugFrame(this);
                this.suspend(16);
            } else if (this.debugTarget.getSteppingManager().canSuspend()) {
                this.debugTarget.notifyChangeInDebugFrame(this);
                this.suspend(8);
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public void onExceptionThrown(Context context, Throwable throwable) {
        if (this.debugTarget.getSteppingManager().requestedTermination()) {
            return;
        }
        throwable.printStackTrace();
        this.suspend(32, throwable);
    }

    private boolean existsEnabledBreakpoint(BreakpointSelector selector) {
        MessageBreakpointManager breakpointManager;
        boolean result;
        block6: {
            result = false;
            breakpointManager = this.debugTarget.getBreakpointManager();
            if (breakpointManager.isEnabled()) break block6;
            return false;
        }
        try {
            for (IBreakpoint breakpoint : breakpointManager.getBreakPoints()) {
                if (!breakpoint.isEnabled() || !MessageBreakpointManager.canHandleBreakpoint((IBreakpoint)breakpoint)) continue;
                if (selector == BreakpointSelector.LINE && breakpoint instanceof MessageTransformationLineBreakpoint) {
                    ILineBreakpoint jsBreakpoint = (ILineBreakpoint)breakpoint;
                    if (this.currentLine + 1 != jsBreakpoint.getLineNumber()) continue;
                    result = true;
                } else {
                    if (selector != BreakpointSelector.MAPPING || !(breakpoint instanceof MessageTransformationMappingBreakpoint)) continue;
                    MessageTransformationMappingBreakpoint mtmBreakPoint = (MessageTransformationMappingBreakpoint)breakpoint;
                    if (!this.debugTarget.getFieldPath().equals(mtmBreakPoint.getFieldPath())) continue;
                    result = true;
                }
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void suspend(int detail) {
        this.suspend(detail, CommonConstants.NO_THROWABLE);
    }

    private void suspend(int detail, Throwable throwable) {
        this.debugTarget.getSteppingManager().reset();
        try {
            if (this.debugTarget.hasThreads()) {
                IThread[] threads = this.debugTarget.getThreads();
                JsThread thread = (JsThread)threads[0];
                thread.setSuspendedByThrowable(throwable);
                thread.setSuspended(true);
                thread.fireSuspendEvent(detail);
                this.suspendThreadExecution();
            }
        }
        catch (DebuggerTerminatedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendThreadExecution() throws InterruptedException {
        Object object = syncObject;
        synchronized (object) {
            syncObject.wait();
            if (this.debugTarget.getSteppingManager().requestedTermination()) {
                this.context.setDebugger(null, null);
                throw new DebuggerTerminatedException("Debugger terminated.");
            }
        }
    }

    public void resumeThreadExecution() {
        this.resumeThreadExecution(SteppingMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeThreadExecution(SteppingMode steppingMode) {
        Object object = syncObject;
        synchronized (object) {
            this.debugTarget.getSteppingManager().setMode(steppingMode);
            syncObject.notify();
        }
    }

    private static class DebuggerTerminatedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DebuggerTerminatedException(String message) {
            super(message);
        }
    }
}

