/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation;

import com.infinity.bpm.thirdparty.emf.common.util.ECollections;
import com.infinity.bpm.thirdparty.emf.common.util.EList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.extensions.transformation.model.MappingModelUtil;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.ExternalClass;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.MappingFactory;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.TransformationProperty;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.CodeCompletionHelper;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.core.ui.AccessPathBrowserContentProvider;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.javascript.editor.JavaScriptValidator;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.FieldMappingsComparator;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.IMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.PrimitiveMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.SerializableMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.StructDataMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MultipleAccessPathBrowserContentProvider;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.IProblem;

public class MessageTransformationController {
    private Map<String, FieldMapping> fieldMappings = new HashMap<String, FieldMapping>();
    private Map<String, AccessPointType> fieldPathsToAccessPoints = new HashMap<String, AccessPointType>();
    private List<AccessPointType> availableMessageTypes = new ArrayList<AccessPointType>();
    private String masterDocument;
    private String fieldsDocument = "//Fields\n";
    private String expressionDocument = "//Expressions\n";
    private String statementsDocument = "//Statements\n";
    private JSCompilationUnitEditor.RegionWithLineOffset fieldsRegion;
    private JSCompilationUnitEditor.RegionWithLineOffset statementsRegion;
    private JSCompilationUnitEditor.RegionWithLineOffset expressionRegion;
    private AccessPointType selectedSourceField;
    private AccessPointType selectedTargetField;
    private List<AccessPointType> selectedSourceFields = new ArrayList<AccessPointType>();
    private FieldMapping selectedTargetFieldMapping;
    private String draggedText;
    private List<AccessPointType> sourceMessageTypes;
    private List<AccessPointType> targetMessageTypes;
    private List<AccessPointType> externalClassTypes;
    private List<AccessPointType> externalClassTypesMissing;
    private ModelType modelType = null;
    private MultipleAccessPathBrowserContentProvider sourceAPB;
    private MultipleAccessPathBrowserContentProvider targetAPB;
    private Map<StructAccessPointType, String> xPathMap = new HashMap<StructAccessPointType, String>();
    private AccessPathBrowserContentProvider apc = new AccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL);
    private TransformationProperty trafoProp;
    private boolean ignoreAnnotationChanges = false;
    private IModelElement application;
    private String jScriptProlog;
    private Map<String, IProblem[]> errorCache = new HashMap<String, IProblem[]>();
    private Map<String, String> usedVar = new HashMap<String, String>();
    private JavaScriptValidator javaScriptValidator;
    private IProject project;
    private boolean simpleMode;
    private boolean withSerialiable;
    private List<AccessPointType> invalidAccessPoints = new ArrayList<AccessPointType>();
    private static final Type[] TYPES = new Type[]{Type.Calendar, Type.String, Type.Timestamp, Type.Boolean, Type.Byte, Type.Char, Type.Double, Type.Float, Type.Integer, Type.Long, Type.Short};
    private IJavaScriptProject javaProject;
    private IModelElement modelElement;
    private MessageTransformationUtils mtaUtils;
    private boolean externalReference = false;
    private int arraySelectionDepthSource;
    private int arraySelectionDepthTarget;

    public MessageTransformationUtils getMtaUtils() {
        return this.mtaUtils;
    }

    public int getArraySelectionDepthSource() {
        return this.arraySelectionDepthSource;
    }

    public int getArraySelectionDepthTarget() {
        return this.arraySelectionDepthTarget;
    }

    public Map<String, String> getUsedVar() {
        return this.usedVar;
    }

    public IProject getProject() {
        return this.project;
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public String getNameString() {
        if (this.isSimpleMode()) {
            return Modeling_Messages.NAME_PARAMETER;
        }
        return Modeling_Messages.NAME_MESSAGE;
    }

    public void reset() {
        this.availableMessageTypes.clear();
    }

    public void intializeModel(ModelType model, IModelElement element) {
        this.modelElement = element;
        this.intializeModel(model, null, element);
    }

    public void intializeModel(ModelType model, IModelElementNodeSymbol symbol, IModelElement element) {
        this.mtaUtils = new MessageTransformationUtils(ModelUtils.getProjectFromEObject((EObject)element), element, model);
        String xmlString = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:TransformationProperty");
        if (xmlString != null) {
            this.trafoProp = (TransformationProperty)MappingModelUtil.transformXML2Ecore((String)xmlString);
        }
        CodeCompletionHelper.getInstance().getTypeMap().clear();
        this.application = element;
        this.modelType = model;
        this.availableMessageTypes.clear();
        this.extractMessageTypesFromModelData(model, element);
        this.extractMessagesFromStructuredTypes(model);
        ExternalPackages packages = model.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                ModelType otherModel = ModelUtils.getExternalModel((ExternalPackage)pkg);
                if (otherModel == null) continue;
                this.extractMessagesFromStructuredTypes(otherModel);
            }
        }
        this.sourceMessageTypes = new ArrayList<AccessPointType>();
        this.targetMessageTypes = new ArrayList<AccessPointType>();
        this.externalClassTypes = new ArrayList<AccessPointType>();
        this.externalClassTypesMissing = new ArrayList<AccessPointType>();
        if (this.trafoProp != null) {
            this.extractAccessPoints(element);
            this.extractExternalClassesfromTrafoprop(model, element);
        }
    }

    private void extractAccessPoints(IModelElement element) {
        DataTypeType structuredDataType = ModelUtils.getDataType((IModelElement)element, (String)"struct");
        ArrayList<AccessPointType> toBeRemoved = new ArrayList<AccessPointType>();
        RuntimeException rte = null;
        boolean failed = false;
        this.invalidAccessPoints.clear();
        AccessPointType extractedAP = null;
        int i = 0;
        while (i < this.getAccessPoint(this.application).size()) {
            AccessPointType accessPoint = this.getAccessPoint(this.application).get(i);
            if (this.isPrimitive(accessPoint)) {
                extractedAP = this.mtaUtils.extractPrimitiveAccessPoints(structuredDataType, accessPoint);
            } else if (this.isSerializable(accessPoint)) {
                extractedAP = this.mtaUtils.extractSerializableAccessPoints(structuredDataType, accessPoint);
            } else {
                if (AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType") == null) {
                    toBeRemoved.add(accessPoint);
                }
                try {
                    extractedAP = this.mtaUtils.extractStructAccessPoints(structuredDataType, accessPoint);
                }
                catch (RuntimeException ex) {
                    this.invalidAccessPoints.add(accessPoint);
                    failed = true;
                    rte = ex;
                }
            }
            if (extractedAP != null && extractedAP.getDirection().equals((Object)DirectionType.IN_LITERAL)) {
                this.sourceMessageTypes.add(extractedAP);
            } else if (extractedAP != null) {
                this.targetMessageTypes.add(extractedAP);
            }
            ++i;
        }
        if (failed) {
            throw rte;
        }
        this.removeAccessPoints(toBeRemoved);
    }

    private void extractMessagesFromStructuredTypes(ModelType model) {
        for (TypeDeclarationType typeAdapter : model.getTypeDeclarations().getTypeDeclaration()) {
            if (TypeDeclarationUtils.getType((TypeDeclarationType)typeAdapter) != 2) continue;
            AccessPointType messageType = this.mtaUtils.createStructAccessPoint((EObject)typeAdapter, typeAdapter.getId(), DirectionType.INOUT_LITERAL, false);
            this.availableMessageTypes.add(messageType);
        }
    }

    private void extractMessageTypesFromModelData(ModelType model, IModelElement element) {
        DataTypeType primitiveType = ModelUtils.getDataType((IModelElement)element, (String)"primitive");
        List<Type> primitiveTypes = Arrays.asList(TYPES);
        for (Type type : primitiveTypes) {
            AccessPointType accessPoint = this.mtaUtils.createPrimitiveAccessPoint((IIdentifiableModelElement)primitiveType, type.getName(), DirectionType.IN_LITERAL);
            if (accessPoint == null) continue;
            this.availableMessageTypes.add(accessPoint);
        }
    }

    private void extractExternalClassesfromTrafoprop(ModelType model, IModelElement element) {
        if (this.trafoProp.getExternalClasses() != null) {
            for (ExternalClass externalClass : this.trafoProp.getExternalClasses()) {
                String className = externalClass.getClassName();
                if (className == null) continue;
                String typeName = externalClass.getInstanceName();
                AccessPointType accessPoint = this.mtaUtils.createSerializableAccessPoints(element, className, typeName);
                if (this.mtaUtils.classExists(className)) {
                    accessPoint.setElementOid(1L);
                } else {
                    accessPoint.setElementOid(-99L);
                }
                this.externalClassTypes.add(accessPoint);
            }
        }
    }

    public void removeInvalidAccessPoints() {
        this.removeAccessPoints(this.invalidAccessPoints);
    }

    public void initializeMappings(IModelElement element) {
        if (this.trafoProp != null) {
            for (FieldMapping fm : this.trafoProp.getFieldMappings()) {
                if (fm == null || !this.fieldPathExists(fm.getFieldPath())) continue;
                this.fieldMappings.put(fm.getFieldPath(), fm);
            }
            this.refreshJavaScriptContext();
        }
    }

    private boolean fieldPathExists(String fieldPath) {
        Iterator<AccessPointType> i = this.targetMessageTypes.iterator();
        while (i.hasNext()) {
            String realfieldPath = fieldPath;
            boolean isContained = false;
            AccessPointType messageType = i.next();
            if (messageType instanceof StructAccessPointType) {
                realfieldPath = realfieldPath.substring(realfieldPath.indexOf("/") + 1, realfieldPath.length());
                isContained = ((StructAccessPointType)messageType).getXPathMap().containsXPath(realfieldPath);
                String firstSegment = fieldPath.substring(0, fieldPath.indexOf("/"));
                boolean bl = isContained = isContained && firstSegment.equalsIgnoreCase(messageType.getId());
                if (!isContained) {
                    String lastSegment = realfieldPath.substring(realfieldPath.lastIndexOf("/") + 1);
                    String attributeFieldPath = realfieldPath;
                    if (realfieldPath.lastIndexOf("/") > 0) {
                        attributeFieldPath = attributeFieldPath.substring(0, attributeFieldPath.lastIndexOf("/"));
                        attributeFieldPath = String.valueOf(attributeFieldPath) + "/@" + lastSegment;
                    } else {
                        attributeFieldPath = "@" + attributeFieldPath;
                    }
                    isContained = ((StructAccessPointType)messageType).getXPathMap().containsXPath(attributeFieldPath);
                }
            } else if (this.isSerializable(messageType)) {
                isContained = true;
            } else {
                realfieldPath = realfieldPath.replaceAll("/", "");
                isContained = messageType.getName().equalsIgnoreCase(realfieldPath);
            }
            if (!isContained) continue;
            return true;
        }
        return false;
    }

    public void refreshJavaScriptContext() {
        String className;
        ModelType rModel;
        IdentifiableReference ref;
        String id;
        AttributeType attributeType;
        String typeString;
        AccessPointType messageType;
        CodeCompletionHelper.getInstance().clear();
        this.jScriptProlog = "function ippInitialize(e) {return null;}\n";
        this.jScriptProlog = String.valueOf(this.jScriptProlog) + "function ippImport(e) {return null;}\n";
        for (AccessPointType apt : this.sourceMessageTypes) {
            if (apt instanceof StructAccessPointType) {
                messageType = (StructAccessPointType)apt;
                typeString = this.getStructuredTypeName((StructAccessPointType)messageType);
                attributeType = AttributeUtil.getAttribute((IExtensibleElement)messageType, (String)"carnot:engine:dataType");
                id = "";
                if (attributeType != null && attributeType.getReference() != null && (ref = attributeType.getReference()) != null && (rModel = ModelUtils.findContainingModel((EObject)ref.getIdentifiable())) != null && !rModel.getId().equals(this.modelType.getId())) {
                    id = String.valueOf(rModel.getId()) + "/";
                }
                this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + id + typeString + "\");\n";
                continue;
            }
            messageType = apt;
            if (this.isSerializable(apt)) {
                className = AttributeUtil.getAttributeValue((IExtensibleElement)apt, (String)"carnot:engine:className");
                this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + className + "\");\n";
                continue;
            }
            this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = new " + this.getTypeString(messageType) + "();\n";
            CodeCompletionHelper.getInstance().getTypeMap().put(messageType.getId(), messageType);
        }
        for (AccessPointType apt : this.targetMessageTypes) {
            if (apt instanceof StructAccessPointType) {
                messageType = (StructAccessPointType)apt;
                typeString = this.getStructuredTypeName((StructAccessPointType)messageType);
                attributeType = AttributeUtil.getAttribute((IExtensibleElement)messageType, (String)"carnot:engine:dataType");
                id = "";
                if (attributeType != null && attributeType.getReference() != null && (ref = attributeType.getReference()) != null && (rModel = ModelUtils.findContainingModel((EObject)ref.getIdentifiable())) != null && !rModel.getId().equals(this.modelType.getId())) {
                    id = String.valueOf(rModel.getId()) + "/";
                }
                this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + id + typeString + "\");\n";
                continue;
            }
            messageType = apt;
            if (this.isSerializable(apt)) {
                className = AttributeUtil.getAttributeValue((IExtensibleElement)apt, (String)"carnot:engine:className");
                this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + className + "\");\n";
                continue;
            }
            this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = new " + this.getTypeString(messageType) + "();\n";
            CodeCompletionHelper.getInstance().getTypeMap().put(messageType.getId(), messageType);
        }
        for (AccessPointType apt : this.externalClassTypes) {
            if (apt instanceof StructAccessPointType) {
                messageType = (StructAccessPointType)apt;
                typeString = this.getStructuredTypeName((StructAccessPointType)messageType);
                this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + typeString + "\");\n";
                continue;
            }
            messageType = apt;
            if (!this.isSerializable(apt) || apt.getElementOid() != 1L) continue;
            className = AttributeUtil.getAttributeValue((IExtensibleElement)apt, (String)"carnot:engine:className");
            this.jScriptProlog = String.valueOf(this.jScriptProlog) + "var " + messageType.getId() + " = ippInitialize(\"" + className + "\");\n";
            CodeCompletionHelper.getInstance().getExternalTypeMap().put(messageType.getId(), messageType);
        }
        this.fieldsDocument = "//Fields\n" + this.jScriptProlog;
    }

    public String getStructuredTypeName(StructAccessPointType messageType) {
        TypeDeclarationType declarationType = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)messageType, (String)"carnot:engine:dataType");
        return declarationType.getId();
    }

    public void recalculateRegions(IDocument document) {
        int lines = document.getNumberOfLines();
        int el = 0;
        int eo = 0;
        int sl = 0;
        int so = 0;
        int fl = 0;
        int fo = 0;
        int i = 0;
        while (i < lines - 1) {
            try {
                IRegion region = document.getLineInformation(i);
                String content = document.get(region.getOffset(), document.getLineLength(i));
                if (content.startsWith("//Fields")) {
                    fo = document.getLineOffset(i + 1);
                }
                if (content.startsWith("//Statements")) {
                    fl = document.getLineOffset(i - 1) + document.getLineLength(i - 1) - fo;
                    so = document.getLineOffset(i + 1);
                    this.fieldsRegion = new JSCompilationUnitEditor.RegionWithLineOffset(fo, fl);
                    this.fieldsRegion.setLineOffset(i);
                    document.get(eo, el);
                }
                if (content.startsWith("//Expression")) {
                    sl = document.getLineOffset(i - 1) + document.getLineLength(i - 1) - so;
                    eo = document.getLineOffset(i + 1);
                    el = document.getLineOffset(lines - 1) + document.getLineLength(lines - 1) - eo;
                    this.statementsRegion = new JSCompilationUnitEditor.RegionWithLineOffset(so, sl);
                    this.statementsRegion.setLineOffset(i);
                    this.expressionRegion = new JSCompilationUnitEditor.RegionWithLineOffset(eo, el);
                    this.expressionRegion.setLineOffset(i + 1);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
    }

    public Map<String, FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public List<AccessPointType> getAvailableMessageTypes() {
        return this.availableMessageTypes;
    }

    public String getMasterDocument() {
        this.masterDocument = String.valueOf(this.fieldsDocument) + this.statementsDocument + this.expressionDocument;
        return this.masterDocument;
    }

    public void setMasterDocument(String masterDocument) {
        this.masterDocument = masterDocument;
    }

    public JSCompilationUnitEditor.RegionWithLineOffset getFieldsRegion() {
        return this.fieldsRegion;
    }

    public JSCompilationUnitEditor.RegionWithLineOffset getStatementsRegion() {
        return this.statementsRegion;
    }

    public JSCompilationUnitEditor.RegionWithLineOffset getExpressionRegion() {
        return this.expressionRegion;
    }

    public boolean targetMessageFieldSelected(TreeSelection targetTreeSelection) {
        this.selectedTargetField = (AccessPointType)targetTreeSelection.getFirstElement();
        if (this.selectedTargetField == null) {
            return false;
        }
        String xPath = this.getXPathFor(this.selectedTargetField);
        if (this.selectedTargetField != null && xPath != null) {
            this.selectedTargetFieldMapping = this.fieldMappings.get(xPath);
            if (this.selectedTargetFieldMapping != null) {
                this.expressionDocument = this.selectedTargetFieldMapping.getMappingExpression() != null ? "//Expression\n" + this.selectedTargetFieldMapping.getMappingExpression() : "//Expression\n\n";
                this.statementsDocument = "//Statements\n\n";
                return true;
            }
        }
        return false;
    }

    public void sourceMessageFieldSelected(TreeSelection sourceTreeSelection) {
        this.selectedSourceFields = this.extractSelectedElements(sourceTreeSelection);
        this.selectedSourceField = (AccessPointType)sourceTreeSelection.getFirstElement();
        if (this.selectedSourceField == null) {
            return;
        }
        if (!this.isSimpleMode()) {
            this.arraySelectionDepthSource = this.getArraySelectionDepth(this.selectedSourceField);
            String xPath = this.getXPathFor(this.selectedSourceField);
            if (this.selectedSourceField != null && xPath != null) {
                FieldMapping fm = this.fieldMappings.get(xPath);
                if (fm != null) {
                    String javaPath;
                    this.draggedText = javaPath = this.getMapperByType(this.selectedSourceField).renderGetterCode(false, false, null);
                    this.draggedText = this.draggedText.replaceAll("@", "");
                }
            } else if (this.selectedSourceField != null && this.isRoot(this.selectedSourceField)) {
                this.draggedText = this.selectedSourceField.getName();
                this.draggedText = this.draggedText.replaceAll("@", "");
            }
        }
    }

    private List<AccessPointType> extractSelectedElements(TreeSelection sourceTreeSelection) {
        ArrayList<AccessPointType> result = new ArrayList<AccessPointType>();
        for (AccessPointType messageType : sourceTreeSelection) {
            result.add(messageType);
        }
        return result;
    }

    public String renderXPathString(TreePath treePath) {
        String result = ((StructAccessPointType)treePath.getFirstSegment()).getId();
        int i = 1;
        while (i < treePath.getSegmentCount()) {
            result = String.valueOf(result) + "/" + ((StructAccessPointType)treePath.getSegment(i)).getId();
            ++i;
        }
        return result;
    }

    public AccessPointType getSelectedSourceField() {
        return this.selectedSourceField;
    }

    public AccessPointType getSelectedTargetField() {
        return this.selectedTargetField;
    }

    public FieldMapping getSelectedTargetFieldMapping() {
        return this.selectedTargetFieldMapping;
    }

    public boolean isBasicTargetFieldMapping() {
        return this.selectedTargetFieldMapping == null || !this.selectedTargetFieldMapping.isAdvancedMapping();
    }

    public void setBasicTargetFieldMapping(boolean basic) {
        if (this.selectedTargetFieldMapping != null) {
            this.selectedTargetFieldMapping.setAdvancedMapping(!basic);
        }
    }

    public String getDraggedText() {
        return this.draggedText;
    }

    public void updateExpressions(String text) {
        this.expressionDocument = "//Expression\n" + text;
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField));
        if (fm != null) {
            String expression = text;
            fm.setMappingExpression(expression);
            this.validateMapping(fm, true);
        }
    }

    public void updateStatements(String text) {
        this.statementsDocument = "//Statements\n" + text;
    }

    public void saveFields(IModelElementNodeSymbol symbol, IModelElement element) {
        TransformationProperty property = MappingFactory.eINSTANCE.createTransformationProperty();
        for (FieldMapping fm : this.fieldMappings.values()) {
            if (fm == null || fm.getMappingExpression().equalsIgnoreCase("")) continue;
            property.getFieldMappings().add((Object)fm);
            AccessPointType accessPoint = this.fieldPathsToAccessPoints.get(fm.getFieldPath());
            if (accessPoint == null || !this.isContentMapping(accessPoint)) continue;
            fm.setContentMapping(true);
        }
        ECollections.sort((EList)property.getFieldMappings(), (Comparator)new FieldMappingsComparator());
        if (this.externalClassTypes != null) {
            for (AccessPointType apt : this.externalClassTypes) {
                ExternalClass externalClass = MappingFactory.eINSTANCE.createExternalClass();
                externalClass.setClassName(AttributeUtil.getAttributeValue((IExtensibleElement)apt, (String)"carnot:engine:className"));
                externalClass.setInstanceName(apt.getName());
                property.getExternalClasses().add((Object)externalClass);
            }
        }
        String xmlString = MappingModelUtil.transformEcore2XML((com.infinity.bpm.thirdparty.emf.ecore.EObject)property);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:TransformationProperty", (String)xmlString);
    }

    public void performDropMapping(AccessPointType mapTarget, MappingConfiguration config) {
        IMappingRenderer sourceMapper = this.getMapperByType(this.selectedSourceField);
        IMappingRenderer targetMapper = this.getMapperByType(mapTarget);
        this.arraySelectionDepthSource = this.getArraySelectionDepth(this.selectedSourceField);
        this.arraySelectionDepthTarget = this.getArraySelectionDepth(mapTarget);
        if (this.checkStandardMappingAllowed(mapTarget, this.selectedSourceField)) {
            if (this.selectedSourceFields.size() > 1) {
                this.performMultipleDropMapping(mapTarget, config);
            } else {
                this.performSingleDropMapping(sourceMapper, targetMapper, config);
            }
        } else {
            String sourceType = AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"carnot:engine:dataType");
            String targetType = AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"carnot:engine:dataType");
            if (sourceType == null || targetType == null) {
                sourceType = AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"carnot:engine:className");
                targetType = AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"carnot:engine:className");
            }
            if (sourceType != null && targetType != null && sourceType.equalsIgnoreCase(targetType) && this.sourceAPB.hasChildren(sourceMapper.getType()) && this.targetAPB.hasChildren(targetMapper.getType())) {
                Object[] sourceChildren = this.sourceAPB.getChildren(sourceMapper.getType());
                Object[] targetChildren = this.targetAPB.getChildren(targetMapper.getType());
                int i = 0;
                while (i < targetChildren.length) {
                    AccessPointType sourceChild;
                    AccessPointType targetChild = (AccessPointType)targetChildren[i];
                    this.selectedSourceField = sourceChild = (AccessPointType)sourceChildren[i];
                    sourceMapper = this.getMapperByType(sourceChild);
                    targetMapper = this.getMapperByType(targetChild);
                    this.performSingleDropMapping(sourceMapper, targetMapper, config);
                    ++i;
                }
            }
        }
        this.draggedText = null;
    }

    private boolean checkStandardMappingAllowed(AccessPointType target, AccessPointType source) {
        if (this.isPrimitive(source)) {
            if (this.isPrimitive(target) && this.isEqualOrSimilar(source, target, true)) {
                return true;
            }
            if (this.isRoot(target)) {
                return false;
            }
            return !this.isList(target);
        }
        if (this.isPrimitive(target)) {
            if (this.isPrimitive(source)) {
                return true;
            }
            if (this.isRoot(source)) {
                return false;
            }
            return !this.isList(source);
        }
        if (!this.isRoot(source) && !this.isRoot(target)) {
            return this.isEqualOrSimilar(source, target, true);
        }
        return this.isEqualOrSimilar(source, target, true) && this.isList(target);
    }

    private IMappingRenderer getMapperByType(AccessPointType messageType) {
        if (this.isSerializable(messageType)) {
            return new SerializableMappingRenderer(this, messageType);
        }
        if (this.isStructData(messageType)) {
            return new StructDataMappingRenderer(this, messageType);
        }
        if (this.isPrimitive(messageType)) {
            return new PrimitiveMappingRenderer(this, messageType);
        }
        return null;
    }

    public boolean isPrimitive(AccessPointType apt) {
        if (apt != null && !(apt instanceof StructAccessPointType) && apt.getType() != null && apt.getType().getId() != null && apt.getType().getId().startsWith("prim")) {
            return true;
        }
        return apt != null && apt instanceof StructAccessPointType && apt.getType() != null && apt.getType().getId() != null && apt.getType().getId().startsWith("prim");
    }

    public boolean isSerializable(AccessPointType apt) {
        if (apt.getType() != null) {
            return apt.getType().getId().equalsIgnoreCase("serializable");
        }
        return false;
    }

    public boolean isStructData(AccessPointType apt) {
        return apt != null && apt instanceof StructAccessPointType;
    }

    private void performSingleDropMapping(IMappingRenderer sm, IMappingRenderer tm, MappingConfiguration config) {
        this.usedVar.clear();
        if (this.sourceAPB.hasChildren(sm.getType()) && this.targetAPB.hasChildren(tm.getType())) {
            if (this.isList(tm.getType()) && this.isList(sm.getType())) {
                String mappingCode = sm.renderListMappingCode(sm, tm, "", 0, config);
                FieldMapping fm = this.fieldMappings.get(this.getXPathFor(tm.getType()));
                fm.setMappingExpression(mappingCode);
                fm.setAdvancedMapping(true);
                this.validateMapping(fm, true);
            } else {
                this.mapComplexToComplexMessage(sm, tm, config);
            }
        } else if (this.sourceAPB.hasChildren(this.selectedSourceField)) {
            this.mapComplextToPrimitiveMessage(this.selectedSourceField, tm.getType());
        } else {
            this.mapPrimitiveToPrimitiveMessage(sm, tm, config);
        }
    }

    public boolean isList(AccessPointType messageType) {
        if (messageType instanceof StructAccessPointType) {
            return ((StructAccessPointType)messageType).getXPath().isList();
        }
        return this.isJavaArray(messageType) || this.isJavaList(messageType);
    }

    public boolean isJavaList(AccessPointType messageType) {
        String className;
        return this.isSerializable(messageType) && (className = AttributeUtil.getAttributeValue((IExtensibleElement)messageType, (String)"carnot:engine:className")).startsWith("java.util.List");
    }

    public boolean isJavaArray(AccessPointType messageType) {
        String className;
        return this.isSerializable(messageType) && (className = AttributeUtil.getAttributeValue((IExtensibleElement)messageType, (String)"carnot:engine:className")).endsWith("[]");
    }

    private void performMultipleDropMapping(AccessPointType mapTarget, MappingConfiguration config) {
        IMappingRenderer targetRenderer = this.getMapperByType(mapTarget);
        String mappingCode = this.createFieldAddition(targetRenderer, this.selectedSourceFields);
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(mapTarget));
        mappingCode = mappingCode.replaceAll("@", "");
        fm.setAdvancedMapping(targetRenderer instanceof SerializableMappingRenderer);
        fm.setMappingExpression(mappingCode);
        this.validateMapping(fm, true);
    }

    private void mapPrimitiveToPrimitiveMessage(IMappingRenderer sm, IMappingRenderer tm, MappingConfiguration config) {
        this.usedVar.clear();
        String mappingCode = "";
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(tm.getType()));
        if (!this.isList(sm.getType()) && this.isList(tm.getType())) {
            mappingCode = sm.renderAdditionCode(sm, tm, config);
            fm = this.fieldMappings.get(this.getXPathFor(tm.getType()));
            fm.setMappingExpression(String.valueOf(fm.getMappingExpression()) + "\n" + mappingCode);
            fm.setAdvancedMapping(config != null && config.isOverwrite() || config.isAppend());
            this.validateMapping(fm, true);
        } else {
            if (this.isList(tm.getType())) {
                mappingCode = sm.renderListMappingCode(sm, tm, "", 0, config);
                fm.setAdvancedMapping(true);
            } else {
                String getterCode = sm.renderGetterCode(false, false, config);
                mappingCode = tm.renderSetterCode(getterCode, false, false, config);
                fm.setAdvancedMapping(tm instanceof SerializableMappingRenderer);
                if (tm instanceof StructDataMappingRenderer) {
                    fm.setAdvancedMapping(this.arraySelectionDepthTarget > 0);
                }
            }
            mappingCode = mappingCode.replaceAll("@", "");
            fm.setMappingExpression(mappingCode);
            this.validateMapping(fm, true);
        }
    }

    private void mapComplextToPrimitiveMessage(AccessPointType sourceMessage, AccessPointType targetMessage) {
        String mappingCode = this.createFieldAddition(sourceMessage);
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(targetMessage));
        mappingCode = mappingCode.replaceAll("@", "");
        fm.setMappingExpression(mappingCode);
        this.validateMapping(fm, true);
    }

    private void mapComplexToComplexMessage(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, MappingConfiguration config) {
        if (this.isEqualOrSimilar(sourceMapper.getType(), targetMapper.getType(), true) && !this.isList(sourceMapper.getType()) && this.isList(targetMapper.getType())) {
            String mappingCode = sourceMapper.renderAdditionCode(sourceMapper, targetMapper, config);
            FieldMapping fm = this.fieldMappings.get(this.getXPathFor(targetMapper.getType()));
            fm.setMappingExpression(String.valueOf(fm.getMappingExpression()) + "\n" + mappingCode);
            fm.setAdvancedMapping(config != null && config.isOverwrite() || config.isAppend());
            this.validateMapping(fm, true);
        }
        if (this.isRoot(targetMapper.getType())) {
            targetMapper = this.getMapperByType((AccessPointType)this.targetAPB.getChildren(targetMapper.getType())[0]);
        }
        if (this.isRoot(sourceMapper.getType())) {
            sourceMapper = this.getMapperByType((AccessPointType)this.sourceAPB.getChildren(sourceMapper.getType())[0]);
        }
        Object[] sourceChildren = this.sourceAPB.getChildren(sourceMapper.getType());
        Object[] targetChildren = this.targetAPB.getChildren(targetMapper.getType());
        int i = 0;
        while (i < targetChildren.length) {
            AccessPointType targetChild = (AccessPointType)targetChildren[i];
            int j = 0;
            while (j < sourceChildren.length) {
                AccessPointType sourceChild = (AccessPointType)sourceChildren[j];
                if (this.isList(sourceChild) && this.isList(targetChild)) {
                    String mappingCode = sourceMapper.renderListMappingCode(this.getMapperByType(sourceChild), this.getMapperByType(targetChild), "", 0, config);
                    FieldMapping fm = this.fieldMappings.get(this.getXPathFor(targetChild));
                    fm.setMappingExpression(mappingCode);
                    this.validateMapping(fm, true);
                    mappingCode = mappingCode.replaceAll("@", "");
                } else if (this.sourceAPB.hasChildren(sourceChild)) {
                    this.mapComplexToComplexMessage(this.getMapperByType(sourceChild), this.getMapperByType(targetChild), config);
                } else if (this.isEqualOrSimilar(targetChild, sourceChild, false)) {
                    this.mapPrimitiveToPrimitiveMessage(this.getMapperByType(sourceChild), this.getMapperByType(targetChild), config);
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean isComplexType(AccessPointType messageType) {
        if (messageType instanceof StructAccessPointType) {
            return ((StructAccessPointType)messageType).getXPath().getType() == -1;
        }
        if (this.isSerializable(messageType)) {
            MultipleAccessPathBrowserContentProvider apcp = null;
            apcp = this.isSourceField(messageType) ? this.getSourceAPB() : this.getTargetAPB();
            if (apcp.getChildren(messageType).length > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isEqualOrSimilar(AccessPointType sourceMessage, AccessPointType targetMessage, boolean advanced) {
        IMappingRenderer sr = this.getMapperByType(sourceMessage);
        IMappingRenderer tr = this.getMapperByType(targetMessage);
        if (advanced) {
            if ((sr instanceof PrimitiveMappingRenderer || tr instanceof PrimitiveMappingRenderer) && sr.getTypeString().equals(tr.getTypeString())) {
                return true;
            }
            if (sr.getTypeString().equalsIgnoreCase(tr.getTypeString()) || this.isSpecialCase(sr, tr)) {
                Object[] targetChildren;
                Object[] sourceChildren = this.sourceAPB.getChildren(sourceMessage, true);
                if (sourceChildren.length != (targetChildren = this.targetAPB.getChildren(targetMessage, true)).length) {
                    return false;
                }
                int i = 0;
                while (i < sourceChildren.length) {
                    AccessPointType sourceChild = (AccessPointType)sourceChildren[i];
                    AccessPointType targetChild = (AccessPointType)targetChildren[i];
                    if (!this.isEqualOrSimilar(sourceChild, targetChild, true)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        } else {
            String sourceName;
            String targetName = targetMessage.getId();
            return targetName.equalsIgnoreCase(sourceName = sourceMessage.getId());
        }
        return false;
    }

    private boolean isSpecialCase(IMappingRenderer sr, IMappingRenderer tr) {
        if (sr instanceof SerializableMappingRenderer && tr instanceof SerializableMappingRenderer && tr.getTypeString().endsWith("[]")) {
            String shortTr = tr.getTypeString().replace("[]", "");
            return sr.getTypeString().endsWith(shortTr);
        }
        return false;
    }

    public boolean isIndexingRequired(AccessPointType st, AccessPointType tt) {
        if (this.isList(st) && this.isList(tt)) {
            return false;
        }
        int stSelectionDepth = this.getArraySelectionDepth(st);
        int ttSelectionDepth = this.getArraySelectionDepth(tt);
        return stSelectionDepth > 0 || ttSelectionDepth > 0;
    }

    private String createFieldAddition(AccessPointType messageType) {
        String result = "";
        if (this.sourceAPB.hasChildren(messageType)) {
            Object[] children = this.sourceAPB.getChildren(messageType);
            int j = 0;
            while (j < children.length) {
                StructAccessPointType childType = (StructAccessPointType)children[j];
                result = String.valueOf(result) + this.createFieldAddition((AccessPointType)childType) + " + ";
                ++j;
            }
        } else {
            result = this.getXPathFor(messageType);
        }
        result = result.replaceAll("/", ".");
        if (result.endsWith("+ ")) {
            result = result.substring(0, result.length() - 2);
        }
        return result.trim();
    }

    private String createFieldAddition(IMappingRenderer targetRenderer, List<AccessPointType> messageTypes) {
        String result = "";
        for (AccessPointType messageType : messageTypes) {
            IMappingRenderer renderer = this.getMapperByType(messageType);
            result = String.valueOf(result) + renderer.renderGetterCode(false, false, null) + " + ";
        }
        if ((result = targetRenderer.renderSetterCode(result, false, false, null)).endsWith(" + ")) {
            result = result.substring(0, result.length() - 3);
        }
        if (result.endsWith(" + )")) {
            result = String.valueOf(result.substring(0, result.length() - 4)) + ")";
        }
        return result.trim();
    }

    public AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType apt : this.sourceMessageTypes) {
            if (!apt.getName().equalsIgnoreCase(name)) continue;
            return apt;
        }
        for (AccessPointType apt : this.targetMessageTypes) {
            if (!apt.getName().equalsIgnoreCase(name)) continue;
            return apt;
        }
        return null;
    }

    public boolean isRoot(AccessPointType messageType) {
        if (messageType instanceof StructAccessPointType) {
            StructAccessPointType sapt = (StructAccessPointType)messageType;
            return sapt != null && "".equals(sapt.getXPath().getXPath());
        }
        if (this.isPrimitive(messageType)) {
            return true;
        }
        if (this.isSerializable(messageType)) {
            String rootElement = AttributeUtil.getAttributeValue((IExtensibleElement)messageType, (String)"RootElement");
            return rootElement.equalsIgnoreCase(messageType.getName());
        }
        return false;
    }

    public boolean containsSelectedSourceField(Object targetElement) {
        if (this.selectedSourceField != null) {
            IMappingRenderer sourceRenderer = this.getMapperByType(this.selectedSourceField);
            FieldMapping sm = this.fieldMappings.get(this.getXPathFor(this.selectedSourceField));
            if (sm != null) {
                String javaPath = this.getXPathFor(this.selectedSourceField);
                if (sourceRenderer instanceof SerializableMappingRenderer) {
                    javaPath = sourceRenderer.renderGetterCode(true, true, null);
                }
                javaPath = this.isPrimitive(this.selectedSourceField) ? javaPath.replace("/", "") : javaPath.replace('/', '.');
                AccessPointType keyElement = (AccessPointType)targetElement;
                String key = this.getXPathFor(keyElement);
                FieldMapping tm = this.fieldMappings.get(key);
                if (tm != null && javaPath != null) {
                    String targetMessage = tm.getMappingExpression();
                    if (StringUtils.isEmpty((String)targetMessage)) {
                        return false;
                    }
                    javaPath = javaPath.replaceAll("\n", " ");
                    targetMessage = targetMessage.replaceAll("\n", " ");
                    if (sourceRenderer instanceof SerializableMappingRenderer && targetMessage != null && targetMessage.indexOf(javaPath) > -1) {
                        return true;
                    }
                    String regex = ".*\\b" + javaPath + "\\b.*";
                    if (targetMessage != null && targetMessage.matches(regex)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isContainedInSelectedTargetField(Object sourceElement) {
        AccessPointType sourceMessageType = (AccessPointType)sourceElement;
        IMappingRenderer sourceRenderer = this.getMapperByType(sourceMessageType);
        String javaPath = this.getXPathFor(sourceMessageType);
        if (javaPath != null) {
            FieldMapping tm;
            if (sourceRenderer instanceof SerializableMappingRenderer) {
                javaPath = sourceRenderer.renderGetterCode(true, true, null);
            }
            javaPath = this.isPrimitive(sourceMessageType) ? javaPath.replace("/", "") : javaPath.replace('/', '.');
            if (this.selectedTargetField != null && (tm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField))) != null) {
                String targetMessage = tm.getMappingExpression();
                if (StringUtils.isEmpty((String)targetMessage)) {
                    return false;
                }
                javaPath = javaPath.replaceAll("\n", " ");
                targetMessage = targetMessage.replaceAll("\n", " ");
                if (sourceRenderer instanceof SerializableMappingRenderer && targetMessage != null && targetMessage.indexOf(javaPath) > -1) {
                    return true;
                }
                String regex = ".*\\b" + javaPath + "\\b.*";
                if (targetMessage != null && targetMessage.matches(regex)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void addSourceMessageType(AccessPointType declaringType, String messageName) {
        AccessPointType accessPoint = null;
        if (declaringType instanceof StructAccessPointType) {
            accessPoint = this.mtaUtils.createStructAccessPoint((EObject)declaringType, messageName, DirectionType.IN_LITERAL, true);
        } else if (declaringType.getType() == null || declaringType.getType().getId().equalsIgnoreCase("serializable")) {
            accessPoint = declaringType;
            accessPoint.setName(messageName);
            accessPoint.setId(messageName);
            DataTypeType serializableType = ModelUtils.getDataType((IModelElement)this.application, (String)"serializable");
            accessPoint.setType(serializableType);
            accessPoint.setDirection(DirectionType.IN_LITERAL);
        } else {
            accessPoint = this.mtaUtils.createPrimitiveAccessPoint((IIdentifiableModelElement)declaringType, messageName, DirectionType.IN_LITERAL);
        }
        this.getAccessPoint(this.application).add(accessPoint);
        this.sourceMessageTypes.add(accessPoint);
        this.refreshJavaScriptContext();
    }

    public AccessPointType createExternalClass(AccessPointType declaringType, String messageName, boolean addToContext) {
        AccessPointType accessPoint = null;
        if (declaringType.getType() == null || declaringType.getType().getId().equalsIgnoreCase("serializable")) {
            accessPoint = declaringType;
            accessPoint.setName(messageName);
            accessPoint.setId(messageName);
            DataTypeType serializableType = ModelUtils.getDataType((IModelElement)this.application, (String)"serializable");
            accessPoint.setType(serializableType);
            accessPoint.setDirection(DirectionType.IN_LITERAL);
        }
        if (addToContext) {
            this.externalClassTypes.add(accessPoint);
            this.refreshJavaScriptContext();
        }
        return accessPoint;
    }

    public void addTargetMessageType(AccessPointType declaringType, String messageName) {
        AccessPointType accessPoint = null;
        if (declaringType instanceof StructAccessPointType) {
            accessPoint = this.mtaUtils.createStructAccessPoint((EObject)declaringType, messageName, DirectionType.OUT_LITERAL, true);
        } else if (declaringType.getType() == null || declaringType.getType().getId().equalsIgnoreCase("serializable")) {
            accessPoint = declaringType;
            accessPoint.setName(messageName);
            accessPoint.setId(messageName);
            DataTypeType serializableType = ModelUtils.getDataType((IModelElement)this.application, (String)"serializable");
            accessPoint.setType(serializableType);
            accessPoint.setDirection(DirectionType.OUT_LITERAL);
        } else {
            accessPoint = this.mtaUtils.createPrimitiveAccessPoint((IIdentifiableModelElement)declaringType, messageName, DirectionType.OUT_LITERAL);
        }
        this.getAccessPoint(this.application).add(accessPoint);
        this.targetMessageTypes.add(accessPoint);
        this.refreshJavaScriptContext();
    }

    public List<AccessPointType> getAccessPoint(IModelElement apOwner) {
        if (apOwner instanceof ApplicationType) {
            return ((ApplicationType)apOwner).getAccessPoint();
        }
        if (apOwner instanceof ContextType) {
            return ((ContextType)apOwner).getAccessPoint();
        }
        return new ArrayList<AccessPointType>();
    }

    public List<AccessPointType> getSourceMessageTypes() {
        return this.sourceMessageTypes;
    }

    public List<AccessPointType> getExternalClassTypes() {
        return this.externalClassTypes;
    }

    public List<AccessPointType> getExternalClassTypesMissing() {
        return this.externalClassTypesMissing;
    }

    public List<AccessPointType> getTargetMessageTypes() {
        return this.targetMessageTypes;
    }

    public boolean isDeleteSourceMessageAvailable() {
        return !this.sourceMessageTypes.isEmpty() && this.isRoot(this.selectedSourceField);
    }

    public boolean isDeleteTargetMessageAvailable() {
        return !this.targetMessageTypes.isEmpty() && this.isRoot(this.selectedTargetField);
    }

    public void performSourceMessageRemovement() {
        ArrayList<AccessPointType> newList = new ArrayList<AccessPointType>();
        for (AccessPointType selectedType : this.selectedSourceFields) {
            this.removeMappingsFor(selectedType);
        }
        for (AccessPointType messageType : this.sourceMessageTypes) {
            boolean found = false;
            for (AccessPointType selectedType : this.selectedSourceFields) {
                if (messageType.getId() != selectedType.getId()) continue;
                found = true;
            }
            if (found) continue;
            newList.add(messageType);
        }
        this.sourceMessageTypes = newList;
        Iterator<AccessPointType> i = this.selectedSourceFields.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        if (this.project != null) {
            this.initilizeValidator(this.project);
        }
        this.errorCache.clear();
        this.refreshJavaScriptContext();
    }

    public void performTargetMessageRemovement() {
        this.removeMappingsFor(this.selectedTargetField);
        ArrayList<AccessPointType> newList = new ArrayList<AccessPointType>();
        for (AccessPointType messageType : this.targetMessageTypes) {
            if (messageType.getId() == this.selectedTargetField.getId()) continue;
            newList.add(messageType);
        }
        this.targetMessageTypes = newList;
        this.getAccessPoint(this.application).remove(this.selectedTargetField);
        this.remove(this.selectedTargetField);
        if (this.project != null) {
            this.initilizeValidator(this.project);
        }
        this.errorCache.clear();
        this.refreshJavaScriptContext();
    }

    private void remove(AccessPointType messageType) {
        int removeIndex = -1;
        for (AccessPointType type : this.getAccessPoint(this.application)) {
            if (!type.getId().equalsIgnoreCase(messageType.getId())) continue;
            removeIndex = this.getAccessPoint(this.application).indexOf(type);
        }
        if (removeIndex > -1) {
            try {
                this.getAccessPoint(this.application).remove(removeIndex);
            }
            catch (Throwable throwable) {}
        }
    }

    public void removeAccessPoints(List<AccessPointType> messageTypes) {
        for (AccessPointType type : messageTypes) {
            this.remove(type);
        }
    }

    public void performMappingExpressionRemovement() {
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField));
        if (fm != null) {
            fm.setMappingExpression("");
            this.expressionDocument = "//Expressions\n";
        }
        this.removeMappingsFor(this.selectedTargetField);
    }

    public void performMappingStatementsRemovement() {
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField));
        if (fm != null) {
            this.statementsDocument = "//Statements\n";
        }
    }

    private void removeMappingsFor(AccessPointType messageType) {
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (String key : this.fieldMappings.keySet()) {
            FieldMapping fm;
            if (!key.startsWith(String.valueOf(messageType.getId()) + "/") || (fm = this.fieldMappings.get(key)) == null) continue;
            String expression = fm.getMappingExpression();
            fm.setMappingExpression("");
            if (expression == null || StringUtils.isEmpty((String)"")) continue;
            removeKeys.add(key);
        }
        Iterator<String> i = removeKeys.iterator();
        while (i.hasNext()) {
            String key;
            key = i.next().toString();
            this.fieldMappings.remove(key);
        }
    }

    public boolean isClearMappingExpressionAvailable() {
        if (this.selectedTargetField == null) {
            return false;
        }
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField));
        if (fm == null) {
            return false;
        }
        return fm.getMappingExpression() != null && !fm.getMappingExpression().equals("");
    }

    public boolean isClearMappingStatementAvailable() {
        if (this.selectedTargetField == null) {
            return false;
        }
        FieldMapping fm = this.fieldMappings.get(this.getXPathFor(this.selectedTargetField));
        if (fm == null) {
            return false;
        }
        return false;
    }

    public boolean isToggleBreakpointAvailable() {
        return !this.simpleMode && this.selectedTargetField != null && !this.isRoot(this.selectedTargetField);
    }

    public boolean validateMapping(FieldMapping fieldMapping, boolean updateCache) {
        if (!this.externalReference) {
            this.javaScriptValidator = new JavaScriptValidator(this.javaProject);
            if (this.javaScriptValidator != null && fieldMapping != null && !StringUtils.isEmpty((String)fieldMapping.getMappingExpression())) {
                IProblem[] problems = null;
                String fieldPath = fieldMapping.getFieldPath();
                if (this.errorCache.get(fieldPath) == null || updateCache) {
                    String sourceCode = String.valueOf(this.jScriptProlog) + "\n" + fieldMapping.getMappingExpression() + ";";
                    problems = this.javaScriptValidator.validate(sourceCode);
                    this.errorCache.put(fieldPath, problems);
                }
                if ((problems = this.errorCache.get(fieldPath)) != null) {
                    int i = 0;
                    while (i < problems.length) {
                        IProblem problem = problems[i];
                        if (problem.isError()) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
        }
        return true;
    }

    public String getToolTip(TreeItem item, int columnIndex) {
        if (columnIndex == 3 && item.getData() instanceof StructAccessPointType) {
            FieldMapping fm;
            StructAccessPointType messageType = (StructAccessPointType)item.getData();
            String xPath = this.getXPathFor((AccessPointType)messageType);
            if (messageType.getXPath() != null && (fm = this.fieldMappings.get(xPath)) != null) {
                String message = "";
                IProblem[] problems = this.errorCache.get(fm.getFieldPath());
                if (problems != null) {
                    int i = 0;
                    while (i < problems.length) {
                        IProblem problem = problems[i];
                        message = String.valueOf(message) + Modeling_Messages.MSG_ERROR + problem.getMessage() + "\n";
                        ++i;
                    }
                    return message;
                }
            }
        }
        return null;
    }

    public boolean hasMappingExpression(Object element) {
        AccessPointType messageType = (AccessPointType)element;
        FieldMapping fieldMapping = this.fieldMappings.get(this.getXPathFor(messageType));
        return fieldMapping != null && fieldMapping.getMappingExpression() != null && !fieldMapping.getMappingExpression().equalsIgnoreCase("");
    }

    public boolean hasMappingStatement(Object element) {
        AccessPointType messageType = (AccessPointType)element;
        FieldMapping fieldMapping = this.fieldMappings.get(this.getXPathFor(messageType));
        return fieldMapping != null && !fieldMapping.getMappingExpression().equalsIgnoreCase("");
    }

    public String getXPathFor(AccessPointType messageType) {
        if (messageType == null) {
            return null;
        }
        return AttributeUtil.getAttributeValue((IExtensibleElement)messageType, (String)"FullXPath");
    }

    public String getRootFor(AccessPointType messageType) {
        if (messageType == null) {
            return null;
        }
        return AttributeUtil.getAttributeValue((IExtensibleElement)messageType, (String)"RootElement");
    }

    public AccessPathBrowserContentProvider getApc() {
        return this.apc;
    }

    public boolean isSourceField(AccessPointType messageType) {
        String xPath = this.getXPathFor(messageType);
        if (xPath == null) {
            return false;
        }
        for (AccessPointType sourceType : this.sourceMessageTypes) {
            if (!xPath.startsWith(String.valueOf(sourceType.getId()) + "/")) continue;
            return true;
        }
        return false;
    }

    public void createXPathsForTree(TreeSelection treeSelection) {
        int i = 0;
        while (i < treeSelection.getPaths().length) {
            TreePath treePath = treeSelection.getPaths()[i];
            StructAccessPointType messageType = (StructAccessPointType)treePath.getSegment(treePath.getSegmentCount() - 1);
            String xPath = this.renderXPathString(treePath).toLowerCase();
            this.xPathMap.put(messageType, xPath);
            ++i;
        }
    }

    public Map<StructAccessPointType, String> getXPathMap() {
        return this.xPathMap;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public MultipleAccessPathBrowserContentProvider getSourceAPB() {
        return this.sourceAPB;
    }

    public void setSourceAPB(MultipleAccessPathBrowserContentProvider sourceAPP) {
        this.sourceAPB = sourceAPP;
    }

    public MultipleAccessPathBrowserContentProvider getTargetAPB() {
        return this.targetAPB;
    }

    public void setTargetAPB(MultipleAccessPathBrowserContentProvider targetAPB) {
        this.targetAPB = targetAPB;
    }

    public String getTypeString(AccessPointType messageType) {
        IMappingRenderer renderer = this.getMapperByType(messageType);
        return renderer.getTypeString();
    }

    public void ignoreUpcomingAnnotationChanges() {
        this.ignoreAnnotationChanges = true;
    }

    public String getJScriptProlog() {
        return this.jScriptProlog;
    }

    public void initilizeValidator(IProject project) {
        try {
            this.project = project;
            if (project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                this.javaProject = JavaScriptCore.create((IProject)project);
                this.javaScriptValidator = new JavaScriptValidator(this.javaProject);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isEditable() {
        return !this.isRoot(this.selectedTargetField) || this.isPrimitive(this.selectedTargetField);
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    public boolean isWithSerializable() {
        return this.withSerialiable;
    }

    public void setWithSerializable(boolean withSerializable) {
        this.withSerialiable = withSerializable;
    }

    public void setExternalReference(boolean externalReference) {
        this.externalReference = externalReference;
    }

    public boolean isExternalReference() {
        return this.externalReference;
    }

    public Map getFieldPathsToAccessPoints() {
        return this.fieldPathsToAccessPoints;
    }

    public boolean isContentMapping(AccessPointType accessPoint) {
        if (accessPoint instanceof StructAccessPointType) {
            Object[] children = this.targetAPB.getChildrenWithoutSetup(accessPoint, false);
            int i = 0;
            while (i < children.length) {
                AccessPointType child = (AccessPointType)children[i];
                if (child.getId().indexOf("@") > -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int getArraySelectionDepth(AccessPointType messageType) {
        String segment;
        int i;
        IMappingRenderer renderer = this.getMapperByType(messageType);
        String javaPath = renderer.renderGetterCode(false, false, null);
        String[] segments = javaPath.split("\\.");
        int depth = 0;
        if (renderer instanceof StructDataMappingRenderer) {
            i = 0;
            while (i < segments.length) {
                segment = segments[i];
                if (segment.indexOf("[0]") > -1) {
                    ++depth;
                }
                ++i;
            }
        }
        if (renderer instanceof SerializableMappingRenderer) {
            i = 0;
            while (i < segments.length) {
                segment = segments[i];
                if (segment.indexOf("(0)") > -1 || segment.indexOf("[0]") > -1) {
                    ++depth;
                }
                ++i;
            }
        }
        return depth;
    }
}

