/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageTransformationBreakpoint;

public class MessageTransformationMappingBreakpoint
extends MessageTransformationBreakpoint {
    private static final String MTM_FIELD_PATH = "MTM.FieldPath";
    private static final String BREAKPOINT_MARKER = "org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationMappingBreakpointMarker";
    private String fieldPath;

    public MessageTransformationMappingBreakpoint() {
    }

    public MessageTransformationMappingBreakpoint(final IResource resource, final String fieldPath) {
        this.fieldPath = fieldPath;
        final HashMap attributes = new HashMap();
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(MessageTransformationMappingBreakpoint.BREAKPOINT_MARKER);
                attributes.put("org.eclipse.debug.core.id", MessageTransformationMappingBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", new Boolean(true));
                attributes.put(MessageTransformationMappingBreakpoint.MTM_FIELD_PATH, fieldPath);
                attributes.put("lineNumber", new Integer(0));
                attributes.put("charStart", new Integer(0));
                attributes.put("charEnd", new Integer(0));
                marker.setAttributes(attributes);
                MessageTransformationMappingBreakpoint.this.setMarker(marker);
                MessageTransformationMappingBreakpoint.this.registerBreakpoint();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.fieldPath = (String)marker.getAttribute(MTM_FIELD_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean toggleBreakpointOff(IResource resource, String fieldPath) {
        try {
            if (resource == null) return false;
            IMarker[] markers = resource.findMarkers(BREAKPOINT_MARKER, true, 2);
            int idx = 0;
            while (true) {
                if (idx >= markers.length) {
                    return false;
                }
                IMarker marker = markers[idx];
                if (fieldPath.equals(marker.getAttribute(MTM_FIELD_PATH))) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.stardust.modeling.transformation.debug");
                    int idx2 = 0;
                    while (idx2 < breakpoints.length) {
                        IBreakpoint breakpoint = breakpoints[idx2];
                        if (marker.equals((Object)breakpoint.getMarker())) {
                            breakpoint.delete();
                            return true;
                        }
                        ++idx2;
                    }
                }
                ++idx;
            }
        }
        catch (CoreException x) {
            x.printStackTrace();
        }
        return false;
    }
}

