/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.PrimitivesFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.SerializableFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.StructuredTypesFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ExternalClassAdditionDialog
extends Dialog
implements ModifyListener {
    private static final int RESET_ID = 22;
    private Text messageNameText;
    private String tagName;
    private MessageTransformationController controller;
    private AccessPointType messageType;
    private String messageName;
    private List messageTypes;
    private String preset;
    private List allMessageTypes = new ArrayList();
    private List typeFilters = new ArrayList();
    private Label errorLabel;
    private WorkflowModelEditor wfme;
    private Composite mainComposite;
    private boolean isError = false;
    private boolean isError2 = false;
    private TypeSelectionComposite classBrowser;
    private StackLayout stack;
    private Composite structPrimComposite;
    private Composite messageComposite;
    protected ViewerFilter selectedFilter;
    private DirectionType directionType;
    private Label errorLabel2;

    public ExternalClassAdditionDialog(Shell parentShell, MessageTransformationController controller, List messageTypes, String preset, DirectionType directionType) {
        super(parentShell);
        this.controller = controller;
        this.messageTypes = messageTypes;
        this.directionType = directionType;
        this.preset = preset;
        this.allMessageTypes.addAll(controller.getSourceMessageTypes());
        this.allMessageTypes.addAll(controller.getTargetMessageTypes());
        this.allMessageTypes.addAll(controller.getExternalClassTypes());
        this.typeFilters.add(new StructuredTypesFilter());
        this.typeFilters.add(new PrimitivesFilter());
        if (!controller.isSimpleMode()) {
            this.typeFilters.add(new SerializableFilter());
        }
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart currentEditor;
        this.mainComposite = parent;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            this.wfme = (WorkflowModelEditor)currentEditor;
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout());
        Group groupComposite = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        groupComposite.setLayout((Layout)layout);
        Label tagNameLabel = new Label((Composite)groupComposite, 16384);
        tagNameLabel.setText(MessageFormat.format(Modeling_Messages.TXT_NAME, this.controller.getNameString()));
        if (!this.controller.isSimpleMode()) {
            tagNameLabel.setText(Modeling_Messages.TXT_INSTANCE_NAME);
        }
        this.messageNameText = new Text((Composite)groupComposite, 2052);
        this.messageNameText.addModifyListener((ModifyListener)this);
        GridData data = new GridData(768);
        this.messageNameText.setLayoutData((Object)data);
        this.errorLabel = new Label((Composite)groupComposite, 0);
        this.errorLabel.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
        this.errorLabel.setVisible(false);
        Label typeLabel = new Label((Composite)groupComposite, 16384);
        typeLabel.setText(Modeling_Messages.TXT_CLASS);
        this.classBrowser = new TypeSelectionComposite((Composite)groupComposite, Modeling_Messages.PlainJavaPropertyPage_LB_Plain_Java);
        this.classBrowser.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalClassAdditionDialog.this.serializableTypeModified(e);
                ExternalClassAdditionDialog.this.buttonEnablement();
            }
        });
        this.classBrowser.getText().setEditable(false);
        this.errorLabel2 = new Label((Composite)groupComposite, 0);
        this.errorLabel2.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
        this.errorLabel2.setVisible(false);
        parent.getShell().setMinimumSize(300, 150);
        parent.getShell().setText(Modeling_Messages.TXT_ADD_EXTERNAL_CL);
        this.handleErrors();
        return comp;
    }

    private void handleErrors() {
        String text = this.messageNameText.getText();
        if (!this.controller.isSimpleMode()) {
            if (this.getMessageTypeByName(text) != null) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_ALREADY_EXIST_WITHIN_CONTEXT, text));
            } else if (!StringUtils.isValidIdentifier((String)text) || StringUtils.isEmpty((String)text)) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
            } else {
                this.isError = false;
                this.errorLabel.setToolTipText(null);
            }
        } else if (!StringUtils.isValidIdentifier((String)text)) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
        } else {
            this.isError = false;
            this.errorLabel.setToolTipText(null);
        }
        if (this.messageType == null) {
            this.isError2 = true;
            this.errorLabel2.setToolTipText(Modeling_Messages.TXT_NO_CLASS_PROVIDED);
        } else {
            this.isError2 = false;
            this.errorLabel2.setToolTipText(null);
        }
        this.errorLabel.setVisible(this.isError);
        this.errorLabel2.setVisible(this.isError2);
    }

    protected void buttonEnablement() {
        this.handleErrors();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!this.isError && !this.isError2);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.buttonEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.messageName = this.messageNameText.getText();
        }
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent arg0) {
        this.buttonEnablement();
    }

    private void serializableTypeModified(ModifyEvent e) {
        this.messageType = null;
        if (this.classBrowser.getType() != null) {
            AccessPointType apt;
            String messageName;
            String text = messageName = this.classBrowser.getType().getType().getElementName();
            int n = 1;
            while (this.isAccessPointIdDefined(String.valueOf(text) + n)) {
                ++n;
            }
            text = String.valueOf(text) + n;
            this.messageNameText.setText(text);
            this.messageType = apt = this.controller.getMtaUtils().createSerializableAccessPoint(this.classBrowser.getType(), text, this.directionType);
        }
    }

    public AccessPointType getMessageType() {
        return this.messageType;
    }

    public String getMessageName() {
        return this.messageName;
    }

    private boolean isAccessPointIdDefined(String id) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(name)) continue;
            return messageType;
        }
        return null;
    }
}

