/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;
import org.eclipse.stardust.modeling.validation.util.IModelParticipantUtils;

public class ConditionalPerformerValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        DataType data;
        ArrayList<Issue> result = new ArrayList<Issue>();
        ConditionalPerformerType conditionalPerformer = (ConditionalPerformerType)element;
        if (IModelParticipantUtils.isDuplicateId((IModelParticipant)conditionalPerformer)) {
            result.add(Issue.error((EObject)conditionalPerformer, Validation_Messages.MSG_COND_PERFORMER_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if ((data = conditionalPerformer.getData()) == null) {
            result.add(Issue.error((EObject)conditionalPerformer, Validation_Messages.MSG_COND_PERFORMER_NoDataSet, ValidationService.PKG_CWM.getConditionalPerformerType_Data()));
        } else {
            IBridgeObjectProvider dataBridgeProvider = ValidatorRegistry.getBridgeObjectProvider((ITypedElement)conditionalPerformer.getData());
            if (dataBridgeProvider != null) {
                try {
                    String className;
                    String dataPath = conditionalPerformer.getDataPath();
                    dataPath = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer()).replaceAllVariablesByDefaultValue(dataPath);
                    BridgeObject rhs = dataBridgeProvider.getBridgeObject((ITypedElement)data, dataPath, DirectionType.OUT_LITERAL);
                    IType type = rhs.getEndClass();
                    String string = className = type == null ? null : type.getFullyQualifiedName();
                    if (!String.class.getName().equals(className) && !Long.class.getName().equals(className)) {
                        result.add(Issue.error((EObject)conditionalPerformer, Validation_Messages.MSG_COND_PERFORMER_UnsupportedType, ValidationService.PKG_CWM.getConditionalPerformerType_DataPath()));
                    }
                }
                catch (ValidationException e) {
                    result.add(Issue.warning((EObject)conditionalPerformer, e.getMessage(), ValidationService.PKG_CWM.getConditionalPerformerType_DataPath()));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

