/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelVariable;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ConfigurationVariableValidator
implements IModelValidator {
    private static final Issue[] ISSUE_ARRAY = new Issue[0];
    private ArrayList<EObject> unique;
    private String[] attributes = new String[]{"carnot:engine:remoteInterface", "carnot:engine:spring::beanId"};

    @Override
    public Issue[] validate(ModelType model) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        VariableContext context = VariableContextHelper.getInstance().getContext(model);
        if (context != null) {
            for (ModelVariable modelVariable : context.getVariables()) {
                if (modelVariable.isRemoved()) continue;
                List list = (List)context.getVariableReferences().get(modelVariable.getName());
                if (!context.isValidName(modelVariable.getName())) {
                    result.add(Issue.warning((EObject)model, MessageFormat.format(Validation_Messages.MODEL_ConfigurationVariable_Invalid, modelVariable.getName()), "carnot:engine:target"));
                }
                if (list == null || list.isEmpty()) {
                    result.add(Issue.warning((EObject)model, MessageFormat.format(Validation_Messages.MODEL_ConfigurationVariable_NeverUsed, modelVariable.getName()), "carnot:engine:target"));
                }
                if (modelVariable.getDefaultValue() == null || modelVariable.getDefaultValue() == "") {
                    result.add(Issue.warning((EObject)model, MessageFormat.format(Validation_Messages.MODEL_ConfigurationVariable_NoDefaultValue, modelVariable.getName()), "carnot:engine:target"));
                }
                if (list == null) continue;
                this.unique = new ArrayList();
                Iterator j = list.iterator();
                while (j.hasNext()) {
                    List<Issue> issues = this.isAllowed((EObject)j.next());
                    if (issues.isEmpty()) continue;
                    result.addAll(issues);
                }
            }
        }
        return result.toArray(ISSUE_ARRAY);
    }

    private TypeDeclarationType getTypeDeclaration(EObject o) {
        if (o instanceof TypeDeclarationType) {
            return (TypeDeclarationType)o;
        }
        if (o.eContainer() != null) {
            return this.getTypeDeclaration(o.eContainer());
        }
        return null;
    }

    private List<Issue> isAllowed(EObject o) {
        TypeDeclarationType typeDecl;
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (o instanceof IIdentifiableElement) {
            IIdentifiableElement dataType = (IIdentifiableElement)o;
            if (dataType.getName().indexOf("${") > -1) {
                result.add(Issue.error((EObject)dataType, Validation_Messages.MODEL_ConfigurationVariable_NAME, "carnot:engine:target"));
            }
            if (dataType.getId().indexOf("${") > -1) {
                result.add(Issue.error((EObject)dataType, Validation_Messages.MODEL_ConfigurationVariable_ID, "carnot:engine:target"));
            }
        }
        if (o instanceof AttributeType) {
            String owner = "";
            AttributeType attribute = (AttributeType)o;
            EObject parent = attribute.eContainer();
            if (parent != null && parent instanceof IIdentifiableElement) {
                owner = ((IIdentifiableElement)parent).getName();
            }
            String name = attribute.getName();
            int k = 0;
            while (k < this.attributes.length) {
                if (this.attributes[k].equalsIgnoreCase(name)) {
                    result.add(Issue.warning((EObject)attribute, MessageFormat.format(Validation_Messages.MODEL_ConfigurationVariable_NotAllowed, attribute.getName(), owner), "carnot:engine:target"));
                }
                ++k;
            }
        }
        if (o instanceof DescriptionType) {
            result.add(Issue.error(o, Validation_Messages.MODEL_ConfigurationVariable_Description, "carnot:engine:target"));
        }
        if ((typeDecl = this.getTypeDeclaration(o)) != null && !this.unique.contains(typeDecl)) {
            result.add(Issue.error((EObject)typeDecl, Validation_Messages.MODEL_ConfigurationVariable_TypeDec, "carnot:engine:target"));
            this.unique.add((EObject)typeDecl);
        }
        return result;
    }

    public String getText(String name, Object element) {
        EObject eObject = (EObject)element;
        EStructuralFeature attr = eObject.eClass().getEStructuralFeature(name);
        Object value = attr == null ? null : eObject.eGet(attr);
        return value == null ? "" : value.toString();
    }

    public String getText(Object element) {
        if (element instanceof EObject) {
            String text = this.getText("name", element);
            if (text.length() == 0) {
                text = this.getText("id", element);
            }
            if (text.length() == 0 && element instanceof ITypedElement) {
                text = this.getText(((ITypedElement)element).getMetaType());
            }
            if (text.length() != 0) {
                return text;
            }
        }
        return element.toString();
    }

    public String getElementName(Object element) {
        EObject object = (EObject)element;
        if (object.eContainer() instanceof ModelType) {
            return this.getText((EObject)element);
        }
        return this.getText(((EObject)element).eContainer());
    }
}

