/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import com.infinity.bpm.thirdparty.emf.common.util.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.ui.PlatformUI;

public class ReferencedModelElementValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:connection:uri");
        boolean invalid = false;
        if (attribute != null && !element.eIsProxy()) {
            String uri = attribute.getValue();
            URI aRealUri = URI.createURI((String)uri);
            String typeName = aRealUri.lastSegment();
            ModelType modelType = ModelUtils.findContainingModel((EObject)element);
            Connection connection = (Connection)modelType.getConnectionManager().findConnection(uri);
            if (connection.getAttribute("importByReference") != null && !"false".equals(connection.getAttribute("importByReference"))) {
                EObject o = modelType.getConnectionManager().find(String.valueOf(aRealUri.scheme().toString()) + "://" + aRealUri.authority() + "/");
                ModelType referencedModel = (ModelType)Reflect.getFieldValue((Object)o, (String)"eObject");
                if (element instanceof DataType) {
                    TypeDeclarationType type = referencedModel.getTypeDeclarations().getTypeDeclaration(typeName);
                    boolean bl = invalid = referencedModel.getTypeDeclarations().getTypeDeclaration(typeName) == null;
                    if (!invalid) {
                        if (Platform.isRunning() && !this.isPublic((EObject)type)) {
                            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_ReferencedType_NotVisible, typeName, referencedModel.getName()), "carnot:engine:dataType"));
                        }
                    } else {
                        result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_ReferencedType_NotFound, typeName, referencedModel.getName()), "carnot:engine:dataType"));
                    }
                }
                if (element instanceof ActivityType) {
                    boolean found = false;
                    ApplicationType refApp = null;
                    if (aRealUri.segment(0).equalsIgnoreCase("application")) {
                        for (ApplicationType referencedApp : referencedModel.getApplication()) {
                            if (!referencedApp.getId().equalsIgnoreCase(typeName)) continue;
                            found = true;
                            refApp = referencedApp;
                        }
                        boolean bl = invalid = !found;
                        if (!invalid) {
                            if (Platform.isRunning() && !this.isPublic((EObject)refApp)) {
                                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_ReferencedType_NotVisible, typeName, referencedModel.getName()), ValidationService.PKG_CWM.getActivityType_Application()));
                            }
                        } else {
                            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_ReferencedType_NotFound, typeName, referencedModel.getName()), ValidationService.PKG_CWM.getActivityType_Application()));
                        }
                    }
                    if (aRealUri.segment(0).equalsIgnoreCase("processDefinition")) {
                        for (ProcessDefinitionType referencedProcess : referencedModel.getProcessDefinition()) {
                            if (referencedProcess.getId() == null || !referencedProcess.getId().equalsIgnoreCase(typeName)) continue;
                            found = true;
                        }
                        boolean bl = invalid = !found;
                        if (invalid) {
                            result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MODEL_ReferencedType_NotFound, typeName, referencedModel.getName()), ValidationService.PKG_CWM.getProcessDefinitionType()));
                        }
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    public boolean isPublic(EObject element) {
        String visibilityDefault;
        AttributeType attributeType;
        String visibility = null;
        if (element instanceof IExtensibleElement && (attributeType = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:visibility")) != null) {
            visibility = attributeType.getValue();
        }
        if (element instanceof Extensible && (attributeType = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)((Extensible)element).getExtendedAttributes(), (String)"carnot:engine:visibility")) != null) {
            visibility = attributeType.getValue();
        }
        if (visibility == null && ((visibilityDefault = PlatformUI.getPreferenceStore().getString("multiPackageModelingVisibility")) == null || visibilityDefault == "" || visibilityDefault.equalsIgnoreCase("Public"))) {
            return true;
        }
        return visibility.equalsIgnoreCase("public");
    }
}

