/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;

public class JMSValidator
implements IModelElementValidator {
    private static final String IN = "in";
    private static final String INOUT = "inout";
    private static final String OUT = "out";
    private static final String[] messages = new String[]{Validation_Messages.MSG_PropertyNotSet, Validation_Messages.MSG_ParameterHasNoId, Validation_Messages.MSG_NoLocationForParameter, Validation_Messages.MSG_NoValidTypeForParameter, Validation_Messages.MSG_DuplicateIdUsed, Validation_Messages.MSG_PropertyNotSet};

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String key = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:type");
        if (key == null) {
            result.add(Issue.error((EObject)element, MessageFormat.format(messages[0], "carnot:engine:type"), "carnot:engine:type"));
        } else if (key.equalsIgnoreCase(OUT) || key.equalsIgnoreCase(INOUT)) {
            result.addAll(this.checkProperty(element, "carnot:engine:queueConnectionFactory.jndiName"));
            result.addAll(this.checkProperty(element, "carnot:engine:queue.jndiName"));
            result.addAll(this.checkProperty(element, "carnot:engine:messageProvider"));
            result.addAll(this.checkProperty(element, "carnot:engine:requestMessageType"));
        } else if (key.equalsIgnoreCase(IN) || key.equalsIgnoreCase(INOUT)) {
            result.addAll(this.checkProperty(element, "carnot:engine:messageAcceptor"));
            result.addAll(this.checkProperty(element, "carnot:engine:responseMessageType"));
        }
        ArrayList<String> ids = new ArrayList<String>();
        ApplicationType application = (ApplicationType)element;
        EList accessPoints = application.getAccessPoint();
        for (AccessPointType ap : accessPoints) {
            String className;
            if (StringUtils.isEmpty((String)ap.getId())) {
                result.add(Issue.error((EObject)ap, messages[1], ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            } else if (!ModelUtils.isValidId((String)ap.getId())) {
                result.add(Issue.warning((EObject)ap, MessageFormat.format(Validation_Messages.ERR_ELEMENT_InvalidId, ap.getId()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            } else {
                String idKey = String.valueOf(ap.getDirection().getName()) + ":" + ap.getId();
                if (ids.contains(idKey)) {
                    result.add(Issue.error((EObject)ap, MessageFormat.format(messages[4], ap.getName()), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
                }
                ids.add(idKey);
            }
            if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)ap, (String)"carnot:engine:jms.location"))) {
                result.add(Issue.error((EObject)ap, MessageFormat.format(messages[2], ap.getName()), "carnot:engine:jms.location"));
            }
            if (JavaDataTypeUtils.getTypeFromCurrentProject(className = AttributeUtil.getAttributeValue((IExtensibleElement)ap, (String)"carnot:engine:className")) != null) continue;
            result.add(Issue.error((EObject)ap, MessageFormat.format(messages[3], ap.getName(), className), "carnot:engine:className"));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private List checkProperty(IModelElement element, String name) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String property = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)name);
        if (property == null || property.toString().trim().length() == 0) {
            result.add(Issue.error((EObject)element, MessageFormat.format(messages[5], name), name));
        }
        return result;
    }
}

