/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.conditionTypes;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.Period;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;

public class TimerValidator
implements IModelElementValidator {
    private static final BridgeObject DATE_TARGET = new BridgeObject(JavaDataTypeUtils.getTypeFromCurrentProject(Date.class.getName()), DirectionType.IN_LITERAL);
    private static final BridgeObject LONG_TARGET = new BridgeObject(JavaDataTypeUtils.getTypeFromCurrentProject(Long.class.getName()), DirectionType.IN_LITERAL);
    private static final BridgeObject PERIOD_TARGET = new BridgeObject(JavaDataTypeUtils.getTypeFromCurrentProject(Period.class.getName()), DirectionType.IN_LITERAL);

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        boolean useData = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:useData");
        if (useData) {
            String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:data");
            if (StringUtils.isEmpty((String)dataId)) {
                result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoDataSpecified));
            }
            if (ModelUtils.findContainingProcess((EObject)element) != null) {
                DataType data = this.findData(element, dataId);
                if (data != null) {
                    String dataPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataPath");
                    BridgeObject bo = null;
                    try {
                        bo = BridgeObject.getBridge((ITypedElement)data, dataPath, DirectionType.OUT_LITERAL);
                        if (!(DATE_TARGET.acceptAssignmentFrom(bo) || LONG_TARGET.acceptAssignmentFrom(bo) || PERIOD_TARGET.acceptAssignmentFrom(bo))) {
                            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_InvalidDataMapping));
                        }
                    }
                    catch (ValidationException e) {
                        result.add(Issue.warning((EObject)element, e.getMessage()));
                    }
                } else {
                    result.add(Issue.warning((EObject)element, Validation_Messages.MSG_InvalidDataSpecified));
                }
            } else {
                result.add(Issue.warning((EObject)element, Validation_Messages.MSG_TimerConditionHasToHave));
            }
        } else {
            String period = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:period");
            if (StringUtils.isEmpty((String)period)) {
                result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoPeriodSpecified, "carnot:engine:period"));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private DataType findData(IModelElement element, String dataId) {
        DataType data = null;
        for (DataType dataType : ModelUtils.findContainingModel((EObject)element).getData()) {
            if (!dataType.getId().equals(dataId)) continue;
            data = dataType;
        }
        return data;
    }
}

