/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.dataTypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.engine.extensions.xml.data.XPathEvaluator;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLValidator
implements IModelElementValidator,
IBridgeObjectProvider {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList result = new ArrayList();
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    @Override
    public BridgeObject getBridgeObject(ITypedElement accessPoint, String accessPath, DirectionType direction) {
        String className;
        if (DirectionType.OUT_LITERAL.equals((Object)direction)) {
            Object pseudoResult = new XPathEvaluator().evaluate(Collections.EMPTY_MAP, (Object)"<emptyXml />", accessPath);
            Class clazz = pseudoResult != null ? pseudoResult.getClass() : List.class;
            className = clazz.getName();
        } else {
            className = String.class.getName();
        }
        TypeFinder finder = new TypeFinder((EObject)accessPoint);
        return new XMLBridgeObject(finder.findExactType(className), direction);
    }

    private class XMLBridgeObject
    extends BridgeObject {
        public XMLBridgeObject(IType clazz, DirectionType direction) {
            super(clazz, direction);
        }

        @Override
        public boolean acceptAssignmentFrom(BridgeObject rhs) {
            if (this.getDirection() == DirectionType.OUT_LITERAL) {
                return false;
            }
            if (rhs.getDirection() == DirectionType.IN_LITERAL) {
                return false;
            }
            if (TypeFinder.isAssignable(this.getEndClass(), rhs.getEndClass())) {
                return true;
            }
            TypeFinder finder = new TypeFinder(this.getEndClass());
            IType elemType = finder.findExactType(Element.class.getName());
            if (TypeFinder.isAssignable(elemType, rhs.getEndClass())) {
                return true;
            }
            IType docType = finder.findExactType(Document.class.getName());
            return TypeFinder.isAssignable(docType, rhs.getEndClass());
        }
    }
}

