/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.Money;
import org.eclipse.stardust.common.Period;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodFilter;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.SearchJob;
import org.eclipse.stardust.modeling.validation.util.TypeFinderListener;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.osgi.framework.Bundle;

public class TypeFinder {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private SearchJob finder;
    private MethodFilter methodFilter;
    private IJavaSearchScope scope;
    private IJavaProject project;
    private static final String PLUGIN_ID = "org.eclipse.stardust.modeling.common.platform";
    private EObject modelElement;

    public TypeFinder(IJavaProject project) {
        this.project = project;
        this.scope = project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
    }

    public TypeFinder(IProject project) {
        this(JavaCore.create((IProject)project));
    }

    public TypeFinder(IResource resource) {
        this(resource == null ? null : resource.getProject());
    }

    public TypeFinder(EObject object) {
        this(TypeFinder.getProjectFromEObject(object));
        this.modelElement = object;
    }

    public TypeFinder(IType iType) {
        this(iType == null ? null : iType.getJavaProject());
    }

    public static IProject getProjectFromEObject(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            URI eUri = eResource.getURI();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eUri.segment(1));
            if (resource instanceof IProject) {
                return (IProject)resource;
            }
            if (resource != null) {
                return resource.getProject();
            }
        }
        return null;
    }

    public void findExactType(String proto, TypeFinderListener listener) {
        this.stop();
        if (proto.length() != 0 && proto.charAt(proto.length() - 1) != '.') {
            int ix = proto.lastIndexOf(46);
            String packageName = ix < 0 ? null : proto.substring(0, ix);
            String typeName = ix < 0 ? proto : proto.substring(ix + 1);
            this.finder = new SearchJob(packageName, typeName, this.scope, 0, listener);
        }
        this.schedule(listener);
    }

    public void findTypes(String prefix, TypeFinderListener listener) {
        this.stop();
        if (prefix.length() != 0) {
            int ix = prefix.lastIndexOf(46);
            String packageName = ix < 0 ? null : prefix.substring(0, ix);
            String typeName = ix < 0 ? prefix : prefix.substring(ix + 1);
            this.finder = new SearchJob(packageName, typeName, this.scope, 1, listener);
        }
        this.schedule(listener);
    }

    private void stop() {
        if (this.finder != null) {
            this.finder.stop();
        }
        this.finder = null;
    }

    private void schedule(TypeFinderListener listener) {
        if (this.finder != null) {
            this.finder.schedule();
        } else {
            listener.startSearch();
            listener.endSearch();
        }
    }

    public IType findExactType(String proto) {
        Class<?> primitiveWrapper = TypeFinder.getPrimitiveWrapper(proto);
        if (primitiveWrapper != null) {
            proto = primitiveWrapper.getName();
        }
        if (this.project != null) {
            try {
                return this.project.findType(proto);
            }
            catch (JavaModelException javaModelException) {}
        }
        final IType[] result = new IType[1];
        if (proto.length() != 0 && proto.charAt(proto.length() - 1) != '.') {
            int ix = proto.lastIndexOf(46);
            SearchJob finder = new SearchJob(ix < 0 ? null : proto.substring(0, ix), ix < 0 ? proto : proto.substring(ix + 1), this.scope, 0, new TypeFinderListener(){

                @Override
                public void typeFound(IType type) {
                    result[0] = type;
                }

                @Override
                public void startSearch() {
                }

                @Override
                public void endSearch() {
                }
            });
            finder.run(null);
        }
        return result[0];
    }

    public List<MethodInfo> getMethods(IType type, String hint) {
        return this.codeComplete(type, hint.toCharArray());
    }

    public List<MethodInfo> getMethods(IType type) {
        return this.codeComplete(type, new char[0]);
    }

    public List<MethodInfo> getConstructors(IType type) {
        return this.codeComplete(type, ("new " + type.getFullyQualifiedName() + "(").toCharArray());
    }

    private List<MethodInfo> codeComplete(IType type, final char[] snippet) {
        final List methods = CollectionUtils.newList();
        try {
            type.codeComplete(snippet, -1, snippet.length, new char[0][0], new char[0][0], new int[0], false, new CompletionRequestor(){

                public void accept(CompletionProposal proposal) {
                    if (proposal.getKind() == 6) {
                        MethodInfo info = new MethodInfo(snippet.length > 0, proposal.getName(), proposal.getSignature(), Flags.isPublic((int)proposal.getFlags()));
                        if (TypeFinder.this.methodFilter == null || TypeFinder.this.methodFilter.accept(info)) {
                            methods.add(info);
                        }
                    }
                }
            });
        }
        catch (JavaModelException e) {
            TypeFinder.log((IStatus)e.getJavaModelStatus());
        }
        return methods;
    }

    public void setMethodFilter(MethodFilter filter) {
        this.methodFilter = filter;
    }

    public boolean implementsInterface(String className, String interfaceName) {
        if (interfaceName.equals(className)) {
            return true;
        }
        IType type = this.findExactType(className);
        return this.implementsInterface(type, interfaceName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean implementsInterface(IType type, String interfaceName) {
        if (type == null) {
            return false;
        }
        if (interfaceName.equals(type.getFullyQualifiedName())) {
            return true;
        }
        try {
            String[] signatures = type.getSuperInterfaceTypeSignatures();
            int i = 0;
            while (true) {
                if (i >= signatures.length) {
                    return false;
                }
                String superName = TypeFinder.resolveName(type, signatures[i]);
                if (interfaceName.equals(superName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean extendsClass(String actualClassName, String className) {
        if (className.equals(actualClassName)) {
            return true;
        }
        IType type = this.findExactType(actualClassName);
        return type != null ? this.extendsClass(type, className) : false;
    }

    public boolean extendsClass(IType type, String className) {
        String superName;
        block6: {
            block5: {
                if (className.equals(type.getFullyQualifiedName())) {
                    return true;
                }
                try {
                    superName = TypeFinder.resolveName(type, type.getSuperclassTypeSignature());
                    if (!className.equals(superName)) break block5;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (!"java.lang.Object".equals(superName)) break block6;
            return false;
        }
        return this.extendsClass(superName, className);
    }

    public static String resolveName(IType type, String signature) throws JavaModelException {
        String typeName = null;
        int arrayCount = Signature.getArrayCount((String)signature);
        if (signature.charAt(arrayCount) == 'Q') {
            String[][] resolved = type.resolveType(Signature.toString((String)signature));
            if (resolved.length == 0) {
                TypeFinder.warn(String.valueOf(Validation_Messages.MSG_UnableToResolve) + Signature.toString((String)signature));
            } else if (resolved.length > 1) {
                TypeFinder.warn(String.valueOf(Validation_Messages.MSG_AmbiguousDeclaration) + Signature.toString((String)signature));
            } else {
                typeName = Signature.toQualifiedName((String[])resolved[0]);
            }
        } else {
            typeName = Signature.toString((String)signature);
        }
        return typeName;
    }

    public static void warn(String message) {
        TypeFinder.log((IStatus)new Status(2, PLUGIN_ID, 0, message, null));
    }

    public static void log(IStatus status) {
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            Platform.getLog((Bundle)bundle).log(status);
        }
        catch (Exception exception) {}
    }

    public static String getClassFromAbbreviatedName(String className) {
        Class resolvedClass = null;
        if (StringUtils.isEmpty((String)className)) {
            resolvedClass = String.class;
        } else if (Type.String.getId().equals(className)) {
            resolvedClass = String.class;
        } else if (Type.Boolean.getId().equals(className)) {
            resolvedClass = Boolean.class;
        } else if (Type.Char.getId().equals(className)) {
            resolvedClass = Character.class;
        } else if (Type.Byte.getId().equals(className)) {
            resolvedClass = Byte.class;
        } else if (Type.Short.getId().equals(className)) {
            resolvedClass = Short.class;
        } else if (Type.Integer.getId().equals(className)) {
            resolvedClass = Integer.class;
        } else if (Type.Long.getId().equals(className)) {
            resolvedClass = Long.class;
        } else if (Type.Float.getId().equals(className)) {
            resolvedClass = Float.class;
        } else if (Type.Double.getId().equals(className)) {
            resolvedClass = Double.class;
        } else if (Type.Money.getId().equals(className)) {
            resolvedClass = Money.class;
        } else if (Type.Calendar.getId().equals(className)) {
            resolvedClass = Calendar.class;
        } else if (Type.Timestamp.getId().equals(className)) {
            resolvedClass = Date.class;
        } else if ("Period".equals(className)) {
            resolvedClass = Period.class;
        }
        return resolvedClass == null ? null : resolvedClass.getName();
    }

    public static boolean isAssignable(IType left, IType right) {
        if (right == null || left == null) {
            return false;
        }
        try {
            ITypeHierarchy hierarchy = right.newSupertypeHierarchy(null);
            return hierarchy.contains(left);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public MethodInfo getConstructor(IType type, String ctorName) {
        String compactCtorName = StringUtils.replace((String)ctorName, (String)", ", (String)",");
        for (MethodInfo candidate : this.getConstructors(type)) {
            if (!compactCtorName.equals(candidate.getEncoded())) continue;
            return candidate;
        }
        return null;
    }

    public MethodInfo getMethod(IType type, String methodName) {
        String compactMethodName = StringUtils.replace((String)methodName, (String)", ", (String)",");
        int idxBrace = compactMethodName.indexOf(40);
        String baseName = compactMethodName.substring(0, idxBrace + 1);
        for (MethodInfo candidate : this.getMethods(type, baseName)) {
            if (!compactMethodName.equals(StringUtils.replace((String)candidate.getEncoded(), (String)", ", (String)","))) continue;
            return candidate;
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.project;
    }

    public static Class<?> getPrimitiveWrapper(String primitiveType) {
        Class result = null;
        if (primitiveType.endsWith("[]")) {
            return Array.class;
        }
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            if (PRIMITIVE_TYPES[i].getName().equals(primitiveType)) {
                result = Reflect.getWrapperClassFromPrimitiveClassName(PRIMITIVE_TYPES[i]);
                break;
            }
            ++i;
        }
        return result;
    }

    public TypeInfo findType(String fullClassName) {
        String parameters = null;
        String className = fullClassName;
        int ix = fullClassName.indexOf(60);
        if (ix > 0) {
            parameters = fullClassName.substring(ix);
            className = fullClassName.substring(0, ix);
        }
        className = className.replace('$', '.');
        IType type = this.findExactType(className);
        TypeInfo result = null;
        if (type != null) {
            try {
                result = new TypeInfo(this, type, parameters);
            }
            catch (JavaModelException e) {
                TypeFinder.log((IStatus)e.getJavaModelStatus());
            }
        }
        return result;
    }

    public List<MethodInfo> getMethods(TypeInfo type, String fragmentName) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException e) {
            TypeFinder.log((IStatus)e.getJavaModelStatus());
            return Collections.emptyList();
        }
    }

    public List<MethodInfo> getConstructors(TypeInfo type) {
        try {
            return type.getConstructors();
        }
        catch (JavaModelException e) {
            TypeFinder.log((IStatus)e.getJavaModelStatus());
            return Collections.emptyList();
        }
    }

    public EObject getModelElement() {
        return this.modelElement;
    }
}

