/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.runtime.beans.ModelRefBean;
import org.eclipse.stardust.reporting.common.DbAwareGroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.ModelNameColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public abstract class AbstractModelProcessView
extends View {
    private static Logger log = LogUtils.getLogger(AbstractModelProcessView.class);
    protected DbAwareGroupColumn nameColumn;
    protected DbAwareGroupColumn idColumn;
    protected DbAwareGroupColumn oidColumn;
    protected List<DbAwareGroupColumn> reportColumns;

    public AbstractModelProcessView(String id) {
        super(id);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[0];
    }

    @Override
    protected void createDefaultFields() {
        this.idColumn = new DbAwareGroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class);
        this.nameColumn = new DbAwareGroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class);
        this.oidColumn = new DbAwareGroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, String.class);
        this.reportColumns = new ArrayList<DbAwareGroupColumn>();
        this.reportColumns.add(this.nameColumn);
        this.reportColumns.add(this.idColumn);
        this.reportColumns.add(this.oidColumn);
        this.addGroupColumns(this.reportColumns);
    }

    protected abstract ModelRefType getModelRefType();

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        String tableAlias = "mr";
        String modelAlias = "ma";
        DbColumn codeColumnName = new DbColumn("code", tableAlias);
        DbColumn modelOidColumnName = new DbColumn("modelOid", tableAlias);
        DbColumn refOIDColumnName = new DbColumn("refOid", tableAlias);
        DbColumn joinedModelOidColumnName = new DbColumn("oid", modelAlias);
        ModelNameColumn joinedModelNameColumn = new ModelNameColumn(joinedModelOidColumnName, modelAlias);
        DbColumn joinnedModelIdColumnName = new DbColumn("id", modelAlias);
        ArrayList<DbColumn> columnNames = new ArrayList<DbColumn>();
        columnNames.add(codeColumnName);
        columnNames.add(modelOidColumnName);
        columnNames.add(refOIDColumnName);
        columnNames.add(joinedModelNameColumn);
        columnNames.add(joinnedModelIdColumnName);
        columnNames.add(joinedModelOidColumnName);
        DbUtils.indexColumns(columnNames);
        this.idColumn.setDbColumn(joinnedModelIdColumnName);
        this.nameColumn.setDbColumn(joinedModelNameColumn);
        this.oidColumn.setDbColumn(joinedModelOidColumnName);
        ModelRefType type = this.getModelRefType();
        String modelOIDParam = this.getModelOidParameter(parameters);
        long reportModelOID = ViewUtils.converToLong(modelOIDParam);
        StringBuffer buffer = new StringBuffer();
        String selectedColumns = DbUtils.getColumnList(columnNames);
        buffer.append("select ").append(selectedColumns);
        buffer.append(" from ").append(this.getQualifiedTableName("model_ref")).append(" ").append(tableAlias);
        String modelJoin = null;
        modelJoin = type == ModelRefType.USING_MODEL ? this.getModelJoinFragment(modelAlias, "modelOid", tableAlias) : this.getModelJoinFragment(modelAlias, "refOid", tableAlias);
        buffer.append(" ").append(modelJoin);
        buffer.append(" where ");
        if (type == ModelRefType.USING_MODEL) {
            buffer.append(refOIDColumnName);
        } else {
            buffer.append(modelOidColumnName);
        }
        buffer.append(" = ");
        buffer.append(reportModelOID).append(" and ").append(refOIDColumnName);
        buffer.append(" != ").append(modelOidColumnName);
        buffer.append(" and ").append(codeColumnName).append(" = ").append(ModelRefBean.TYPE.USES.ordinal());
        buffer.append(" order by ").append(codeColumnName.getQualifiedNameWithAlias());
        buffer.append(" ASC");
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Localizer localizer = new Localizer(allDeployedModels);
        try {
            while (resultSet.next()) {
                Object[] row = new Object[this.reportColumns.size()];
                int i = 0;
                while (i < this.reportColumns.size()) {
                    DbAwareGroupColumn column = this.reportColumns.get(i);
                    String value = column.getStringValue(localizer, resultSet);
                    row[i] = value;
                    ++i;
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return this.convertRowsToRowSet(rows);
    }

    public DbAwareGroupColumn getNameColumn() {
        return this.nameColumn;
    }

    public DbAwareGroupColumn getIdColumn() {
        return this.idColumn;
    }

    public DbAwareGroupColumn getOidColumn() {
        return this.oidColumn;
    }

    protected static enum ModelRefType {
        USING_MODEL,
        USED_MODEL;

    }
}

