/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.DataPrefetchHint;
import org.eclipse.stardust.engine.api.query.FilterAndTerm;
import org.eclipse.stardust.engine.api.query.ProcessInstanceQuery;
import org.eclipse.stardust.engine.api.query.Query;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.ActivityMetricsColumn;
import org.eclipse.stardust.reporting.common.ColumnProvider;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.ForeignDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelPropertyColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataColumn;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.StructDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.cluster.Data2ClusterMapper;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.Tokenizer;
import org.eclipse.stardust.reporting.common.utils.UserDefinedColumnsIterator;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.utils.sql.legacy.DataColumnJoinStructure;
import org.eclipse.stardust.reporting.common.worktime.IWorktimeCalculator;

public abstract class AbstractProcessInstanceView
extends View {
    static Logger log = LogUtils.getLogger(AbstractProcessInstanceView.class);
    protected static final int RS_COL_MODEL_ID = 1;
    protected static final int RS_COL_P_MODEL = 2;
    protected static final int RS_COL_P_ID = 3;
    protected static final int RS_COL_P_OID = 4;
    protected static final int RS_COL_P_NAME = 5;
    protected static final int RS_COL_P_DESCRIPTION = 6;
    protected static final int RS_COL_PI_OID = 7;
    protected static final int RS_COL_PI_STATE = 8;
    protected static final int RS_COL_PI_STARTING_USER = 9;
    protected static final int RS_COL_PI_STARTING_AI = 10;
    protected static final int RS_COL_PI_ROOT_PI = 11;
    protected static final int RS_COL_PI_START_TIME = 12;
    protected static final int RS_COL_PI_TERMINATION_TIME = 13;
    protected static final int RS_COL_PI_SCOPE_PROCESS_INSTANCE = 14;
    protected static final int RS_COL_PI_TOTAL_ACTIVE_TIME = 15;
    protected static final int RS_COL_SUB_PI_TOTAL_ACTIVE_TIME = 16;
    protected static final int RS_COL_SUB_PI_START_TIME = 17;
    protected static final int RS_COL_SUB_PI_TERMINATION_TIME = 18;
    protected static final int RS_MMODEL_ID = 19;
    private static final String MODEL_ID_UNDEFINED = "MODEL_ID_UNDEFINED";
    protected IWorktimeCalculator worktimeCalculator;
    protected Map<IDataColumn, List<DataInfo>> dataValueInfoMap;

    public AbstractProcessInstanceView(String type) {
        super(type);
    }

    protected String getDurationPattern(Object[] parameters) {
        return (String)parameters[6];
    }

    protected String getWorktimePattern(Object[] parameters) {
        return (String)parameters[7];
    }

    protected boolean useIntervalEnds(Object[] parameters) {
        return Boolean.valueOf((String)parameters[8]);
    }

    protected boolean useOuterJoins(Object[] parameters) {
        return Boolean.valueOf((String)parameters[9]);
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[4];
        String endDateParam = (String)parameters[5];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    protected StringBuffer getBaseTimeSqlFragment(Object[] parameters) {
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        StringBuffer buffer = new StringBuffer();
        DbColumn startTime = new DbColumn("startTime", "pi");
        buffer.append(startTime).append(" >= ").append(startEnd.getFirst());
        buffer.append(" and ");
        buffer.append(startTime).append(" <= ").append(startEnd.getSecond());
        return buffer;
    }

    protected StringBuffer getCumulationTimeSqlFragment(Object[] parameters) {
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        StringBuffer buffer = new StringBuffer();
        DbColumn startTime = new DbColumn("startTime", "pi");
        DbColumn termTime = new DbColumn("terminationTime", "pi");
        buffer.append('(');
        buffer.append('(').append(this.getBaseTimeSqlFragment(parameters)).append(')').append(" or (").append(startTime).append(" < ").append(startEnd.getFirst()).append(" and (").append(termTime).append(" >= ").append(startEnd.getSecond()).append(" or ").append(termTime).append(" = 0").append("))");
        buffer.append(')');
        return buffer;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "executeQuery()");
        this.connection = connection;
        Statement ps = null;
        ResultSet rs = null;
        try {
            if (this.isCumulated()) {
                this.determineGroupByNecessity(allDeployedModels, connection, parameterValues);
            }
            String query = this.getQueryString(allDeployedModels, parameterValues, connection);
            ps = connection.prepareStatement(query, 1004, 1007);
            if (log.isDebugEnabled()) {
                log.debug("Executing query: " + query);
            }
            rs = SqlUtils.performQuery((PreparedStatement)ps, query);
            Object[][] objectArray = this.evaluateResultSet(allDeployedModels, rs, parameterValues);
            return objectArray;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            LogUtils.exitInternal(log, "executeQuery()");
        }
    }

    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters, Connection connection) throws SQLException {
        ForeignDataDescriptor provider;
        String selectFragment;
        ArrayList<DataPrefetchHint> dataPrefetchHints = new ArrayList<DataPrefetchHint>();
        ArrayList<AbstractDataColumn> dataPrefetchColumns = new ArrayList<AbstractDataColumn>();
        this.initLoginData = this.initLoginData();
        if (this.initLoginData) {
            this.authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllProcessInstances", (Class[])new Class[]{ProcessInstanceQuery.class});
            this.authPredicate = new AbstractAuthorization2Predicate(this.authorizationContext){};
            ProcessInstanceQuery processQuery = ProcessInstanceQuery.findAll();
            this.authPredicate.addPrefetchDataHints((Query)processQuery);
            FilterAndTerm filters = processQuery.getFilter();
            for (Object filter : filters.getParts()) {
                if (!(filter instanceof DataPrefetchHint)) continue;
                DataPrefetchHint dataPrefetchHint = (DataPrefetchHint)filter;
                dataPrefetchHints.add(dataPrefetchHint);
                if (StringUtils.isNotEmpty((String)dataPrefetchHint.getAttributeName())) {
                    StructDataPrefetchColumn dataColumn = new StructDataPrefetchColumn((View)this, null, null, String.class, dataPrefetchHint.getAttributeName());
                    dataColumn.setColumnProvider(new StructDataDescriptor((View)this, dataPrefetchHint));
                    dataPrefetchColumns.add(dataColumn);
                    continue;
                }
                dataPrefetchColumns.add(new DataPrefetchColumn(this, dataPrefetchHint));
            }
            ArrayList<Object> fieldRefs = new ArrayList<Object>();
            fieldRefs.add(null);
            this.authPredicate.setSelectionExtension(dataPrefetchColumns.size() * -2, fieldRefs);
        }
        ArrayList<IDataColumn> dataColumns = new ArrayList<IDataColumn>(ViewUtils.getDataColumns(this));
        dataColumns.addAll(dataPrefetchColumns);
        this.dataValueInfoMap = this.getDataInfos(dataColumns);
        Map<IDataColumn, List<DataJoinInfo>> joinInfoMap = SqlUtils.getJoinInfo(allDeployedModels, dataColumns, this.dataValueInfoMap);
        this.dataMapper = new Data2ClusterMapper(this, dataColumns, parameters, this.useOuterJoins(parameters), joinInfoMap);
        DataColumnJoinStructure dataColumnJoinStructure = SqlUtils.getJoinStructure(dataColumns, this.dataMapper);
        StringBuffer buffer = new StringBuffer();
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("model", "p"), new DbColumn("id", "p"), new DbColumn("oid", "p"), new DbColumn("name", "p"), new DbColumn("description", "p"), new DbColumn("oid", "pi"), new DbColumn("state", "pi"), new DbColumn("startingUser", "pi"), new DbColumn("startingActivityInstance", "pi"), new DbColumn("rootProcessInstance", "pi"), new DbColumn("startTime", "pi"), new DbColumn("terminationTime", "pi"), new DbColumn("scopeProcessInstance", "pi")});
        buffer.append("select ").append(selectList);
        if (this.isAddingTotalActiveTimeColumn()) {
            buffer.append(", piat.active_time_in_ms, spiat.sub_active_time_in_ms").append(", spiat.sub_pi_starttime, spiat.sub_pi_termtime");
        }
        HashSet<ForeignDataDescriptor> processedColumnProviders = new HashSet<ForeignDataDescriptor>();
        HashMap columnProvidersByGroupColumn = new HashMap();
        for (Object rawProvider : this.getColumnProvider()) {
            if (!(rawProvider instanceof ColumnProvider)) continue;
            ColumnProvider columnProvider = (ColumnProvider)rawProvider;
            Iterator columnIter = columnProvider.getGroupColumns().iterator();
            while (columnIter.hasNext()) {
                columnProvidersByGroupColumn.put(columnIter.next(), columnProvider);
            }
        }
        Object iterator = new UserDefinedColumnsIterator(this.getGroupColumns().iterator());
        int activityMetricsIndex = 0;
        while (iterator.hasNext()) {
            Object rawProvider;
            Object foreignDataColumn;
            GroupColumn groupColumn = (GroupColumn)iterator.next();
            if (groupColumn instanceof IDataColumn) {
                IDataColumn dataColumn = (IDataColumn)((Object)groupColumn);
                selectFragment = this.dataMapper.getSelectFragment(dataColumn);
                buffer.append(", ").append(selectFragment);
                continue;
            }
            if (groupColumn instanceof ActivityMetricsColumn) {
                DbColumn name;
                String alias;
                ActivityMetricsColumn activityMetricsColumn = (ActivityMetricsColumn)groupColumn;
                if (activityMetricsColumn.getFromActivityID() != null) {
                    buffer.append(',');
                    alias = "ai" + ++activityMetricsIndex;
                    name = activityMetricsColumn.getFromActivityEvent().equals("START") ? new DbColumn("startTime", alias) : new DbColumn("lastModificationTime", alias);
                    buffer.append(name);
                }
                buffer.append(',');
                alias = "ai" + ++activityMetricsIndex;
                name = activityMetricsColumn.getToActivityEvent().equals("START") ? new DbColumn("startTime", alias) : new DbColumn("lastModificationTime", alias);
                buffer.append(name);
                continue;
            }
            if (!(groupColumn instanceof ForeignDataColumn) || processedColumnProviders.contains(((ForeignDataColumn)(foreignDataColumn = (ForeignDataColumn)groupColumn)).getColumnProvider()) || !((rawProvider = columnProvidersByGroupColumn.get(groupColumn)) instanceof ForeignDataDescriptor)) continue;
            provider = (ForeignDataDescriptor)rawProvider;
            for (ForeignDataColumn column : provider.getGroupColumns()) {
                buffer.append(", ");
                buffer.append(String.valueOf(provider.getName()) + "." + column.getForeignColumnName());
            }
            processedColumnProviders.add(provider);
        }
        for (IDataPrefetchColumn iDataPrefetchColumn : dataPrefetchColumns) {
            selectFragment = this.dataMapper.getSelectFragment(iDataPrefetchColumn);
            buffer.append(", ").append(selectFragment);
        }
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName(dbDescriptor.quoteIdentifier("process_definition")), "p"));
        String string = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "p"), new DbColumn("processDefinition", "pi")}, " = ");
        String predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "p"), new DbColumn("model", "pi")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName(dbDescriptor.quoteIdentifier("process_instance"))).append(" pi").append(DbUtils.getAndOnFragment(string, predicate2));
        if (this.isAddingTotalActiveTimeColumn()) {
            buffer.append(" inner join ").append(this.getPiActiveTimeView("piat")).append(" on (pi.oid = piat.processinstance)");
            String spiatFilter = this.getParameterFilters(parameters, new IncludeAliasFilterEvaluator("spiat"), true);
            buffer.append(" left outer join ").append(this.getSubPiActiveTimeView("spiat")).append(" on (pi.oid = spiat.processinstance");
            if (!StringUtils.isEmpty((String)spiatFilter)) {
                buffer.append(spiatFilter);
            }
            buffer.append(")");
        }
        iterator = new UserDefinedColumnsIterator(this.getGroupColumns().iterator());
        activityMetricsIndex = 0;
        while (iterator.hasNext()) {
            GroupColumn groupColumn = (GroupColumn)iterator.next();
            if (!(groupColumn instanceof ActivityMetricsColumn)) continue;
            ActivityMetricsColumn activityMetricsColumn = (ActivityMetricsColumn)groupColumn;
            if (activityMetricsColumn.getFromActivityID() != null) {
                buffer.append(activityMetricsColumn.getAnsiJoins(++activityMetricsIndex));
            }
            buffer.append(activityMetricsColumn.getAnsiJoins(++activityMetricsIndex));
        }
        buffer.append(dataColumnJoinStructure);
        if (this.dataMapper.foundClusterConfig()) {
            List<String> clusterJoins = this.dataMapper.getClusterJoins();
            for (String clusterJoin : clusterJoins) {
                buffer.append(clusterJoin);
            }
        }
        for (Object rawProvider : this.getColumnProvider()) {
            if (!(rawProvider instanceof ForeignDataDescriptor)) continue;
            provider = (ForeignDataDescriptor)rawProvider;
            GroupColumn joinColumn = this.findGroupColumnByName(provider.getJoinColumnName());
            if (joinColumn instanceof ModelPropertyColumn) {
                throw new IllegalArgumentException(ReportingCommon_Messages.AbstractProcessInstanceView_ExceptionJoinOnModelPropertyColumnsIsNotSupported);
            }
            DbColumnRef dbColumnRef = joinColumn.getDbColumnRef();
            if (dbColumnRef == null) {
                throw new UnsupportedOperationException(NLS.bind((String)ReportingCommon_Messages.ColumnNotSupportedAsJoinColumn, (Object)joinColumn.getName()));
            }
            buffer.append(provider.getForeignJoin(joinColumn));
        }
        buffer.append(" where ");
        buffer.append(this.getWhereString(parameters));
        DbColumn startTime = new DbColumn("startTime", "pi");
        buffer.append(" order by ").append(startTime.getQualifiedName());
        return buffer.toString();
    }

    @Override
    public String getWhereString(Object[] parameters) {
        StringBuffer buffer = new StringBuffer(500);
        if (this.isCumulated()) {
            buffer.append(this.getCumulationTimeSqlFragment(parameters));
        } else {
            buffer.append(this.getBaseTimeSqlFragment(parameters));
        }
        ArrayList<String> excludeAliases = new ArrayList<String>();
        excludeAliases.add("spiat");
        if (this.isAddingTotalActiveTimeColumn()) {
            excludeAliases.add("pi");
        }
        buffer.append(this.getParameterFilters(parameters, new ExcludeAliasFilterEvaluator(excludeAliases), true));
        if (this.isUsingExpressionBuilder()) {
            buffer.append(this.getWhereExpressionFragment(parameters, true));
        }
        UserDefinedColumnsIterator iterator = new UserDefinedColumnsIterator(this.getGroupColumns().iterator());
        int activityMetricsIndex = 0;
        while (iterator.hasNext()) {
            GroupColumn groupColumn = (GroupColumn)iterator.next();
            String parameterFilter = null;
            if (!this.isUsingExpressionBuilder()) {
                String value;
                int index;
                GroupColumn dataColumn;
                if (groupColumn instanceof DataColumn) {
                    dataColumn = (DataColumn)groupColumn;
                    index = ((DataColumn)dataColumn).getValueFilterParameter().getIndex();
                    value = parameters[index - 1].toString();
                    if (!StringUtils.isEmpty((String)value) && !ViewUtils.isSelectAllWildcard(value)) {
                        parameterFilter = null;
                        if (this.dataMapper.foundClusterConfig()) {
                            parameterFilter = this.dataMapper.getDataValueFilter((IDataColumn)((Object)dataColumn));
                        }
                        if (StringUtils.isEmpty(parameterFilter)) {
                            parameterFilter = ((DataColumn)dataColumn).getDataValueFilter(parameters);
                        }
                        buffer.append(" and ");
                        buffer.append(parameterFilter);
                    }
                } else if (groupColumn instanceof StructDataColumn) {
                    StructDataColumn sdColumn = (StructDataColumn)groupColumn;
                    index = sdColumn.getValueFilterParameter().getIndex();
                    value = parameters[index - 1].toString();
                    if (!StringUtils.isEmpty((String)value) && !ViewUtils.isSelectAllWildcard(value)) {
                        parameterFilter = null;
                        if (this.dataMapper.foundClusterConfig()) {
                            parameterFilter = this.dataMapper.getDataValueFilter(sdColumn);
                        }
                        if (StringUtils.isEmpty((String)parameterFilter)) {
                            parameterFilter = sdColumn.getDataValueFilter(parameters);
                        }
                        buffer.append(" and ");
                        buffer.append(parameterFilter);
                    }
                } else if (groupColumn instanceof ForeignDataColumn && !StringUtils.isEmpty((String)(value = parameters[(index = ((ForeignDataColumn)(dataColumn = (ForeignDataColumn)groupColumn)).getValueFilterParameter().getIndex()) - 1].toString())) && !ViewUtils.isSelectAllWildcard(value)) {
                    parameterFilter = ((ForeignDataColumn)dataColumn).getDataValueFilter(parameters);
                    buffer.append(" and ");
                    buffer.append(parameterFilter);
                }
            }
            if (!(groupColumn instanceof ActivityMetricsColumn)) continue;
            ActivityMetricsColumn activityMetricsColumn = (ActivityMetricsColumn)groupColumn;
            if (activityMetricsColumn.getFromActivityID() != null) {
                buffer.append(" and ");
                buffer.append("a");
                buffer.append(++activityMetricsIndex);
                buffer.append(".id = '");
                buffer.append(activityMetricsColumn.getFromActivityID());
                buffer.append("'");
            }
            buffer.append(" and ");
            buffer.append(" a");
            buffer.append(++activityMetricsIndex);
            buffer.append(".id = '");
            buffer.append(activityMetricsColumn.getToActivityID());
            buffer.append("'");
        }
        buffer.append(this.getModelSelectionFragment(" AND ", parameters));
        return buffer.toString();
    }

    @Override
    public boolean canUseExpressionBuilder() {
        return true;
    }

    public void setWorktimeCalculator(IWorktimeCalculator worktimeCalculator) {
        this.worktimeCalculator = worktimeCalculator;
    }

    protected static boolean matchValueInSecondsToPattern(Long seconds, String pattern) {
        boolean result;
        if (pattern.trim().equals("%")) {
            result = true;
        } else {
            String[] parts = pattern.split(",");
            long lowerBound = Long.MIN_VALUE;
            long upperBound = Long.MAX_VALUE;
            try {
                if (parts.length != 0) {
                    if (parts.length == 1) {
                        parts[0] = AbstractProcessInstanceView.reformatPatternPart(parts[0], lowerBound);
                        lowerBound = Math.max(lowerBound, Long.parseLong(parts[0]));
                    } else if (parts.length >= 2) {
                        parts[0] = AbstractProcessInstanceView.reformatPatternPart(parts[0], lowerBound);
                        parts[1] = AbstractProcessInstanceView.reformatPatternPart(parts[1], upperBound);
                        lowerBound = Math.max(lowerBound, Long.parseLong(parts[0]));
                        upperBound = Math.min(upperBound, Long.parseLong(parts[1]));
                    }
                }
                result = seconds >= lowerBound && seconds <= upperBound;
            }
            catch (RuntimeException runtimeException) {
                result = true;
                log.error(MessageFormat.format("Cannot evaluate pattern: {0}. Returning {1}", pattern, result));
            }
        }
        return result;
    }

    private static NumberFormat createNongroupingNumberFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    private static String reformatPatternPart(String patternPart, long defaultValue) {
        if ((patternPart = patternPart.trim()).length() == 0 || patternPart.equals("%")) {
            patternPart = new Long(defaultValue).toString();
        }
        return patternPart;
    }

    private String getPiActiveTimeView(String alias) {
        StringBuffer buffer = new StringBuffer(300);
        String mqtName = SqlUtils.getMqtForSubQuery(this, "PiActiveTime");
        if (!StringUtils.isEmpty((String)mqtName)) {
            buffer.append(mqtName);
        } else {
            NumberFormat numberFormat = AbstractProcessInstanceView.createNongroupingNumberFormat();
            String conditionalDiff = MessageFormat.format("case when {0} = 0 then {1} - {2} else {0} - {2} end", this.aihField("untilTimestamp"), numberFormat.format(new Date().getTime()), this.aihField("fromTimestamp"));
            buffer.append('(');
            buffer.append("SELECT ").append(this.pihField("processInstance")).append(", ").append(" SUM(").append(conditionalDiff).append(") active_time_in_ms ").append("  FROM ").append(this.getQualifiedTableName("procinst_hierarchy")).append(" ").append("pih").append(" INNER JOIN ").append(this.getQualifiedTableName("act_inst_history")).append(" ").append("aih").append(" ON (").append(this.pihField("subProcessInstance")).append(" = ").append(this.aihField("processInstance")).append(") ").append(" WHERE ").append(this.aihField("state")).append(" = 1").append(" GROUP BY ").append(this.pihField("processInstance"));
            buffer.append(')');
        }
        if (!StringUtils.isEmpty((String)alias)) {
            buffer.append(" ").append(alias).append(" ");
        }
        return buffer.toString();
    }

    private String getSubPiActiveTimeView(String alias) {
        StringBuffer buffer = new StringBuffer(300);
        String mqtName = SqlUtils.getMqtForSubQuery(this, "SubPiActiveTime");
        if (!StringUtils.isEmpty((String)mqtName)) {
            buffer.append(mqtName);
        } else {
            buffer.append('(');
            buffer.append("SELECT ").append(" ai.processinstance, ai.OID ai_oid, ").append(" pd.ID sub_pd_id, ").append(" pin.OID sub_pi_oid, ").append(" pin.STARTTIME sub_pi_starttime, ").append(" pin.TERMINATIONTIME sub_pi_termtime, ").append(" piat.ACTIVE_TIME_IN_MS sub_active_time_in_ms ").append("FROM ").append(this.getQualifiedTableName("activity_instance ai")).append(" INNER JOIN ").append(this.getQualifiedTableName("process_instance pin")).append(" ON (ai.OID = pin.STARTINGACTIVITYINSTANCE) ").append(" INNER JOIN ").append(this.getQualifiedTableName("process_definition pd")).append(" ON (pin.PROCESSDEFINITION = pd.OID and pin.MODEL = pd.MODEL) ").append(" INNER JOIN ").append(this.getPiActiveTimeView("piat")).append(" ON (pin.OID = piat.PROCESSINSTANCE)");
            buffer.append(')');
        }
        if (!StringUtils.isEmpty((String)alias)) {
            buffer.append(" ").append(alias).append(" ");
        }
        return buffer.toString();
    }

    private static class ExcludeAliasFilterEvaluator
    extends IncludeAliasFilterEvaluator {
        public ExcludeAliasFilterEvaluator(List aliases) {
            super(aliases);
        }

        public ExcludeAliasFilterEvaluator(String alias) {
            super(alias);
        }

        public ExcludeAliasFilterEvaluator(String[] aliases) {
            super(aliases);
        }

        @Override
        public boolean applyFilter(Parameter parameter) {
            return !super.applyFilter(parameter);
        }
    }

    private static class IncludeAliasFilterEvaluator
    implements View.ParametersFilterEvaluator {
        List aliases;

        public IncludeAliasFilterEvaluator(String alias) {
            this(new String[]{alias});
        }

        public IncludeAliasFilterEvaluator(String[] aliases) {
            this(Arrays.asList(aliases));
        }

        public IncludeAliasFilterEvaluator(List aliases) {
            this.aliases = aliases;
        }

        @Override
        public boolean applyFilter(Parameter parameter) {
            if (!StringUtils.isEmpty((String)parameter.getColumnID())) {
                Tokenizer tokenizer = new Tokenizer(parameter.getColumnID(), "\\.");
                if (tokenizer.size() == 1) {
                    return false;
                }
                return this.aliases.contains(tokenizer.getToken(0));
            }
            return false;
        }
    }
}

