/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.util.List;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ModelUtils;

public class ActiveModelsView
extends View {
    public static final String MODEL_VIEW_REPORT_TYPE = "ActiveModelsView";

    public ActiveModelsView() {
        super("LogEntry");
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class));
        this.addGroupColumn(new GroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class));
        this.addGroupColumn(new GroupColumn(this, "Active Version", ReportingCommon_Messages.ColumnActiveVersion, String.class));
        this.addGroupColumn(new GroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, String.class));
        this.addGroupColumn(new GroupColumn(this, "Description", ReportingCommon_Messages.ColumnDescription, String.class));
    }

    @Override
    public String getReportType() {
        return MODEL_VIEW_REPORT_TYPE;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        List<IModel> activeModels = ModelUtils.findActiveModels(allDeployedModels);
        Localizer localizer = new Localizer(allDeployedModels);
        int resultSize = activeModels.size();
        Object[][] results = new Object[resultSize][5];
        int i = 0;
        while (i < activeModels.size()) {
            IModel model = activeModels.get(i);
            long modelOid = model.getModelOID();
            results[i][0] = model.getId();
            String modelName = model.getName();
            modelName = localizer.localizeModelName(modelOid, modelName);
            results[i][1] = modelName;
            results[i][2] = model.getStringAttribute("carnot:engine:version");
            results[i][3] = model.getModelOID();
            String modelDescription = model.getDescription();
            modelDescription = localizer.localizeModelDescription(modelOid, modelName);
            results[i][4] = modelDescription;
            ++i;
        }
        return results;
    }
}

