/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.ActivityInstanceQuery;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.CumulationAspect;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.ICumulationAspect;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class ActivityInstanceStateChangeView
extends View {
    protected static final int RS_COL_MODEL_ID = 1;
    private static final int RS_COL_A_MODEL = 2;
    private static final int RS_COL_A_ID = 3;
    private static final int RS_COL_A_NAME = 5;
    private static final int RS_COL_A_DESCRIPTION = 6;
    private static final int RS_COL_P_ID = 7;
    private static final int RS_COL_P_NAME = 8;
    private static final int RS_COL_P_DESCRIPTION = 9;
    private static final int RS_COL_AI_OID = 10;
    private static final int RS_COL_AI_STATE = 11;
    private static final int RS_COL_AI_CURRENT_PERFORMER = 12;
    private static final int RS_COL_AI_CURRENT_USER_PERFORMER = 13;
    private static final int RS_COL_AI_PERFORMED_BY = 14;
    private static final int RS_COL_PI_OID = 15;
    private static final int RS_COL_AI_START_TIME = 16;
    private static final int RS_COL_AI_LAST_MODIFICATION_TIME = 17;
    private static final int RS_COL_AIH_STATE = 18;
    private static final int RS_COL_AIH_FROM = 19;
    private static final int RS_COL_AIH_UNTIL = 20;
    private static Logger log = LogUtils.getLogger(ActivityInstanceStateChangeView.class);

    public ActivityInstanceStateChangeView() {
        super("ActivityInstanceStateChange");
        DbColumn pId = new DbColumn("id", "pd");
        DbColumn piOid = new DbColumn("oid", "pi");
        DbColumn piState = new DbColumn("state", "pi");
        DbColumn aId = new DbColumn("id", "ad");
        DbColumn aiOid = new DbColumn("oid", "ai");
        DbColumn aiState = new DbColumn("state", "ai");
        this.addParameter(ReportingCommon_Messages.ColumnProcessDefinitionId, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false, Parameter.STRING_DEFAULT_VALUE, piOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceState, Integer.class, false, "2", piState.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityId, String.class, false, Parameter.STRING_DEFAULT_VALUE, aId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityInstanceOid, Long.class, false, Parameter.STRING_DEFAULT_VALUE, aiOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityInstanceState, Integer.class, false, "2", aiState.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(this.createPredefinedColumn("Model", ReportingCommon_Messages.ColumnModel, String.class, false, new DbColumnRef("id", "model", "m")));
        this.addGroupColumn(this.createPredefinedColumn("ID", ReportingCommon_Messages.ColumnId, String.class, false, new DbColumnRef("id", "activity", "a")));
        this.addGroupColumn(this.createPredefinedColumn("Name", ReportingCommon_Messages.ColumnName, String.class, false, new DbColumnRef("name", "activity", "a")));
        this.addGroupColumn(this.createPredefinedColumn("Description", ReportingCommon_Messages.ColumnDescription, String.class, false, new DbColumnRef("description", "activity", "a")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessID", ReportingCommon_Messages.ColumnProcessId, String.class, false, new DbColumnRef("id", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessName", ReportingCommon_Messages.ColumnProcessName, String.class, false, new DbColumnRef("name", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessDescription", ReportingCommon_Messages.ColumnProcessDescription, String.class, false, new DbColumnRef("description", "process_definition", "p")));
        this.addGroupColumnCumulated(new GroupColumn((View)this, "IntervalTimestamp", ReportingCommon_Messages.ColumnIntervalTimeStamp, Timestamp.class, true, false));
        this.addGroupColumnCumulated(new GroupColumn((View)this, "Volume", ReportingCommon_Messages.ColumnVolume, Integer.class, true, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("OID", ReportingCommon_Messages.ColumnOid, Long.class, false, new DbColumnRef("oid", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("State", ReportingCommon_Messages.ColumnState, String.class, false, new DbColumnRef("state", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("ProcessInstanceOID", ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false, new DbColumnRef("processInstance", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("CurrentPerformerOID", ReportingCommon_Messages.ColumnCurrentPerformerOid, Long.class, false, new DbColumnRef("currentPerformer", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("CurrentUserPerformerOID", ReportingCommon_Messages.ColumnUserPerformerOid, Long.class, false, new DbColumnRef("currentUserPerformer", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("PerformedByOID", ReportingCommon_Messages.ColumnPerformedByOid, Long.class, false, new DbColumnRef("performedBy", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartTimestamp", ReportingCommon_Messages.ColumnStartTimeStamp, Timestamp.class, false, new DbColumnRef("startTime", "activity_instance", "ai")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("EndTimestamp", ReportingCommon_Messages.ColumnEndTimeStamp, Timestamp.class, false, new DbColumnRef("lastModificationTime", "activity_instance", "ai")));
        this.addGroupColumn(new GroupColumn((View)this, "TotalActivityDuration", ReportingCommon_Messages.ColumnTotalActivityDuration, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "ActiveTime", ReportingCommon_Messages.ColumnActiveTime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "SuspendedTime", ReportingCommon_Messages.ColumnSuspendedTime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "InterruptedTime", ReportingCommon_Messages.ColumnInterruptedTime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "TotalStateChangesCount", ReportingCommon_Messages.ColumnTotalStateChangesCount, Integer.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "ActivationCount", ReportingCommon_Messages.ColumnActivationCount, Integer.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "SuspendCount", ReportingCommon_Messages.ColumnSuspendCount, Integer.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "InterruptionCount", ReportingCommon_Messages.ColumnInterruptionCount, Integer.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "CompletionCount", ReportingCommon_Messages.ColumnCompletionCount, Integer.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "AbortionCount", ReportingCommon_Messages.ColumnAbortionCount, Integer.class, true, true));
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[6];
        String endDateParam = (String)parameters[7];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[8];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[9];
    }

    @Override
    protected int getUncumulatedTimestampColumnIndex() {
        return 13;
    }

    @Override
    protected int getCumulatedTimestampColumnIndex() {
        return 7;
    }

    @Override
    protected int getCumulatedVolumeColumnIndex() {
        return 8;
    }

    @Override
    public String getReportType() {
        return "ActivityInstance";
    }

    @Override
    public boolean canBeCumulated() {
        return true;
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("model", "ad"), new DbColumn("id", "ad"), new DbColumn("oid", "ad"), new DbColumn("name", "ad"), new DbColumn("description", "ad"), new DbColumn("id", "pd"), new DbColumn("name", "pd"), new DbColumn("description", "pd"), new DbColumn("oid", "ai"), new DbColumn("state", "ai"), new DbColumn("currentPerformer", "ai"), new DbColumn("currentUserPerformer", "ai"), new DbColumn("performedBy", "ai"), new DbColumn("oid", "pi"), new DbColumn("startTime", "ai"), new DbColumn("lastModificationTime", "ai"), new DbColumn("state", "aih"), new DbColumn("fromTimestamp", "aih"), new DbColumn("untilTimestamp", "aih"), new DbColumn("scopeProcessInstance", "pi")});
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("select ").append(selectList);
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("activity"), "ad"));
        String onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processDefinition", "ad"), new DbColumn("oid", "pd")}, " = ");
        String onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ad"), new DbColumn("model", "pd")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_definition")).append(' ').append("pd").append(DbUtils.getAndOnFragment(onFrag1, onFrag2));
        onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "ad"), new DbColumn("activity", "ai")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ad"), new DbColumn("model", "ai")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity_instance")).append(' ').append("ai").append(DbUtils.getAndOnFragment(onFrag1, onFrag2));
        onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "ai"), new DbColumn("activityInstance", "aih")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("act_inst_history")).append(' ').append("aih").append(DbUtils.getOnFragment(onFrag1));
        onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "pd"), new DbColumn("processDefinition", "pi")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "pd"), new DbColumn("model", "pi")}, " = ");
        String onFrag3 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", "ai"), new DbColumn("oid", "pi")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_instance")).append(' ').append("pi").append(DbUtils.getAndOnFragment(onFrag1, onFrag2, onFrag3));
        buffer.append(" where ");
        String startTime = this.aiField("startTime");
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        buffer.append(' ').append(startTime).append(" >= ").append(startEnd.getFirst());
        buffer.append(" and ").append(startTime).append(" <= ").append(startEnd.getSecond());
        String parameterFilters = this.getParameterFilters(parameters);
        if (!StringUtils.isEmpty((String)parameterFilters)) {
            buffer.append(parameterFilters);
        }
        buffer.append(this.getModelSelectionFragment(" AND ", parameters));
        buffer.append(" ORDER BY ai.oid, " + this.aihField("fromTimestamp"));
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        Localizer localizer = new Localizer(allDeployedModels);
        boolean initLoginData = this.initLoginData();
        boolean canFetchActivity = true;
        try {
            Pair<Long, Long> startEnd = this.getStartEnd(parameterValues);
            long startTime = (Long)startEnd.getFirst();
            long endTime = (Long)startEnd.getSecond();
            List rows = new ArrayList();
            CumulationAspect cumulationAspect = null;
            if (this.isCumulated()) {
                cumulationAspect = new CumulationAspect(this, startTime, endTime);
            }
            AiHistoryContext context = new AiHistoryContext();
            Object[] row = null;
            while (resultSet.next()) {
                long modelOid = resultSet.getLong(2);
                long activityRtOid = resultSet.getLong(4);
                long currentPerformer = resultSet.getLong(12);
                long currentUserPerformer = resultSet.getLong(13);
                long department = resultSet.getLong(18);
                long scopeProcessInstanceOid = resultSet.getLong(21);
                if (initLoginData) {
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllActivityInstances", (Class[])new Class[]{ActivityInstanceQuery.class});
                    authorizationContext.setActivityDataWithScopePi(scopeProcessInstanceOid, activityRtOid, modelOid, currentPerformer, currentUserPerformer, department);
                    canFetchActivity = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                }
                if (!canFetchActivity) continue;
                row = new Object[this.getLeafFields().size()];
                if (context.isInitialized() && context.currentAiOid != resultSet.getLong(10)) {
                    this.finalizeAiHistory(context, row, rows, cumulationAspect);
                    context.reset();
                }
                if (!context.isInitialized()) {
                    context.initialize(resultSet.getLong(10), resultSet.getInt(11));
                }
                row[0] = resultSet.getString(1);
                String activityId = resultSet.getString(3);
                row[1] = activityId;
                String activityName = resultSet.getString(5);
                String activityDescription = resultSet.getString(6);
                String processId = resultSet.getString(7);
                activityName = localizer.localizeActivityName(modelOid, processId, activityId, activityName);
                activityDescription = localizer.localizeActivityDescription(modelOid, processId, activityId, activityDescription);
                row[2] = activityName;
                row[3] = activityDescription;
                row[4] = processId;
                String processName = resultSet.getString(8);
                String processDescription = resultSet.getString(9);
                processName = localizer.localizeProcessName(modelOid, processId, processName);
                processDescription = localizer.localizeProcessDescription(modelOid, processId, processDescription);
                row[5] = processName;
                row[6] = processDescription;
                row[7] = new Long(context.currentAiOid);
                row[8] = localizer.localizeStateString(context.currentAiState);
                row[9] = new Long(resultSet.getLong(15));
                row[10] = new Long(resultSet.getLong(12));
                row[11] = new Long(resultSet.getLong(13));
                row[12] = new Long(resultSet.getLong(14));
                row[13] = new Timestamp(resultSet.getLong(16));
                if (0L == resultSet.getLong(17)) {
                    row[14] = null;
                    row[15] = new Long((System.currentTimeMillis() - resultSet.getLong(16)) / 1000L);
                } else {
                    row[14] = new Timestamp(resultSet.getLong(17));
                    row[15] = new Long((resultSet.getLong(17) - resultSet.getLong(16)) / 1000L);
                }
                int currentState = resultSet.getInt(18);
                long tsFrom = resultSet.getLong(19);
                long tsUntil = resultSet.getLong(20);
                if (currentState != 0 && currentState != 2 && currentState != 6) {
                    ++context.totalStateChangeCount;
                }
                switch (currentState) {
                    case 1: {
                        context.totalActiveTime += (tsUntil - tsFrom) / 1000L;
                        ++context.activationCount;
                        break;
                    }
                    case 5: {
                        context.totalSuspendedTime += (tsUntil - tsFrom) / 1000L;
                        ++context.suspendCount;
                        break;
                    }
                    case 4: {
                        context.totalInterruptedTime += (tsUntil - tsFrom) / 1000L;
                        ++context.interruptionCount;
                        break;
                    }
                    case 2: {
                        ++context.completionCount;
                        break;
                    }
                    case 6: {
                        ++context.abortionCount;
                    }
                }
            }
            if (row != null && context.isInitialized()) {
                this.finalizeAiHistory(context, row, rows, cumulationAspect);
            }
            if (this.isCumulated()) {
                rows = cumulationAspect.getCumulatedRows();
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void finalizeAiHistory(AiHistoryContext context, Object[] row, List rows, ICumulationAspect cumulationAspect) {
        switch (context.currentAiState) {
            case 2: {
                ++context.totalStateChangeCount;
                ++context.completionCount;
                break;
            }
            case 6: {
                ++context.totalStateChangeCount;
                ++context.abortionCount;
            }
        }
        row[16] = new Long(context.totalActiveTime);
        row[17] = new Long(context.totalSuspendedTime);
        row[18] = new Long(context.totalInterruptedTime);
        row[19] = new Integer(context.totalStateChangeCount);
        row[20] = new Integer(context.activationCount);
        row[21] = new Integer(context.suspendCount);
        row[22] = new Integer(context.interruptionCount);
        row[23] = new Integer(context.completionCount);
        row[24] = new Integer(context.abortionCount);
        if (this.isCumulated()) {
            cumulationAspect.processRow(row);
        } else {
            rows.add(row);
        }
    }

    private static class AiHistoryContext {
        public long currentAiOid;
        public int currentAiState;
        public int totalStateChangeCount;
        public int activationCount;
        public int suspendCount;
        public int interruptionCount;
        public int completionCount;
        public int abortionCount;
        public long totalActiveTime;
        public long totalSuspendedTime;
        public long totalInterruptedTime;

        public AiHistoryContext() {
            this.reset();
        }

        public void initialize(long aiOid, int aiState) {
            this.currentAiOid = aiOid;
            this.currentAiState = aiState;
        }

        public boolean isInitialized() {
            return 0L != this.currentAiOid;
        }

        public void reset() {
            this.currentAiOid = 0L;
            this.currentAiState = 0;
            this.totalStateChangeCount = 0;
            this.activationCount = 0;
            this.suspendCount = 0;
            this.interruptionCount = 0;
            this.completionCount = 0;
            this.abortionCount = 0;
            this.totalActiveTime = 0L;
            this.totalSuspendedTime = 0L;
            this.totalInterruptedTime = 0L;
        }
    }
}

