/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelProviderView;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class ConsumedProcessInterfacesView
extends View {
    public static final String MODEL_VIEW_REPORT_TYPE = "ConsumedProcessInterfacesView";
    private static Logger log = LogUtils.getLogger(ConsumedProcessInterfacesView.class);

    public ConsumedProcessInterfacesView() {
        super(MODEL_VIEW_REPORT_TYPE);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class));
        this.addGroupColumn(new GroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class));
        this.addGroupColumn(new GroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, String.class));
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[0];
    }

    @Override
    public String getReportType() {
        return MODEL_VIEW_REPORT_TYPE;
    }

    private Map<String, SimpleModelInfo> getUsedModels(List<IModel> allDeployedModels, Localizer localizer, Object[] parameterValues, Connection connection) {
        HashMap<String, SimpleModelInfo> usedModels = new HashMap<String, SimpleModelInfo>();
        try {
            ModelProviderView providerView = new ModelProviderView();
            providerView.setDefaultSchemaName(this.getDefaultSchemaName());
            providerView.setPartitionInfo(this.getPartitionInfo());
            String providerSql = providerView.getQueryString(allDeployedModels, parameterValues);
            PreparedStatement ps = connection.prepareStatement(providerSql);
            ResultSet rs = SqlUtils.performQuery(ps, providerSql);
            while (rs.next()) {
                String modelId = providerView.getIdColumn().getStringValue(localizer, rs);
                String modelName = providerView.getNameColumn().getStringValue(localizer, rs);
                Long modelOid = providerView.getOidColumn().getLongValue(rs);
                SimpleModelInfo info = new SimpleModelInfo(modelName, modelOid);
                usedModels.put(modelId, info);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new PublicException((Throwable)e);
        }
        return usedModels;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        Localizer localizer = new Localizer(allDeployedModels);
        Map<String, SimpleModelInfo> usedModels = this.getUsedModels(allDeployedModels, localizer, parameterValues, connection);
        String modelOIDParam = this.getModelOidParameter(parameterValues);
        long reportModelOID = ViewUtils.converToLong(modelOIDParam);
        IModel model = ConsumedProcessInterfacesView.findModelByOID(allDeployedModels, reportModelOID);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (model != null) {
            Set processInterfaces = model.getImplementedInterfaces();
            for (QName processInterface : processInterfaces) {
                String piModelId = processInterface.getNamespaceURI();
                SimpleModelInfo info = usedModels.get(piModelId);
                long piModelOid = info.getOid();
                String piModelName = info.getName();
                String piId = processInterface.getLocalPart();
                String piName = localizer.localizeProcessName(piModelOid, piId, piId);
                Object[] row = new Object[]{String.valueOf(piModelName) + " (" + piName + ")", piModelId, piModelOid};
                rows.add(row);
            }
        }
        return this.convertRowsToRowSet(rows);
    }

    private class SimpleModelInfo {
        private String name;
        private long oid;

        public SimpleModelInfo(String name, long oid) {
            this.name = name;
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public long getOid() {
            return this.oid;
        }
    }
}

