/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.io.Serializable;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;

public class Cumulants
implements Serializable {
    private static Logger log = LogUtils.getLogger(Cumulants.class);
    boolean resumed;
    private Number sum;
    private Number average;
    private Number minimum;
    private Number maximum;
    private Number deviation;
    private int volume;
    private Number sumOnResume;
    private Number averageOnResume;
    private Number minimumOnResume;
    private Number maximumOnResume;
    private Number deviationOnResume;
    private int volumeOnResume;

    public Cumulants() {
        this.resetValues();
    }

    public Number getSum() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedCumulants);
        }
        return this.sumOnResume;
    }

    public Number getAverage() {
        return this.getSum();
    }

    public Number getDeviation() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedCumulants);
        }
        return this.deviationOnResume;
    }

    public Number getMaximum() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedCumulants);
        }
        return this.maximumOnResume;
    }

    public Number getMinimum() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedCumulants);
        }
        return this.minimumOnResume;
    }

    public int getVolume() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedCumulants);
        }
        return this.volumeOnResume;
    }

    public void addValue(long value) {
        this.addValue(new Long(value));
    }

    public void addValue(double value) {
        this.addValue(new Double(value));
    }

    public void addValue(Number value) {
        if (value == null) {
            return;
        }
        if (value instanceof Float || value instanceof Double) {
            if (this.resumed) {
                this.minimum = new Double(Double.MAX_VALUE);
                this.maximum = new Double(Double.MIN_VALUE);
                this.sum = new Double(0.0);
                this.deviation = new Double(0.0);
                this.resumed = false;
            }
            ++this.volume;
            this.sum = new Double(this.sum.doubleValue() + value.doubleValue());
            this.minimum = new Double(Math.min(value.doubleValue(), this.minimum.doubleValue()));
            this.maximum = new Double(Math.max(value.doubleValue(), this.maximum.doubleValue()));
            this.deviation = new Double(this.deviation.doubleValue() + value.doubleValue() * value.doubleValue());
        } else {
            if (this.resumed) {
                this.minimum = new Long(Long.MAX_VALUE);
                this.maximum = new Long(Long.MIN_VALUE);
                this.sum = new Long(0L);
                this.deviation = new Long(0L);
                this.resumed = false;
            }
            ++this.volume;
            this.sum = new Long(this.sum.longValue() + value.longValue());
            this.minimum = new Long(Math.min(value.longValue(), this.minimum.longValue()));
            this.maximum = new Long(Math.max(value.longValue(), this.maximum.longValue()));
            this.deviation = new Long(this.deviation.longValue() + value.longValue() * value.longValue());
        }
    }

    public void resume() {
        LogUtils.enterInternal(log, "resume()");
        if (this.volume != 0) {
            double localSum = this.sum.doubleValue();
            if (this.minimum instanceof Float || this.minimum instanceof Double) {
                this.average = new Double(localSum / (double)this.volume);
                this.deviation = this.volume == 1 ? null : new Double(this.computeDeviation(this.volume, this.average.doubleValue(), localSum, this.deviation.doubleValue()));
            } else {
                this.average = new Long(Math.round(localSum / (double)this.volume));
                this.deviation = this.volume == 1 ? null : new Long(Math.round(this.computeDeviation(this.volume, this.average.doubleValue(), localSum, this.deviation.doubleValue())));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Volume: " + this.volume);
            log.debug("Minimum: " + this.minimum);
            log.debug("Maximum: " + this.maximum);
            log.debug("Average: " + this.average);
            log.debug("Sum: " + this.sum);
            log.debug("Deviation: " + this.deviation);
        }
        this.copyValuesOnResume();
        this.resetValues();
        LogUtils.exitInternal(log, "resume()");
    }

    private double computeDeviation(int volume, double average, double sum, double squareSum) {
        return Math.sqrt(squareSum / (double)(volume - 1) - 2.0 * average * sum / (double)(volume - 1) + (double)volume * average * average / (double)(volume - 1));
    }

    private void copyValuesOnResume() {
        this.sumOnResume = this.sum;
        this.averageOnResume = this.average;
        this.minimumOnResume = this.minimum;
        this.maximumOnResume = this.maximum;
        this.deviationOnResume = this.deviation;
        this.volumeOnResume = this.volume;
    }

    private void resetValues() {
        this.sum = null;
        this.average = null;
        this.minimum = null;
        this.maximum = null;
        this.deviation = null;
        this.volume = 0;
        this.resumed = true;
    }
}

