/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Iterator;
import java.util.List;

public class CumulationKeyGenerator
implements Iterator {
    private final List[] columnDomains;
    private final int[] position;

    public CumulationKeyGenerator(List[] columnDomains) {
        this.columnDomains = columnDomains;
        this.position = new int[columnDomains.length];
        int i = 0;
        while (i < columnDomains.length) {
            this.position[i] = 0;
            ++i;
        }
    }

    @Override
    public boolean hasNext() {
        return -1 != this.position[this.columnDomains.length - 1];
    }

    public Object next() {
        Object[] result = new Object[this.columnDomains.length];
        int i = 0;
        while (i < this.columnDomains.length) {
            result[i] = this.columnDomains[i].get(this.position[i]);
            ++i;
        }
        this.bumpPosition(this.columnDomains.length - 1);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean bumpPosition(int i) {
        boolean succeeded = false;
        int n = i;
        this.position[n] = this.position[n] + 1;
        if (this.position[i] < this.columnDomains[i].size()) {
            succeeded = true;
        } else if (i > 0 && this.bumpPosition(i - 1)) {
            this.position[i] = 0;
            succeeded = true;
        } else {
            this.position[i] = -1;
        }
        return succeeded;
    }
}

