/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class DataColumn
extends AbstractDataColumn {
    private static final long serialVersionUID = 1L;
    private static Logger log = LogUtils.getLogger(DataColumn.class);

    public DataColumn(View view, String name, String label, Class type, String dataID, String modelId) {
        this(view, name, label, type, dataID);
        this.setModelId(modelId);
    }

    public DataColumn(View view, String name, String label, Class type, String dataId) {
        super(view, name, label, type, false, true);
        this.setDataId(dataId);
        if (log.isDebugEnabled()) {
            log.debug("=> DataColumn(,," + type + ")");
        }
        if (!view.allowsUserDefinedDataColumns().contains(this.getClass()) && !(this instanceof IDataPrefetchColumn)) {
            throw new RuntimeException(ReportingCommon_Messages.ExceptionDataFieldsCannotBeDefinedForThisView);
        }
        this.adjustViewCumulation();
    }

    public DataColumn(View view, String name, String label, Class type, Properties properties) {
        this(view, name, label, type, properties.getProperty("dataID").length() > 0 ? properties.getProperty("dataID") : null);
        this.setModelId(properties.getProperty("modelID"));
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.valueFilterParameter.setName(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)name));
        if (log.isDebugEnabled()) {
            log.debug("Value Filter renamed to " + this.valueFilterParameter.getName());
        }
    }

    @Override
    public void setType(Class type) {
        if (log.isDebugEnabled()) {
            log.debug("=> setType(" + type + ")");
        }
        super.setType(type);
        this.adjustViewCumulation();
        this.valueFilterParameter.setType(type);
        if (this.isNumeric() || this.isBoolean()) {
            this.valueFilterParameter.setDefaultValue(Parameter.NUMERIC_DEFAULT_VALUE);
        } else {
            this.valueFilterParameter.setDefaultValue(Parameter.STRING_DEFAULT_VALUE);
        }
    }

    @Override
    public Parameter getValueFilterParameter() {
        return this.valueFilterParameter;
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<column type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' columntype='");
        buffer.append(this.getType().getName());
        buffer.append("'>\n");
        buffer.append("<property name='dataID'>" + (this.getDataId() != null ? this.getDataId() : "") + "</property>\n");
        buffer.append("<property name='modelID'>" + (this.getModelId() != null ? this.getModelId() : "") + "</property>\n");
        buffer.append("</column>\n");
        return buffer.toString();
    }

    @Override
    public String getSelectFragment() {
        String alias = this.getAlias();
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        return DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("type_key", alias), new DbColumn("string_value", alias), new DbColumn("number_value", alias), new DbColumn("oid", alias)});
    }

    @Override
    public String getAnsiJoin(List<DataJoinInfo> joinInfos, boolean useOuterJoin) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        StringBuffer buffer = new StringBuffer();
        if (useOuterJoin) {
            buffer.append(" left outer join ");
        } else {
            buffer.append(" inner join ");
        }
        String alias = this.getAlias();
        String dataValueTable = dbDescriptor.quoteIdentifier("data_value");
        buffer.append(this.getView().getQualifiedTableName(dataValueTable)).append(' ').append(alias);
        String predicate = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("scopeProcessInstance", "pi"), new DbColumn("processInstance", alias)}, " = ");
        buffer.append(" on (").append(predicate);
        buffer.append(" and ");
        int count = 0;
        if (joinInfos != null && !joinInfos.isEmpty()) {
            for (DataJoinInfo joinInfo : joinInfos) {
                if (++count > 1) {
                    buffer.append(" or ");
                }
                buffer.append(alias).append(".data = ").append(joinInfo.getDataValueInfo().getDataOid());
            }
        } else {
            buffer.append(alias).append(".data = ").append(-1);
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String getDataValueFilter(Object[] parameters) {
        StringBuffer buffer = new StringBuffer();
        String stringifiedParameterValue = parameters[this.getValueFilterParameter().getIndex() - 1].toString();
        stringifiedParameterValue = stringifiedParameterValue.replaceAll("(?i:true)", "1");
        stringifiedParameterValue = stringifiedParameterValue.replaceAll("(?i:false)", "0");
        stringifiedParameterValue = ViewUtils.replaceDateWithTimeInMillis(stringifiedParameterValue);
        String[] parameterParts = stringifiedParameterValue.split(",");
        int n = 0;
        while (n < parameterParts.length) {
            stringifiedParameterValue = parameterParts[n].trim();
            String alias = this.getAlias();
            if (this.isNumeric() || this.isBoolean()) {
                if (stringifiedParameterValue.length() != 0) {
                    if (n == 0) {
                        buffer.append(" (");
                    } else {
                        buffer.append(" or ");
                    }
                    DbColumn numberVal = new DbColumn("number_value", alias);
                    buffer.append(numberVal).append(" = ");
                    buffer.append(stringifiedParameterValue);
                }
            } else if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                if (n == 0) {
                    buffer.append(" (");
                } else {
                    buffer.append(" or ");
                }
                DbColumn stringVal = new DbColumn("string_value", alias);
                buffer.append(stringVal).append(" like '");
                buffer.append(stringifiedParameterValue);
                buffer.append("'");
            }
            ++n;
        }
        if (buffer.length() > 0) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public String getAliasedColumn() {
        String alias = this.getAlias();
        DbColumn name = this.isNumeric() || this.isBoolean() ? new DbColumn("number_value", alias) : new DbColumn("string_value", alias);
        return name.getQualifiedName();
    }

    public static Object[] determineValue(int type, String stringValue, long longValue) {
        Object[] values = new Object[2];
        switch (type) {
            case -1: {
                values[0] = null;
                values[1] = null;
                break;
            }
            case 0: {
                values[0] = "Boolean";
                values[1] = longValue == 1L ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                values[0] = "Character";
                values[1] = new Character((char)longValue);
                break;
            }
            case 2: {
                values[0] = "Byte";
                values[1] = new Byte((byte)longValue);
                break;
            }
            case 3: {
                values[0] = "Short";
                values[1] = new Short((short)longValue);
                break;
            }
            case 4: {
                values[0] = "Integer";
                values[1] = new Integer((int)longValue);
                break;
            }
            case 5: {
                values[0] = "Long";
                values[1] = new Long(longValue);
                break;
            }
            case 6: {
                values[0] = "Float";
                values[1] = new Float(stringValue);
                break;
            }
            case 7: {
                values[0] = "Double";
                values[1] = new Double(stringValue);
                break;
            }
            case 8: {
                values[0] = "String";
                values[1] = stringValue;
                break;
            }
            case 9: {
                values[0] = "Date";
                values[1] = new Long(longValue);
                break;
            }
            case 10: {
                values[0] = "Money";
                values[1] = stringValue;
                break;
            }
            case 11: {
                values[0] = "BigString";
                values[1] = stringValue;
                break;
            }
            case 12: {
                values[0] = "Serializable";
                values[1] = null;
                break;
            }
            case 13: {
                values[0] = "Object";
                values[1] = null;
                break;
            }
            case 14: {
                values[0] = "Period";
                values[1] = null;
                break;
            }
            default: {
                values[0] = "Number";
                values[1] = new Long(longValue);
            }
        }
        return values;
    }

    public static Object determineObjectValue(int type, String stringValue, long longValue) {
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return new Boolean(longValue == 1L ? "true" : "false");
            }
            case 1: {
                return new Character((char)longValue);
            }
            case 2: {
                return new Byte((byte)longValue);
            }
            case 3: {
                return new Short((short)longValue);
            }
            case 4: {
                return new Integer((int)longValue);
            }
            case 5: {
                return new Long(longValue);
            }
            case 6: {
                return new Float(stringValue);
            }
            case 7: {
                return new Double(stringValue);
            }
            case 8: {
                return stringValue;
            }
            case 9: {
                return new Date();
            }
            case 10: {
                return stringValue;
            }
            case 11: {
                return stringValue;
            }
            case 12: {
                return null;
            }
            case 13: {
                return null;
            }
            case 14: {
                return null;
            }
        }
        return new Long(longValue);
    }
}

